/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Arrays;
import java.util.Collection;

public final class FloatArray
extends DirectArrayTemplate<Float> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"array\", \"items\" : \"float\" }");

    public FloatArray() {
        this(new DataList());
    }

    public FloatArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public FloatArray(Collection<Float> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public FloatArray(DataList list) {
        super(list, SCHEMA, Float.class, Float.class);
    }

    public FloatArray(Float first, Float ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    @Override
    public FloatArray clone() throws CloneNotSupportedException {
        return (FloatArray)super.clone();
    }

    @Override
    public FloatArray copy() throws CloneNotSupportedException {
        return (FloatArray)super.copy();
    }

    @Override
    protected Object coerceInput(Float object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return DataTemplateUtil.coerceFloatInput(object);
    }

    @Override
    protected Float coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return DataTemplateUtil.coerceFloatOutput(object);
    }
}

