/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.symbol;

import com.linkedin.data.codec.symbol.SymbolTable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InMemorySymbolTable
implements SymbolTable {
    private final Map<String, Integer> _symbolNameToId;
    private final String[] _symbols;
    private final String _symbolTableName;

    public InMemorySymbolTable(String symbolTableName, List<String> symbols) {
        this._symbolTableName = symbolTableName;
        this._symbolNameToId = new HashMap<String, Integer>();
        this._symbols = new String[symbols.size()];
        for (int i = 0; i < symbols.size(); ++i) {
            String symbol = symbols.get(i);
            this._symbolNameToId.put(symbol, i);
            this._symbols[i] = symbol;
        }
    }

    @Override
    public int getSymbolId(String symbolName) {
        Integer symbolId = this._symbolNameToId.get(symbolName);
        if (symbolId != null) {
            return symbolId;
        }
        return -1;
    }

    @Override
    public String getSymbolName(int symbolId) {
        try {
            return this._symbols[symbolId];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return this._symbolTableName;
    }

    @Override
    public int size() {
        return this._symbols.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemorySymbolTable that = (InMemorySymbolTable)o;
        return Arrays.equals(this._symbols, that._symbols) && Objects.equals(this._symbolTableName, that._symbolTableName);
    }

    public int hashCode() {
        int result = Objects.hash(this._symbolTableName);
        result = 31 * result + Arrays.hashCode(this._symbols);
        return result;
    }
}

