/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec.entitystream;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.DataMapBuilder;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.codec.entitystream.AbstractDataDecoder;
import com.linkedin.data.codec.symbol.EmptySymbolTable;
import com.linkedin.data.codec.symbol.SymbolTable;
import com.linkedin.data.parser.NonBlockingDataParser;
import com.linkedin.data.protobuf.TextBuffer;
import com.linkedin.data.protobuf.Utf8Utils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;

public class ProtobufDataDecoder<T extends DataComplex>
extends AbstractDataDecoder<T> {
    protected final SymbolTable _symbolTable;

    protected ProtobufDataDecoder(SymbolTable symbolTable, EnumSet<NonBlockingDataParser.Token> expectedFirstToken) {
        super(expectedFirstToken);
        this._symbolTable = symbolTable == null ? EmptySymbolTable.SHARED : symbolTable;
    }

    @Override
    protected NonBlockingDataParser createDataParser() throws IOException {
        return new ProtobufStreamDataParser(this._symbolTable);
    }

    @Override
    protected DataComplex createDataObject(NonBlockingDataParser parser) {
        return new DataMap(DataMapBuilder.getOptimumHashMapCapacityFromSize(parser.getComplexObjSize()));
    }

    @Override
    protected DataComplex createDataList(NonBlockingDataParser parser) {
        return new DataList(parser.getComplexObjSize());
    }

    protected class ProtobufStreamDataParser
    implements NonBlockingDataParser {
        private final SymbolTable _symbolTable;
        protected final Deque<Integer> _complexObjTokenSizeStack = new ArrayDeque<Integer>();
        protected int _currComplexObjTokenSize = -1;
        private byte[] _input;
        private int _limit;
        private int _pos;
        private boolean _endOfInput;
        private final TextBuffer _textBuffer;
        private int _textBufferPos = -1;
        private byte[] _bytesBuffer;
        private int _pendingCharUtfRep;
        private int _pendingIntShifts = -1;
        private long _pendingInt64;
        private int _pendingInt32;
        private NonBlockingDataParser.Token _currentToken;
        private byte _currentOrdinal = (byte)-1;
        private byte[] _bytesValue;
        private String _stringValue;
        private int _intValue;
        private long _longValue;

        protected ProtobufStreamDataParser(SymbolTable symbolTable) {
            this._symbolTable = symbolTable == null ? EmptySymbolTable.SHARED : symbolTable;
            this._textBuffer = new TextBuffer(1024);
        }

        @Override
        public void feedInput(byte[] data, int offset, int len) throws IOException {
            if (data == null || data.length < offset + len) {
                throw new IllegalArgumentException("Bad arguments");
            }
            if (this._pos < this._limit || this._endOfInput) {
                throw new IOException("Invalid state: Parser cannot accept more data");
            }
            this._pos = offset;
            this._limit = offset + len;
            this._input = data;
        }

        @Override
        public void endOfInput() {
            this._endOfInput = true;
        }

        @Override
        public NonBlockingDataParser.Token nextToken() throws IOException {
            NonBlockingDataParser.Token currToken;
            if (this._currComplexObjTokenSize == 0) {
                this._currentToken = this.getComplexObjEndToken();
                this.finishToken(this._currentToken);
                return this._currentToken;
            }
            if (this._pos >= this._limit) {
                if (this._endOfInput) {
                    return NonBlockingDataParser.Token.EOF_INPUT;
                }
                return NonBlockingDataParser.Token.NOT_AVAILABLE;
            }
            if (this._currentToken != NonBlockingDataParser.Token.NOT_AVAILABLE) {
                this._currentOrdinal = this._input[this._pos++];
            }
            switch (this._currentOrdinal) {
                case 0: {
                    currToken = this.readInt32();
                    if (currToken != NonBlockingDataParser.Token.INTEGER) break;
                    currToken = NonBlockingDataParser.Token.START_OBJECT;
                    break;
                }
                case 1: {
                    currToken = this.readInt32();
                    if (currToken != NonBlockingDataParser.Token.INTEGER) break;
                    currToken = NonBlockingDataParser.Token.START_ARRAY;
                    break;
                }
                case 20: {
                    currToken = this.readASCIIString();
                    break;
                }
                case 2: {
                    currToken = this.readString();
                    break;
                }
                case 3: {
                    currToken = this.readStringReference();
                    break;
                }
                case 4: {
                    currToken = this.readInt32();
                    break;
                }
                case 5: {
                    currToken = this.readInt64();
                    break;
                }
                case 6: {
                    currToken = this.readInt32();
                    if (currToken != NonBlockingDataParser.Token.INTEGER) break;
                    currToken = NonBlockingDataParser.Token.FLOAT;
                    break;
                }
                case 21: {
                    currToken = this.readFixedInt32();
                    if (currToken != NonBlockingDataParser.Token.INTEGER) break;
                    currToken = NonBlockingDataParser.Token.FLOAT;
                    break;
                }
                case 7: {
                    currToken = this.readInt64();
                    if (currToken != NonBlockingDataParser.Token.LONG) break;
                    currToken = NonBlockingDataParser.Token.DOUBLE;
                    break;
                }
                case 22: {
                    currToken = this.readFixedInt64();
                    if (currToken != NonBlockingDataParser.Token.LONG) break;
                    currToken = NonBlockingDataParser.Token.DOUBLE;
                    break;
                }
                case 8: {
                    currToken = NonBlockingDataParser.Token.BOOL_TRUE;
                    break;
                }
                case 9: {
                    currToken = NonBlockingDataParser.Token.BOOL_FALSE;
                    break;
                }
                case 10: {
                    currToken = this.readByteArray();
                    break;
                }
                case 11: {
                    currToken = NonBlockingDataParser.Token.NULL;
                    break;
                }
                default: {
                    currToken = this.readUnknown();
                }
            }
            this._currentToken = currToken;
            if (this._currentToken != NonBlockingDataParser.Token.NOT_AVAILABLE) {
                this.finishToken(this._currentToken);
            }
            return this._currentToken;
        }

        private NonBlockingDataParser.Token getComplexObjEndToken() {
            if (!this._complexObjTokenSizeStack.isEmpty()) {
                this._currComplexObjTokenSize = this._complexObjTokenSizeStack.pop();
            }
            return ProtobufDataDecoder.this.isCurrList() ? NonBlockingDataParser.Token.END_ARRAY : NonBlockingDataParser.Token.END_OBJECT;
        }

        private NonBlockingDataParser.Token readStringReference() throws IOException {
            NonBlockingDataParser.Token refToken = this.readInt32();
            if (refToken == NonBlockingDataParser.Token.NOT_AVAILABLE) {
                return NonBlockingDataParser.Token.NOT_AVAILABLE;
            }
            this._stringValue = this._symbolTable.getSymbolName(this._intValue);
            if (this._stringValue == null) {
                throw new DataDecodingException("Error decoding string reference. Symbol ID: " + this._intValue);
            }
            return NonBlockingDataParser.Token.STRING;
        }

        protected void finishToken(NonBlockingDataParser.Token token) throws IOException {
            switch (token) {
                case START_OBJECT: {
                    if (this._currComplexObjTokenSize > 0) {
                        this._complexObjTokenSizeStack.push(this._currComplexObjTokenSize);
                    }
                    this._currComplexObjTokenSize = this._intValue << 1;
                    break;
                }
                case START_ARRAY: {
                    if (this._currComplexObjTokenSize > 0) {
                        this._complexObjTokenSizeStack.push(this._currComplexObjTokenSize);
                    }
                    this._currComplexObjTokenSize = this._intValue;
                    break;
                }
                default: {
                    --this._currComplexObjTokenSize;
                }
            }
        }

        public final int getCurrentOrdinal() {
            return this._currentOrdinal;
        }

        @Override
        public int getComplexObjSize() {
            return this._currentToken == NonBlockingDataParser.Token.START_OBJECT || this._currentToken == NonBlockingDataParser.Token.START_ARRAY ? this._intValue : -1;
        }

        @Override
        public String getString() throws IOException {
            if (this._currentToken != NonBlockingDataParser.Token.STRING) {
                throw new DataDecodingException("Unexpected call: String value is not available");
            }
            return this._stringValue;
        }

        @Override
        public ByteString getRawBytes() throws IOException {
            if (this._currentToken != NonBlockingDataParser.Token.RAW_BYTES) {
                throw new DataDecodingException("Unexpected call: Raw bytes value is not available");
            }
            return ByteString.unsafeWrap(this._bytesValue);
        }

        @Override
        public int getIntValue() throws IOException {
            return this._intValue;
        }

        @Override
        public long getLongValue() throws IOException {
            if (this._currentToken != NonBlockingDataParser.Token.LONG) {
                throw new DataDecodingException("Unexpected call: Raw bytes value is not available");
            }
            return this._longValue;
        }

        @Override
        public float getFloatValue() throws IOException {
            if (this._currentToken != NonBlockingDataParser.Token.FLOAT) {
                throw new DataDecodingException("Unexpected call: Raw bytes value is not available");
            }
            return Float.intBitsToFloat(this._intValue);
        }

        @Override
        public double getDoubleValue() throws IOException {
            if (this._currentToken != NonBlockingDataParser.Token.DOUBLE) {
                throw new DataDecodingException("Unexpected call: Raw bytes value is not available");
            }
            return Double.longBitsToDouble(this._longValue);
        }

        protected NonBlockingDataParser.Token readUnknown() throws IOException {
            throw new DataDecodingException("Unknown ordinal: " + this._currentOrdinal);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NonBlockingDataParser.Token readASCIIString() throws IOException {
            NonBlockingDataParser.Token sizeToken;
            if (this._textBufferPos == -1 && (sizeToken = this.readInt32()) == NonBlockingDataParser.Token.NOT_AVAILABLE) {
                return NonBlockingDataParser.Token.NOT_AVAILABLE;
            }
            int remainingSize = this._intValue;
            if (remainingSize > 0) {
                char[] resultArr;
                block10: {
                    if (this._textBufferPos == -1 && remainingSize <= this._limit - this._pos) {
                        this._stringValue = Utf8Utils.decodeASCII(this._input, this._pos, remainingSize, this._textBuffer);
                        this._pos += remainingSize;
                        return NonBlockingDataParser.Token.STRING;
                    }
                    resultArr = null;
                    try {
                        if (this._textBufferPos == -1) {
                            resultArr = this._textBuffer.getBuf(remainingSize);
                            this._textBufferPos = 0;
                        } else {
                            resultArr = this._textBuffer.getBuf();
                        }
                        while (this._pos < this._limit && remainingSize > 0) {
                            resultArr[this._textBufferPos++] = (char)this._input[this._pos++];
                            --remainingSize;
                        }
                        if (remainingSize != 0) break block10;
                        this._stringValue = new String(resultArr, 0, this._textBufferPos);
                        this._textBufferPos = -1;
                        NonBlockingDataParser.Token token = NonBlockingDataParser.Token.STRING;
                        this._textBuffer.returnBuf(resultArr);
                        return token;
                    }
                    catch (Throwable throwable) {
                        this._textBuffer.returnBuf(resultArr);
                        throw throwable;
                    }
                }
                this._intValue = remainingSize;
                NonBlockingDataParser.Token token = NonBlockingDataParser.Token.NOT_AVAILABLE;
                this._textBuffer.returnBuf(resultArr);
                return token;
            }
            if (remainingSize == 0) {
                this._stringValue = "";
                return NonBlockingDataParser.Token.STRING;
            }
            throw new DataDecodingException("Read negative size: " + remainingSize + ". Invalid string");
        }

        /*
         * Exception decompiling
         */
        private NonBlockingDataParser.Token readString() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private NonBlockingDataParser.Token readByteArray() throws IOException {
            NonBlockingDataParser.Token sizeToken;
            if (this._bytesBuffer == null && (sizeToken = this.readInt32()) == NonBlockingDataParser.Token.NOT_AVAILABLE) {
                return NonBlockingDataParser.Token.NOT_AVAILABLE;
            }
            int remainingSize = this._intValue;
            if (remainingSize < 0) {
                throw new DataDecodingException("Read negative size: " + remainingSize + ". Invalid byte array");
            }
            if (this._bytesBuffer == null) {
                this._bytesBuffer = new byte[remainingSize];
            }
            if (remainingSize <= this._limit - this._pos) {
                System.arraycopy(this._input, this._pos, this._bytesBuffer, this._bytesBuffer.length - remainingSize, remainingSize);
                this._pos += remainingSize;
                this._bytesValue = this._bytesBuffer;
                this._bytesBuffer = null;
                return NonBlockingDataParser.Token.RAW_BYTES;
            }
            System.arraycopy(this._input, this._pos, this._bytesBuffer, this._bytesBuffer.length - remainingSize, this._limit - this._pos);
            this._intValue -= this._limit - this._pos;
            this._pos = this._limit;
            return NonBlockingDataParser.Token.NOT_AVAILABLE;
        }

        protected final NonBlockingDataParser.Token readInt32() throws IOException {
            NonBlockingDataParser.Token token;
            block5: {
                int x;
                int tempPos;
                block7: {
                    byte[] buffer;
                    block9: {
                        block8: {
                            block6: {
                                tempPos = this._pos;
                                if (this._pos == this._limit || this._pendingIntShifts != -1) break block5;
                                buffer = this._input;
                                if ((x = buffer[tempPos++]) >= 0) {
                                    this._pos = tempPos;
                                    this._intValue = x;
                                    return NonBlockingDataParser.Token.INTEGER;
                                }
                                if (this._limit - tempPos < 9) break block5;
                                if ((x ^= buffer[tempPos++] << 7) >= 0) break block6;
                                x ^= 0xFFFFFF80;
                                break block7;
                            }
                            if ((x ^= buffer[tempPos++] << 14) < 0) break block8;
                            x ^= 0x3F80;
                            break block7;
                        }
                        if ((x ^= buffer[tempPos++] << 21) >= 0) break block9;
                        x ^= 0xFFE03F80;
                        break block7;
                    }
                    byte y = buffer[tempPos++];
                    x ^= y << 28;
                    x ^= 0xFE03F80;
                    if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block5;
                }
                this._pos = tempPos;
                this._intValue = x;
                return NonBlockingDataParser.Token.INTEGER;
            }
            if ((token = this.readRawVarint64SlowPath()) == NonBlockingDataParser.Token.LONG) {
                this._intValue = (int)this._pendingInt64;
                token = NonBlockingDataParser.Token.INTEGER;
            }
            return token;
        }

        private NonBlockingDataParser.Token readInt64() throws IOException {
            NonBlockingDataParser.Token token;
            block5: {
                long x;
                int tempPos;
                block7: {
                    byte[] buffer;
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    int y;
                                    block9: {
                                        block8: {
                                            block6: {
                                                if (this._pos == this._limit || this._pendingIntShifts != -1) break block5;
                                                tempPos = this._pos;
                                                buffer = this._input;
                                                if ((y = buffer[tempPos++]) >= 0) {
                                                    this._pos = tempPos;
                                                    this._longValue = y;
                                                    return NonBlockingDataParser.Token.LONG;
                                                }
                                                if (this._limit - tempPos < 9) break block5;
                                                if ((y ^= buffer[tempPos++] << 7) >= 0) break block6;
                                                x = y ^ 0xFFFFFF80;
                                                break block7;
                                            }
                                            if ((y ^= buffer[tempPos++] << 14) < 0) break block8;
                                            x = y ^ 0x3F80;
                                            break block7;
                                        }
                                        if ((y ^= buffer[tempPos++] << 21) >= 0) break block9;
                                        x = y ^ 0xFFE03F80;
                                        break block7;
                                    }
                                    if ((x = (long)y ^ (long)buffer[tempPos++] << 28) < 0L) break block10;
                                    x ^= 0xFE03F80L;
                                    break block7;
                                }
                                if ((x ^= (long)buffer[tempPos++] << 35) >= 0L) break block11;
                                x ^= 0xFFFFFFF80FE03F80L;
                                break block7;
                            }
                            if ((x ^= (long)buffer[tempPos++] << 42) < 0L) break block12;
                            x ^= 0x3F80FE03F80L;
                            break block7;
                        }
                        if ((x ^= (long)buffer[tempPos++] << 49) >= 0L) break block13;
                        x ^= 0xFFFE03F80FE03F80L;
                        break block7;
                    }
                    x ^= (long)buffer[tempPos++] << 56;
                    if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[tempPos++] < 0L) break block5;
                }
                this._pos = tempPos;
                this._longValue = x;
                return NonBlockingDataParser.Token.LONG;
            }
            if ((token = this.readRawVarint64SlowPath()) == NonBlockingDataParser.Token.LONG) {
                this._longValue = this._pendingInt64;
            }
            return token;
        }

        private NonBlockingDataParser.Token readRawVarint64SlowPath() throws IOException {
            if (this._pendingIntShifts == -1) {
                this._pendingInt64 = 0L;
                this._pendingIntShifts = 0;
            }
            while (this._pendingIntShifts < 64) {
                if (this._pos >= this._limit) {
                    return NonBlockingDataParser.Token.NOT_AVAILABLE;
                }
                byte b = this._input[this._pos++];
                this._pendingInt64 |= (long)(b & 0x7F) << this._pendingIntShifts;
                if ((b & 0x80) == 0) {
                    this._pendingIntShifts = -1;
                    return NonBlockingDataParser.Token.LONG;
                }
                this._pendingIntShifts += 7;
            }
            this._pendingIntShifts = -1;
            throw new DataDecodingException("Malformed VarInt");
        }

        private NonBlockingDataParser.Token readFixedInt32() {
            if (this._pendingIntShifts != -1 || this._limit - this._pos < 4) {
                if (this._pendingIntShifts == -1) {
                    this._pendingIntShifts = 0;
                    this._pendingInt32 = 0;
                }
                while (this._pos < this._limit && this._pendingIntShifts <= 24) {
                    this._pendingInt32 |= (this._input[this._pos++] & 0xFF) << this._pendingIntShifts;
                    this._pendingIntShifts += 8;
                }
                if (this._pendingIntShifts > 24) {
                    this._intValue = this._pendingInt32;
                    this._pendingIntShifts = -1;
                    return NonBlockingDataParser.Token.INTEGER;
                }
                return NonBlockingDataParser.Token.NOT_AVAILABLE;
            }
            this._intValue = this._input[this._pos++] & 0xFF | (this._input[this._pos++] & 0xFF) << 8 | (this._input[this._pos++] & 0xFF) << 16 | (this._input[this._pos++] & 0xFF) << 24;
            return NonBlockingDataParser.Token.INTEGER;
        }

        private NonBlockingDataParser.Token readFixedInt64() {
            if (this._pendingIntShifts != -1 || this._limit - this._pos < 8) {
                if (this._pendingIntShifts == -1) {
                    this._pendingIntShifts = 0;
                    this._pendingInt64 = 0L;
                }
                while (this._pos < this._limit && this._pendingIntShifts <= 56) {
                    this._pendingInt64 |= ((long)this._input[this._pos++] & 0xFFL) << this._pendingIntShifts;
                    this._pendingIntShifts += 8;
                }
                if (this._pendingIntShifts > 56) {
                    this._longValue = this._pendingInt64;
                    this._pendingIntShifts = -1;
                    return NonBlockingDataParser.Token.LONG;
                }
                return NonBlockingDataParser.Token.NOT_AVAILABLE;
            }
            this._longValue = (long)this._input[this._pos++] & 0xFFL | ((long)this._input[this._pos++] & 0xFFL) << 8 | ((long)this._input[this._pos++] & 0xFFL) << 16 | ((long)this._input[this._pos++] & 0xFFL) << 24 | ((long)this._input[this._pos++] & 0xFFL) << 32 | ((long)this._input[this._pos++] & 0xFFL) << 40 | ((long)this._input[this._pos++] & 0xFFL) << 48 | ((long)this._input[this._pos++] & 0xFFL) << 56;
            return NonBlockingDataParser.Token.LONG;
        }
    }
}

