/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.AssertionActionArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssertionActions
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**The Actions about an Assertion*/@Aspect.name=\"assertionActions\"record AssertionActions{/**Actions to be executed on successful assertion run.*/onSuccess:array[/**The Actions about an Assertion.\nIn the future, we'll likely extend this model to support additional\nparameters or options related to the assertion actions.*/record AssertionAction{/**The type of the Action*/type:enum AssertionActionType{/**Raise an incident.*/RAISE_INCIDENT/**Resolve open incidents related to the assertion.*/RESOLVE_INCIDENT}}]=[]/**Actions to be executed on failed assertion run.*/onFailure:array[AssertionAction]=[]}", SchemaFormatType.PDL);
    private AssertionActionArray _onSuccessField = null;
    private AssertionActionArray _onFailureField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_OnSuccess = SCHEMA.getField("onSuccess");
    private static final AssertionActionArray DEFAULT_OnSuccess;
    private static final RecordDataSchema.Field FIELD_OnFailure;
    private static final AssertionActionArray DEFAULT_OnFailure;

    public AssertionActions() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public AssertionActions(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasOnSuccess() {
        if (this._onSuccessField != null) {
            return true;
        }
        return this._map.containsKey("onSuccess");
    }

    public void removeOnSuccess() {
        this._map.remove("onSuccess");
    }

    @Nullable
    public AssertionActionArray getOnSuccess(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getOnSuccess();
            }
            case NULL: {
                if (this._onSuccessField != null) {
                    return this._onSuccessField;
                }
                Object __rawValue = this._map.get("onSuccess");
                this._onSuccessField = __rawValue == null ? null : new AssertionActionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._onSuccessField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionActionArray getOnSuccess() {
        if (this._onSuccessField != null) {
            return this._onSuccessField;
        }
        Object __rawValue = this._map.get("onSuccess");
        if (__rawValue == null) {
            return DEFAULT_OnSuccess;
        }
        this._onSuccessField = __rawValue == null ? null : new AssertionActionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._onSuccessField;
    }

    public AssertionActions setOnSuccess(@Nullable AssertionActionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOnSuccess(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field onSuccess of com.linkedin.assertion.AssertionActions");
                }
                CheckedUtil.putWithoutChecking(this._map, "onSuccess", value.data());
                this._onSuccessField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOnSuccess();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "onSuccess", value.data());
                this._onSuccessField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "onSuccess", value.data());
                this._onSuccessField = value;
            }
        }
        return this;
    }

    public AssertionActions setOnSuccess(@Nonnull AssertionActionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field onSuccess of com.linkedin.assertion.AssertionActions to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "onSuccess", value.data());
        this._onSuccessField = value;
        return this;
    }

    public boolean hasOnFailure() {
        if (this._onFailureField != null) {
            return true;
        }
        return this._map.containsKey("onFailure");
    }

    public void removeOnFailure() {
        this._map.remove("onFailure");
    }

    @Nullable
    public AssertionActionArray getOnFailure(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getOnFailure();
            }
            case NULL: {
                if (this._onFailureField != null) {
                    return this._onFailureField;
                }
                Object __rawValue = this._map.get("onFailure");
                this._onFailureField = __rawValue == null ? null : new AssertionActionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._onFailureField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AssertionActionArray getOnFailure() {
        if (this._onFailureField != null) {
            return this._onFailureField;
        }
        Object __rawValue = this._map.get("onFailure");
        if (__rawValue == null) {
            return DEFAULT_OnFailure;
        }
        this._onFailureField = __rawValue == null ? null : new AssertionActionArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._onFailureField;
    }

    public AssertionActions setOnFailure(@Nullable AssertionActionArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOnFailure(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field onFailure of com.linkedin.assertion.AssertionActions");
                }
                CheckedUtil.putWithoutChecking(this._map, "onFailure", value.data());
                this._onFailureField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOnFailure();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "onFailure", value.data());
                this._onFailureField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "onFailure", value.data());
                this._onFailureField = value;
            }
        }
        return this;
    }

    public AssertionActions setOnFailure(@Nonnull AssertionActionArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field onFailure of com.linkedin.assertion.AssertionActions to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "onFailure", value.data());
        this._onFailureField = value;
        return this;
    }

    @Override
    public AssertionActions clone() throws CloneNotSupportedException {
        AssertionActions __clone = (AssertionActions)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AssertionActions copy() throws CloneNotSupportedException {
        AssertionActions __copy = (AssertionActions)super.copy();
        __copy._onFailureField = null;
        __copy._onSuccessField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_OnFailure = SCHEMA.getField("onFailure");
        DEFAULT_OnSuccess = FIELD_OnSuccess.getDefault() == null ? null : new AssertionActionArray(DataTemplateUtil.castOrThrow(FIELD_OnSuccess.getDefault(), DataList.class));
        DEFAULT_OnFailure = FIELD_OnFailure.getDefault() == null ? null : new AssertionActionArray(DataTemplateUtil.castOrThrow(FIELD_OnFailure.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AssertionActions __objectRef;

        private ChangeListener(AssertionActions reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "onFailure": {
                    this.__objectRef._onFailureField = null;
                    break;
                }
                case "onSuccess": {
                    this.__objectRef._onSuccessField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AssertionActionArray.Fields onSuccess() {
            return new AssertionActionArray.Fields(this.getPathComponents(), "onSuccess");
        }

        public PathSpec onSuccess(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "onSuccess");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public AssertionActionArray.Fields onFailure() {
            return new AssertionActionArray.Fields(this.getPathComponents(), "onFailure");
        }

        public PathSpec onFailure(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "onFailure");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AssertionActionArray.ProjectionMask _onSuccessMask;
        private AssertionActionArray.ProjectionMask _onFailureMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withOnSuccess(Function<AssertionActionArray.ProjectionMask, AssertionActionArray.ProjectionMask> nestedMask) {
            this._onSuccessMask = nestedMask.apply(this._onSuccessMask == null ? AssertionActionArray.createMask() : this._onSuccessMask);
            this.getDataMap().put("onSuccess", this._onSuccessMask.getDataMap());
            return this;
        }

        public ProjectionMask withOnSuccess() {
            this._onSuccessMask = null;
            this.getDataMap().put("onSuccess", 1);
            return this;
        }

        public ProjectionMask withOnSuccess(Function<AssertionActionArray.ProjectionMask, AssertionActionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._onSuccessMask = nestedMask.apply(this._onSuccessMask == null ? AssertionActionArray.createMask() : this._onSuccessMask);
            this.getDataMap().put("onSuccess", this._onSuccessMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("onSuccess").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("onSuccess").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOnSuccess(Integer start, Integer count) {
            this._onSuccessMask = null;
            this.getDataMap().put("onSuccess", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("onSuccess").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("onSuccess").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOnFailure(Function<AssertionActionArray.ProjectionMask, AssertionActionArray.ProjectionMask> nestedMask) {
            this._onFailureMask = nestedMask.apply(this._onFailureMask == null ? AssertionActionArray.createMask() : this._onFailureMask);
            this.getDataMap().put("onFailure", this._onFailureMask.getDataMap());
            return this;
        }

        public ProjectionMask withOnFailure() {
            this._onFailureMask = null;
            this.getDataMap().put("onFailure", 1);
            return this;
        }

        public ProjectionMask withOnFailure(Function<AssertionActionArray.ProjectionMask, AssertionActionArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._onFailureMask = nestedMask.apply(this._onFailureMask == null ? AssertionActionArray.createMask() : this._onFailureMask);
            this.getDataMap().put("onFailure", this._onFailureMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("onFailure").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("onFailure").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withOnFailure(Integer start, Integer count) {
            this._onFailureMask = null;
            this.getDataMap().put("onFailure", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("onFailure").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("onFailure").put("$count", count);
            }
            return this;
        }
    }
}

