/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util.validator;

import com.datahub.util.exception.InvalidSchemaException;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.UnionTemplate;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class ValidationUtils {
    public static final Set<DataSchema.Type> PRIMITIVE_TYPES = Collections.unmodifiableSet(new HashSet<DataSchema.Type>(){
        {
            this.add(DataSchema.Type.BOOLEAN);
            this.add(DataSchema.Type.INT);
            this.add(DataSchema.Type.LONG);
            this.add(DataSchema.Type.FLOAT);
            this.add(DataSchema.Type.DOUBLE);
            this.add(DataSchema.Type.STRING);
            this.add(DataSchema.Type.ENUM);
        }
    });

    private ValidationUtils() {
    }

    public static void invalidSchema(@Nonnull String format, Object ... args) {
        throw new InvalidSchemaException(String.format(format, args));
    }

    @Nonnull
    public static RecordDataSchema getRecordSchema(@Nonnull Class<? extends RecordTemplate> clazz) {
        try {
            Field field = clazz.getDeclaredField("SCHEMA");
            field.setAccessible(true);
            return (RecordDataSchema)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to find SCHEMA field in " + clazz.getCanonicalName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public static UnionDataSchema getUnionSchema(@Nonnull Class<? extends UnionTemplate> clazz) {
        try {
            Field field = clazz.getDeclaredField("SCHEMA");
            field.setAccessible(true);
            return (UnionDataSchema)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to find SCHEMA field in " + clazz.getCanonicalName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean schemaHasExactlyOneSuchField(@Nonnull RecordDataSchema schema, @Nonnull Predicate<RecordDataSchema.Field> predicate) {
        return schema.getFields().stream().filter(predicate).count() == 1L;
    }

    public static boolean isValidUrnField(@Nonnull RecordDataSchema.Field field, @Nonnull String fieldName) {
        return field.getName().equals(fieldName) && !field.getOptional() && field.getType().getType() == DataSchema.Type.TYPEREF && Urn.class.isAssignableFrom(ValidationUtils.getUrnClass(field));
    }

    public static Class<Urn> getUrnClass(@Nonnull RecordDataSchema.Field field) {
        try {
            Class<Urn> clazz = Class.forName(((DataMap)field.getType().getProperties().get("java")).getString("class"));
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isValidUrnField(@Nonnull RecordDataSchema.Field field) {
        return ValidationUtils.isValidUrnField(field, "urn");
    }

    @Nonnull
    public static List<RecordDataSchema.Field> nonOptionalFields(@Nonnull RecordDataSchema schema, @Nonnull Set<String> whitelistedFields) {
        return schema.getFields().stream().filter(field -> !whitelistedFields.contains(field.getName()) && !field.getOptional()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<RecordDataSchema.Field> optionalFields(@Nonnull RecordDataSchema schema, @Nonnull Set<String> whitelistedFields) {
        return schema.getFields().stream().filter(field -> !whitelistedFields.contains(field.getName()) && field.getOptional()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<RecordDataSchema.Field> fieldsUsingInvalidType(@Nonnull RecordDataSchema schema, @Nonnull Set<DataSchema.Type> allowedTypes) {
        return schema.getFields().stream().filter(field -> !allowedTypes.contains((Object)ValidationUtils.getFieldOrArrayItemType(field))).collect(Collectors.toList());
    }

    public static boolean isUnionWithOnlyComplexMembers(UnionDataSchema unionDataSchema) {
        return unionDataSchema.getMembers().stream().allMatch(member -> member.getType().isComplex());
    }

    @Nonnull
    private static DataSchema.Type getFieldOrArrayItemType(@Nonnull RecordDataSchema.Field field) {
        DataSchema type;
        DataSchema dataSchema = type = field.getType().getType() == DataSchema.Type.ARRAY ? ((ArrayDataSchema)field.getType()).getItems() : field.getType();
        if (type.getType() == DataSchema.Type.TYPEREF) {
            return type.getDereferencedType();
        }
        return type.getType();
    }
}

