/*
 * Decompiled with CFR 0.152.
 */
package com.datahub.util.validator;

import com.datahub.util.validator.AspectValidator;
import com.datahub.util.validator.ValidationUtils;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.RecordTemplate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class SnapshotValidator {
    private static final Set<Class<? extends RecordTemplate>> VALIDATED = ConcurrentHashMap.newKeySet();

    private SnapshotValidator() {
    }

    public static void validateSnapshotSchema(@Nonnull RecordDataSchema schema) {
        String className = schema.getBindingName();
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, ValidationUtils::isValidUrnField)) {
            ValidationUtils.invalidSchema("Snapshot '%s' must contain an non-optional 'urn' field of URN type", className);
        }
        if (!ValidationUtils.schemaHasExactlyOneSuchField(schema, SnapshotValidator::isValidAspectsField)) {
            ValidationUtils.invalidSchema("Snapshot '%s' must contain an non-optional 'aspects' field of ARRAY type", className);
        }
        SnapshotValidator.validateAspectsItemType(schema.getField("aspects"), className);
    }

    public static void validateSnapshotSchema(@Nonnull Class<? extends RecordTemplate> clazz) {
        if (VALIDATED.contains(clazz)) {
            return;
        }
        SnapshotValidator.validateSnapshotSchema(ValidationUtils.getRecordSchema(clazz));
        VALIDATED.add(clazz);
    }

    public static void validateUniqueUrn(@Nonnull Collection<Class<? extends RecordTemplate>> snapshotClasses) {
        HashSet urnClasses = new HashSet();
        snapshotClasses.forEach(snapshotClass -> {
            Class<Urn> urnClass = ValidationUtils.getUrnClass(ValidationUtils.getRecordSchema(snapshotClass).getField("urn"));
            if (urnClasses.contains(urnClass)) {
                ValidationUtils.invalidSchema("URN class %s in %s has already been claimed by another snapshot.", urnClass, snapshotClass);
            }
            urnClasses.add(urnClass);
        });
    }

    private static boolean isValidAspectsField(@Nonnull RecordDataSchema.Field field) {
        return field.getName().equals("aspects") && !field.getOptional() && field.getType().getType() == DataSchema.Type.ARRAY;
    }

    private static void validateAspectsItemType(@Nonnull RecordDataSchema.Field aspectsField, @Nonnull String className) {
        TyperefDataSchema typerefSchema;
        DataSchema unionSchema;
        DataSchema itemSchema = ((ArrayDataSchema)aspectsField.getType()).getItems();
        if (itemSchema.getType() != DataSchema.Type.TYPEREF) {
            ValidationUtils.invalidSchema("Snapshot %s' 'aspects' field must be an array of aspect typeref", className);
        }
        if ((unionSchema = (typerefSchema = (TyperefDataSchema)itemSchema).getDereferencedDataSchema()).getType() != DataSchema.Type.UNION) {
            ValidationUtils.invalidSchema("Snapshot '%s' 'aspects' field must be an array of union typeref", className);
        }
        AspectValidator.validateAspectUnionSchema((UnionDataSchema)unionSchema, typerefSchema.getBindingName());
    }
}

