/*
 * Decompiled with CFR 0.152.
 */
package datahub.shaded.jackson.databind.node;

import datahub.shaded.jackson.core.JsonGenerator;
import datahub.shaded.jackson.core.JsonToken;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.SerializerProvider;
import datahub.shaded.jackson.databind.node.JsonNodeType;
import datahub.shaded.jackson.databind.node.ValueNode;
import java.io.IOException;

public class NullNode
extends ValueNode {
    private static final long serialVersionUID = 1L;
    public static final NullNode instance = new NullNode();

    protected NullNode() {
    }

    protected Object readResolve() {
        return instance;
    }

    public static NullNode getInstance() {
        return instance;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.NULL;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_NULL;
    }

    @Override
    public String asText(String defaultValue) {
        return defaultValue;
    }

    @Override
    public String asText() {
        return "null";
    }

    public JsonNode requireNonNull() {
        return (JsonNode)this._reportRequiredViolation("requireNonNull() called on `NullNode`", new Object[0]);
    }

    @Override
    public final void serialize(JsonGenerator g2, SerializerProvider provider) throws IOException {
        provider.defaultSerializeNull(g2);
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof NullNode;
    }

    @Override
    public int hashCode() {
        return JsonNodeType.NULL.ordinal();
    }
}

