/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

public class Pair<S, T> {
    private final S _first;
    private final T _second;

    public Pair(S first, T second) {
        this._first = first;
        this._second = second;
    }

    public S getFirst() {
        return this._first;
    }

    public S getKey() {
        return this.getFirst();
    }

    public T getSecond() {
        return this._second;
    }

    public T getValue() {
        return this.getSecond();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return Pair.equals(this._first, other._first) && Pair.equals(this._second, other._second);
        }
        return false;
    }

    public int hashCode() {
        int h1 = this._first != null ? this._first.hashCode() : 0;
        int h2 = this._second != null ? this._second.hashCode() : 0;
        return 31 * h1 + h2;
    }

    public String toString() {
        return "(" + String.valueOf(this._first) + "," + String.valueOf(this._second) + ")";
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    public static <S, T> Pair<S, T> of(S first, T second) {
        return new Pair<S, T>(first, second);
    }
}

