/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.structured;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.structured.StructuredPropertyValueAssignmentArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StructuredProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.structured/**Properties about an entity governed by StructuredPropertyDefinition*/@Aspect.name=\"structuredProperties\"record StructuredProperties{/**Custom property bag.*/properties:array[record StructuredPropertyValueAssignment{/**The property that is being assigned a value.*/propertyUrn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The value assigned to the property.*/values:array[/**Represents a stored primitive property value\n*/typeref PrimitivePropertyValue=union[string,double]]/**Audit stamp containing who created this relationship edge and when*/created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional com.linkedin.common.AuditStamp}]}", SchemaFormatType.PDL);
    private StructuredPropertyValueAssignmentArray _propertiesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Properties = SCHEMA.getField("properties");

    public StructuredProperties() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public StructuredProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasProperties() {
        if (this._propertiesField != null) {
            return true;
        }
        return this._map.containsKey("properties");
    }

    public void removeProperties() {
        this._map.remove("properties");
    }

    @Nullable
    public StructuredPropertyValueAssignmentArray getProperties(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getProperties();
            }
            case DEFAULT: 
            case NULL: {
                if (this._propertiesField != null) {
                    return this._propertiesField;
                }
                Object __rawValue = this._map.get("properties");
                this._propertiesField = __rawValue == null ? null : new StructuredPropertyValueAssignmentArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._propertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StructuredPropertyValueAssignmentArray getProperties() {
        if (this._propertiesField != null) {
            return this._propertiesField;
        }
        Object __rawValue = this._map.get("properties");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("properties");
        }
        this._propertiesField = __rawValue == null ? null : new StructuredPropertyValueAssignmentArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._propertiesField;
    }

    public StructuredProperties setProperties(@Nullable StructuredPropertyValueAssignmentArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field properties of com.linkedin.structured.StructuredProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
                this._propertiesField = value;
            }
        }
        return this;
    }

    public StructuredProperties setProperties(@Nonnull StructuredPropertyValueAssignmentArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field properties of com.linkedin.structured.StructuredProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "properties", value.data());
        this._propertiesField = value;
        return this;
    }

    @Override
    public StructuredProperties clone() throws CloneNotSupportedException {
        StructuredProperties __clone = (StructuredProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public StructuredProperties copy() throws CloneNotSupportedException {
        StructuredProperties __copy = (StructuredProperties)super.copy();
        __copy._propertiesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final StructuredProperties __objectRef;

        private ChangeListener(StructuredProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "properties": {
                    this.__objectRef._propertiesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public StructuredPropertyValueAssignmentArray.Fields properties() {
            return new StructuredPropertyValueAssignmentArray.Fields(this.getPathComponents(), "properties");
        }

        public PathSpec properties(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "properties");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private StructuredPropertyValueAssignmentArray.ProjectionMask _propertiesMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withProperties(Function<StructuredPropertyValueAssignmentArray.ProjectionMask, StructuredPropertyValueAssignmentArray.ProjectionMask> nestedMask) {
            this._propertiesMask = nestedMask.apply(this._propertiesMask == null ? StructuredPropertyValueAssignmentArray.createMask() : this._propertiesMask);
            this.getDataMap().put("properties", this._propertiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withProperties() {
            this._propertiesMask = null;
            this.getDataMap().put("properties", 1);
            return this;
        }

        public ProjectionMask withProperties(Function<StructuredPropertyValueAssignmentArray.ProjectionMask, StructuredPropertyValueAssignmentArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._propertiesMask = nestedMask.apply(this._propertiesMask == null ? StructuredPropertyValueAssignmentArray.createMask() : this._propertiesMask);
            this.getDataMap().put("properties", this._propertiesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("properties").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("properties").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withProperties(Integer start, Integer count) {
            this._propertiesMask = null;
            this.getDataMap().put("properties", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("properties").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("properties").put("$count", count);
            }
            return this;
        }
    }
}

