/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ForeignKeyConstraint
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**Description of a foreign key constraint in a schema.*/record ForeignKeyConstraint{/**Name of the constraint, likely provided from the source*/name:string/**Fields the constraint maps to on the foreign dataset*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"ForeignKeyTo\"}foreignFields:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Fields the constraint maps to on the source dataset*/sourceFields:array[com.linkedin.common.Urn]/**Reference to the foreign dataset for ease of lookup*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"ForeignKeyToDataset\"}foreignDataset:com.linkedin.common.Urn}", SchemaFormatType.PDL);
    private String _nameField = null;
    private UrnArray _foreignFieldsField = null;
    private UrnArray _sourceFieldsField = null;
    private Urn _foreignDatasetField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_ForeignFields = SCHEMA.getField("foreignFields");
    private static final RecordDataSchema.Field FIELD_SourceFields = SCHEMA.getField("sourceFields");
    private static final RecordDataSchema.Field FIELD_ForeignDataset = SCHEMA.getField("foreignDataset");

    public ForeignKeyConstraint() {
        super(new DataMap(6, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public ForeignKeyConstraint(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public ForeignKeyConstraint setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.schema.ForeignKeyConstraint");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public ForeignKeyConstraint setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.schema.ForeignKeyConstraint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasForeignFields() {
        if (this._foreignFieldsField != null) {
            return true;
        }
        return this._map.containsKey("foreignFields");
    }

    public void removeForeignFields() {
        this._map.remove("foreignFields");
    }

    @Nullable
    public UrnArray getForeignFields(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getForeignFields();
            }
            case DEFAULT: 
            case NULL: {
                if (this._foreignFieldsField != null) {
                    return this._foreignFieldsField;
                }
                Object __rawValue = this._map.get("foreignFields");
                this._foreignFieldsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._foreignFieldsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getForeignFields() {
        if (this._foreignFieldsField != null) {
            return this._foreignFieldsField;
        }
        Object __rawValue = this._map.get("foreignFields");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("foreignFields");
        }
        this._foreignFieldsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._foreignFieldsField;
    }

    public ForeignKeyConstraint setForeignFields(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setForeignFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field foreignFields of com.linkedin.schema.ForeignKeyConstraint");
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignFields", value.data());
                this._foreignFieldsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeForeignFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignFields", value.data());
                this._foreignFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "foreignFields", value.data());
                this._foreignFieldsField = value;
            }
        }
        return this;
    }

    public ForeignKeyConstraint setForeignFields(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field foreignFields of com.linkedin.schema.ForeignKeyConstraint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "foreignFields", value.data());
        this._foreignFieldsField = value;
        return this;
    }

    public boolean hasSourceFields() {
        if (this._sourceFieldsField != null) {
            return true;
        }
        return this._map.containsKey("sourceFields");
    }

    public void removeSourceFields() {
        this._map.remove("sourceFields");
    }

    @Nullable
    public UrnArray getSourceFields(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getSourceFields();
            }
            case DEFAULT: 
            case NULL: {
                if (this._sourceFieldsField != null) {
                    return this._sourceFieldsField;
                }
                Object __rawValue = this._map.get("sourceFields");
                this._sourceFieldsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._sourceFieldsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getSourceFields() {
        if (this._sourceFieldsField != null) {
            return this._sourceFieldsField;
        }
        Object __rawValue = this._map.get("sourceFields");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("sourceFields");
        }
        this._sourceFieldsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._sourceFieldsField;
    }

    public ForeignKeyConstraint setSourceFields(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceFields(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field sourceFields of com.linkedin.schema.ForeignKeyConstraint");
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceFields", value.data());
                this._sourceFieldsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceFields();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceFields", value.data());
                this._sourceFieldsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceFields", value.data());
                this._sourceFieldsField = value;
            }
        }
        return this;
    }

    public ForeignKeyConstraint setSourceFields(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceFields of com.linkedin.schema.ForeignKeyConstraint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceFields", value.data());
        this._sourceFieldsField = value;
        return this;
    }

    public boolean hasForeignDataset() {
        if (this._foreignDatasetField != null) {
            return true;
        }
        return this._map.containsKey("foreignDataset");
    }

    public void removeForeignDataset() {
        this._map.remove("foreignDataset");
    }

    @Nullable
    public Urn getForeignDataset(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getForeignDataset();
            }
            case DEFAULT: 
            case NULL: {
                if (this._foreignDatasetField != null) {
                    return this._foreignDatasetField;
                }
                Object __rawValue = this._map.get("foreignDataset");
                this._foreignDatasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._foreignDatasetField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getForeignDataset() {
        if (this._foreignDatasetField != null) {
            return this._foreignDatasetField;
        }
        Object __rawValue = this._map.get("foreignDataset");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("foreignDataset");
        }
        this._foreignDatasetField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._foreignDatasetField;
    }

    public ForeignKeyConstraint setForeignDataset(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setForeignDataset(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field foreignDataset of com.linkedin.schema.ForeignKeyConstraint");
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignDataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._foreignDatasetField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeForeignDataset();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "foreignDataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._foreignDatasetField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "foreignDataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._foreignDatasetField = value;
            }
        }
        return this;
    }

    public ForeignKeyConstraint setForeignDataset(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field foreignDataset of com.linkedin.schema.ForeignKeyConstraint to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "foreignDataset", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._foreignDatasetField = value;
        return this;
    }

    @Override
    public ForeignKeyConstraint clone() throws CloneNotSupportedException {
        ForeignKeyConstraint __clone = (ForeignKeyConstraint)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ForeignKeyConstraint copy() throws CloneNotSupportedException {
        ForeignKeyConstraint __copy = (ForeignKeyConstraint)super.copy();
        __copy._sourceFieldsField = null;
        __copy._foreignFieldsField = null;
        __copy._nameField = null;
        __copy._foreignDatasetField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ForeignKeyConstraint __objectRef;

        private ChangeListener(ForeignKeyConstraint reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "sourceFields": {
                    this.__objectRef._sourceFieldsField = null;
                    break;
                }
                case "foreignFields": {
                    this.__objectRef._foreignFieldsField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "foreignDataset": {
                    this.__objectRef._foreignDatasetField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec foreignFields() {
            return new PathSpec(this.getPathComponents(), "foreignFields");
        }

        public PathSpec foreignFields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "foreignFields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec sourceFields() {
            return new PathSpec(this.getPathComponents(), "sourceFields");
        }

        public PathSpec sourceFields(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "sourceFields");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec foreignDataset() {
            return new PathSpec(this.getPathComponents(), "foreignDataset");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(6);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withForeignFields() {
            this.getDataMap().put("foreignFields", 1);
            return this;
        }

        public ProjectionMask withForeignFields(Integer start, Integer count) {
            this.getDataMap().put("foreignFields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("foreignFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("foreignFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSourceFields() {
            this.getDataMap().put("sourceFields", 1);
            return this;
        }

        public ProjectionMask withSourceFields(Integer start, Integer count) {
            this.getDataMap().put("sourceFields", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("sourceFields").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("sourceFields").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withForeignDataset() {
            this.getDataMap().put("foreignDataset", 1);
            return this;
        }
    }
}

