/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.mxe;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.mxe.GenericPayload;
import com.linkedin.mxe.PlatformEventHeader;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlatformEvent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.mxe/**A DataHub Platform Event.*/record PlatformEvent{/**Header information stored with the event.*/header:/**A header included with each DataHub platform event.*/record PlatformEventHeader{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long}/**The name of the event, e.g. the type of event. For example, 'notificationRequestEvent', 'entityChangeEvent'*/name:string/**The event payload.*/payload:/**Generic payload record structure for serializing a Platform Event.\n*/record GenericPayload{/**The value of the event, serialized as bytes.*/value:bytes/**The content type, which represents the fashion in which the event was serialized.\nThe only type currently supported is application/json.*/contentType:string}}", SchemaFormatType.PDL);
    private PlatformEventHeader _headerField = null;
    private String _nameField = null;
    private GenericPayload _payloadField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Header = SCHEMA.getField("header");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Payload = SCHEMA.getField("payload");

    public PlatformEvent() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public PlatformEvent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasHeader() {
        if (this._headerField != null) {
            return true;
        }
        return this._map.containsKey("header");
    }

    public void removeHeader() {
        this._map.remove("header");
    }

    @Nullable
    public PlatformEventHeader getHeader(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getHeader();
            }
            case DEFAULT: 
            case NULL: {
                if (this._headerField != null) {
                    return this._headerField;
                }
                Object __rawValue = this._map.get("header");
                this._headerField = __rawValue == null ? null : new PlatformEventHeader(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._headerField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PlatformEventHeader getHeader() {
        if (this._headerField != null) {
            return this._headerField;
        }
        Object __rawValue = this._map.get("header");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("header");
        }
        this._headerField = __rawValue == null ? null : new PlatformEventHeader(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._headerField;
    }

    public PlatformEvent setHeader(@Nullable PlatformEventHeader value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHeader(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field header of com.linkedin.mxe.PlatformEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "header", value.data());
                this._headerField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHeader();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "header", value.data());
                this._headerField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "header", value.data());
                this._headerField = value;
            }
        }
        return this;
    }

    public PlatformEvent setHeader(@Nonnull PlatformEventHeader value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field header of com.linkedin.mxe.PlatformEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "header", value.data());
        this._headerField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public PlatformEvent setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.mxe.PlatformEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public PlatformEvent setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.mxe.PlatformEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasPayload() {
        if (this._payloadField != null) {
            return true;
        }
        return this._map.containsKey("payload");
    }

    public void removePayload() {
        this._map.remove("payload");
    }

    @Nullable
    public GenericPayload getPayload(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPayload();
            }
            case DEFAULT: 
            case NULL: {
                if (this._payloadField != null) {
                    return this._payloadField;
                }
                Object __rawValue = this._map.get("payload");
                this._payloadField = __rawValue == null ? null : new GenericPayload(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._payloadField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public GenericPayload getPayload() {
        if (this._payloadField != null) {
            return this._payloadField;
        }
        Object __rawValue = this._map.get("payload");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("payload");
        }
        this._payloadField = __rawValue == null ? null : new GenericPayload(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._payloadField;
    }

    public PlatformEvent setPayload(@Nullable GenericPayload value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPayload(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field payload of com.linkedin.mxe.PlatformEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "payload", value.data());
                this._payloadField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePayload();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "payload", value.data());
                this._payloadField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "payload", value.data());
                this._payloadField = value;
            }
        }
        return this;
    }

    public PlatformEvent setPayload(@Nonnull GenericPayload value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field payload of com.linkedin.mxe.PlatformEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "payload", value.data());
        this._payloadField = value;
        return this;
    }

    @Override
    public PlatformEvent clone() throws CloneNotSupportedException {
        PlatformEvent __clone = (PlatformEvent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PlatformEvent copy() throws CloneNotSupportedException {
        PlatformEvent __copy = (PlatformEvent)super.copy();
        __copy._payloadField = null;
        __copy._nameField = null;
        __copy._headerField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PlatformEvent __objectRef;

        private ChangeListener(PlatformEvent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "payload": {
                    this.__objectRef._payloadField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "header": {
                    this.__objectRef._headerField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PlatformEventHeader.Fields header() {
            return new PlatformEventHeader.Fields(this.getPathComponents(), "header");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public GenericPayload.Fields payload() {
            return new GenericPayload.Fields(this.getPathComponents(), "payload");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private PlatformEventHeader.ProjectionMask _headerMask;
        private GenericPayload.ProjectionMask _payloadMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withHeader(Function<PlatformEventHeader.ProjectionMask, PlatformEventHeader.ProjectionMask> nestedMask) {
            this._headerMask = nestedMask.apply(this._headerMask == null ? PlatformEventHeader.createMask() : this._headerMask);
            this.getDataMap().put("header", this._headerMask.getDataMap());
            return this;
        }

        public ProjectionMask withHeader() {
            this._headerMask = null;
            this.getDataMap().put("header", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withPayload(Function<GenericPayload.ProjectionMask, GenericPayload.ProjectionMask> nestedMask) {
            this._payloadMask = nestedMask.apply(this._payloadMask == null ? GenericPayload.createMask() : this._payloadMask);
            this.getDataMap().put("payload", this._payloadMask.getDataMap());
            return this;
        }

        public ProjectionMask withPayload() {
            this._payloadMask = null;
            this.getDataMap().put("payload", 1);
            return this;
        }
    }
}

