/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.mxe;

import com.linkedin.avro2pegasus.events.KafkaAuditHeader;
import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.mxe.GenericAspect;
import com.linkedin.mxe.SystemMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetadataChangeLog
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.mxe/**Kafka event for capturing update made to an entity's metadata.*/record MetadataChangeLog includes/**Kafka event for proposing a metadata change for an entity. A corresponding MetadataChangeLog is emitted when the change is accepted and committed, otherwise a FailedMetadataChangeProposal will be emitted instead.*/record MetadataChangeProposal{/**Kafka audit header. Currently remains unused in the open source.*/auditHeader:optional{namespace com.linkedin.avro2pegasus.events/**This header records information about the context of an event as it is emitted into kafka and is intended to be used by the kafka audit application.  For more information see go/kafkaauditheader*/record KafkaAuditHeader{/**The time at which the event was emitted into kafka.*/@compliance=[{\"policy\":\"EVENT_TIME\"}]time:long/**The fully qualified name of the host from which the event is being emitted.*/@compliance=\"NONE\"server:string/**The instance on the server from which the event is being emitted. e.g. i001*/@compliance=\"NONE\"instance:optional string/**The name of the application from which the event is being emitted. see go/appname*/@compliance=\"NONE\"appName:string/**A unique identifier for the message*/@compliance=\"NONE\"messageId:fixed UUID 16/**The version that is being used for auditing. In version 0, the audit trail buckets events into 10 minute audit windows based on the EventHeader timestamp. In version 1, the audit trail buckets events as follows: if the schema has an outer KafkaAuditHeader, use the outer audit header timestamp for bucketing; else if the EventHeader has an inner KafkaAuditHeader use that inner audit header's timestamp for bucketing*/@compliance=\"NONE\"auditVersion:optional int/**The fabricUrn of the host from which the event is being emitted. Fabric Urn in the format of urn:li:fabric:{fabric_name}. See go/fabric.*/@compliance=\"NONE\"fabricUrn:optional string/**This is a String that the client uses to establish some kind of connection with the Kafka cluster. The exact format of it depends on specific versions of clients and brokers. This information could potentially identify the fabric and cluster with which the client is producing to or consuming from.*/@compliance=\"NONE\"clusterConnectionString:optional string}}/**Type of the entity being written to*/entityType:string/**Urn of the entity being written\n*/entityUrn:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Key aspect of the entity being written*/entityKeyAspect:optional/**Generic record structure for serializing an Aspect\n*/record GenericAspect{/**The value of the aspect, serialized as bytes.*/value:bytes/**The content type, which represents the fashion in which the aspect was serialized.\nThe only type currently supported is application/json.*/contentType:string}/**Type of change being proposed*/changeType:{namespace com.linkedin.events.metadata/**Descriptor for a change action*/enum ChangeType{/**insert if not exists. otherwise update*/UPSERT/**insert if not exists. otherwise fail*/CREATE/**NOT SUPPORTED YET\nupdate if exists. otherwise fail*/UPDATE/**delete action*/DELETE/**patch the changes instead of full replace*/PATCH/**Restate an aspect, eg. in a index refresh.*/RESTATE/**insert if entity not exists. otherwise fail*/CREATE_ENTITY}}/**Aspect of the entity being written to\nNot filling this out implies that the writer wants to affect the entire entity\nNote: This is only valid for CREATE, UPSERT, and DELETE operations.\n*/aspectName:optional string/**The value of the new aspect.*/aspect:optional GenericAspect/**System properties that one might want to attach to an event\n*/systemMetadata:optional/**Metadata associated with each metadata change that is processed by the system*/@Aspect.name=\"systemMetadata\"record SystemMetadata{/**The timestamp the metadata was observed at*/lastObserved:optional long=0/**The original run id that produced the metadata. Populated in case of batch-ingestion.*/runId:optional string=\"no-run-id-provided\"/**The last run id that produced the metadata. Populated in case of batch-ingestion.*/lastRunId:optional string=\"no-run-id-provided\"/**The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion.*/pipelineName:optional string/**The model registry name that was used to process this event*/registryName:optional string/**The model registry version that was used to process this event*/registryVersion:optional string/**Additional properties*/properties:optional map[string,string]/**Aspect version\n   Initial implementation will use the aspect version's number, however stored as\n   a string in the case where a different aspect versioning scheme is later adopted.*/version:optional string}/**Headers - intended to mimic http headers*/headers:optional map[string,string]}{/**The previous value of the aspect that has changed.*/previousAspectValue:optional GenericAspect/**The previous value of the system metadata field that has changed.*/previousSystemMetadata:optional SystemMetadata/**An audit stamp detailing who and when the aspect was changed by. Required for all intents and purposes.*/created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private KafkaAuditHeader _auditHeaderField = null;
    private String _entityTypeField = null;
    private Urn _entityUrnField = null;
    private GenericAspect _entityKeyAspectField = null;
    private ChangeType _changeTypeField = null;
    private String _aspectNameField = null;
    private GenericAspect _aspectField = null;
    private SystemMetadata _systemMetadataField = null;
    private StringMap _headersField = null;
    private GenericAspect _previousAspectValueField = null;
    private SystemMetadata _previousSystemMetadataField = null;
    private AuditStamp _createdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_AuditHeader = SCHEMA.getField("auditHeader");
    private static final RecordDataSchema.Field FIELD_EntityType = SCHEMA.getField("entityType");
    private static final RecordDataSchema.Field FIELD_EntityUrn = SCHEMA.getField("entityUrn");
    private static final RecordDataSchema.Field FIELD_EntityKeyAspect = SCHEMA.getField("entityKeyAspect");
    private static final RecordDataSchema.Field FIELD_ChangeType = SCHEMA.getField("changeType");
    private static final RecordDataSchema.Field FIELD_AspectName = SCHEMA.getField("aspectName");
    private static final RecordDataSchema.Field FIELD_Aspect = SCHEMA.getField("aspect");
    private static final RecordDataSchema.Field FIELD_SystemMetadata = SCHEMA.getField("systemMetadata");
    private static final RecordDataSchema.Field FIELD_Headers = SCHEMA.getField("headers");
    private static final RecordDataSchema.Field FIELD_PreviousAspectValue = SCHEMA.getField("previousAspectValue");
    private static final RecordDataSchema.Field FIELD_PreviousSystemMetadata = SCHEMA.getField("previousSystemMetadata");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");

    public MetadataChangeLog() {
        super(new DataMap(), SCHEMA, 11);
        this.addChangeListener(this.__changeListener);
    }

    public MetadataChangeLog(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAuditHeader() {
        if (this._auditHeaderField != null) {
            return true;
        }
        return this._map.containsKey("auditHeader");
    }

    public void removeAuditHeader() {
        this._map.remove("auditHeader");
    }

    @Nullable
    public KafkaAuditHeader getAuditHeader(GetMode mode) {
        return this.getAuditHeader();
    }

    @Nullable
    public KafkaAuditHeader getAuditHeader() {
        if (this._auditHeaderField != null) {
            return this._auditHeaderField;
        }
        Object __rawValue = this._map.get("auditHeader");
        this._auditHeaderField = __rawValue == null ? null : new KafkaAuditHeader(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditHeaderField;
    }

    public MetadataChangeLog setAuditHeader(@Nullable KafkaAuditHeader value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditHeader(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditHeader();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
                this._auditHeaderField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
                this._auditHeaderField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setAuditHeader(@Nonnull KafkaAuditHeader value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditHeader of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditHeader", value.data());
        this._auditHeaderField = value;
        return this;
    }

    public boolean hasEntityType() {
        if (this._entityTypeField != null) {
            return true;
        }
        return this._map.containsKey("entityType");
    }

    public void removeEntityType() {
        this._map.remove("entityType");
    }

    @Nullable
    public String getEntityType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntityType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityTypeField != null) {
                    return this._entityTypeField;
                }
                Object __rawValue = this._map.get("entityType");
                this._entityTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._entityTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getEntityType() {
        if (this._entityTypeField != null) {
            return this._entityTypeField;
        }
        Object __rawValue = this._map.get("entityType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entityType");
        }
        this._entityTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._entityTypeField;
    }

    public MetadataChangeLog setEntityType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entityType of com.linkedin.mxe.MetadataChangeLog");
                }
                CheckedUtil.putWithoutChecking(this._map, "entityType", value);
                this._entityTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityType", value);
                this._entityTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityType", value);
                this._entityTypeField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setEntityType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityType of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityType", value);
        this._entityTypeField = value;
        return this;
    }

    public boolean hasEntityUrn() {
        if (this._entityUrnField != null) {
            return true;
        }
        return this._map.containsKey("entityUrn");
    }

    public void removeEntityUrn() {
        this._map.remove("entityUrn");
    }

    @Nullable
    public Urn getEntityUrn(GetMode mode) {
        return this.getEntityUrn();
    }

    @Nullable
    public Urn getEntityUrn() {
        if (this._entityUrnField != null) {
            return this._entityUrnField;
        }
        Object __rawValue = this._map.get("entityUrn");
        this._entityUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityUrnField;
    }

    public MetadataChangeLog setEntityUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityUrnField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setEntityUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityUrn of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityUrnField = value;
        return this;
    }

    public boolean hasEntityKeyAspect() {
        if (this._entityKeyAspectField != null) {
            return true;
        }
        return this._map.containsKey("entityKeyAspect");
    }

    public void removeEntityKeyAspect() {
        this._map.remove("entityKeyAspect");
    }

    @Nullable
    public GenericAspect getEntityKeyAspect(GetMode mode) {
        return this.getEntityKeyAspect();
    }

    @Nullable
    public GenericAspect getEntityKeyAspect() {
        if (this._entityKeyAspectField != null) {
            return this._entityKeyAspectField;
        }
        Object __rawValue = this._map.get("entityKeyAspect");
        this._entityKeyAspectField = __rawValue == null ? null : new GenericAspect(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._entityKeyAspectField;
    }

    public MetadataChangeLog setEntityKeyAspect(@Nullable GenericAspect value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityKeyAspect(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityKeyAspect();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityKeyAspect", value.data());
                this._entityKeyAspectField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityKeyAspect", value.data());
                this._entityKeyAspectField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setEntityKeyAspect(@Nonnull GenericAspect value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityKeyAspect of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityKeyAspect", value.data());
        this._entityKeyAspectField = value;
        return this;
    }

    public boolean hasChangeType() {
        if (this._changeTypeField != null) {
            return true;
        }
        return this._map.containsKey("changeType");
    }

    public void removeChangeType() {
        this._map.remove("changeType");
    }

    @Nullable
    public ChangeType getChangeType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getChangeType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._changeTypeField != null) {
                    return this._changeTypeField;
                }
                Object __rawValue = this._map.get("changeType");
                this._changeTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, ChangeType.class, ChangeType.$UNKNOWN);
                return this._changeTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ChangeType getChangeType() {
        if (this._changeTypeField != null) {
            return this._changeTypeField;
        }
        Object __rawValue = this._map.get("changeType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("changeType");
        }
        this._changeTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, ChangeType.class, ChangeType.$UNKNOWN);
        return this._changeTypeField;
    }

    public MetadataChangeLog setChangeType(@Nullable ChangeType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChangeType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field changeType of com.linkedin.mxe.MetadataChangeLog");
                }
                CheckedUtil.putWithoutChecking(this._map, "changeType", value.name());
                this._changeTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChangeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "changeType", value.name());
                this._changeTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "changeType", value.name());
                this._changeTypeField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setChangeType(@Nonnull ChangeType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field changeType of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "changeType", value.name());
        this._changeTypeField = value;
        return this;
    }

    public boolean hasAspectName() {
        if (this._aspectNameField != null) {
            return true;
        }
        return this._map.containsKey("aspectName");
    }

    public void removeAspectName() {
        this._map.remove("aspectName");
    }

    @Nullable
    public String getAspectName(GetMode mode) {
        return this.getAspectName();
    }

    @Nullable
    public String getAspectName() {
        if (this._aspectNameField != null) {
            return this._aspectNameField;
        }
        Object __rawValue = this._map.get("aspectName");
        this._aspectNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._aspectNameField;
    }

    public MetadataChangeLog setAspectName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspectName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspectName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspectName", value);
                this._aspectNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspectName", value);
                this._aspectNameField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setAspectName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspectName of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspectName", value);
        this._aspectNameField = value;
        return this;
    }

    public boolean hasAspect() {
        if (this._aspectField != null) {
            return true;
        }
        return this._map.containsKey("aspect");
    }

    public void removeAspect() {
        this._map.remove("aspect");
    }

    @Nullable
    public GenericAspect getAspect(GetMode mode) {
        return this.getAspect();
    }

    @Nullable
    public GenericAspect getAspect() {
        if (this._aspectField != null) {
            return this._aspectField;
        }
        Object __rawValue = this._map.get("aspect");
        this._aspectField = __rawValue == null ? null : new GenericAspect(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aspectField;
    }

    public MetadataChangeLog setAspect(@Nullable GenericAspect value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspect(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspect();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspect", value.data());
                this._aspectField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspect", value.data());
                this._aspectField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setAspect(@Nonnull GenericAspect value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspect of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspect", value.data());
        this._aspectField = value;
        return this;
    }

    public boolean hasSystemMetadata() {
        if (this._systemMetadataField != null) {
            return true;
        }
        return this._map.containsKey("systemMetadata");
    }

    public void removeSystemMetadata() {
        this._map.remove("systemMetadata");
    }

    @Nullable
    public SystemMetadata getSystemMetadata(GetMode mode) {
        return this.getSystemMetadata();
    }

    @Nullable
    public SystemMetadata getSystemMetadata() {
        if (this._systemMetadataField != null) {
            return this._systemMetadataField;
        }
        Object __rawValue = this._map.get("systemMetadata");
        this._systemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._systemMetadataField;
    }

    public MetadataChangeLog setSystemMetadata(@Nullable SystemMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSystemMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSystemMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setSystemMetadata(@Nonnull SystemMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field systemMetadata of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
        this._systemMetadataField = value;
        return this;
    }

    public boolean hasHeaders() {
        if (this._headersField != null) {
            return true;
        }
        return this._map.containsKey("headers");
    }

    public void removeHeaders() {
        this._map.remove("headers");
    }

    @Nullable
    public StringMap getHeaders(GetMode mode) {
        return this.getHeaders();
    }

    @Nullable
    public StringMap getHeaders() {
        if (this._headersField != null) {
            return this._headersField;
        }
        Object __rawValue = this._map.get("headers");
        this._headersField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._headersField;
    }

    public MetadataChangeLog setHeaders(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHeaders(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHeaders();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "headers", value.data());
                this._headersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "headers", value.data());
                this._headersField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setHeaders(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field headers of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "headers", value.data());
        this._headersField = value;
        return this;
    }

    public boolean hasPreviousAspectValue() {
        if (this._previousAspectValueField != null) {
            return true;
        }
        return this._map.containsKey("previousAspectValue");
    }

    public void removePreviousAspectValue() {
        this._map.remove("previousAspectValue");
    }

    @Nullable
    public GenericAspect getPreviousAspectValue(GetMode mode) {
        return this.getPreviousAspectValue();
    }

    @Nullable
    public GenericAspect getPreviousAspectValue() {
        if (this._previousAspectValueField != null) {
            return this._previousAspectValueField;
        }
        Object __rawValue = this._map.get("previousAspectValue");
        this._previousAspectValueField = __rawValue == null ? null : new GenericAspect(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._previousAspectValueField;
    }

    public MetadataChangeLog setPreviousAspectValue(@Nullable GenericAspect value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPreviousAspectValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePreviousAspectValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "previousAspectValue", value.data());
                this._previousAspectValueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "previousAspectValue", value.data());
                this._previousAspectValueField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setPreviousAspectValue(@Nonnull GenericAspect value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field previousAspectValue of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "previousAspectValue", value.data());
        this._previousAspectValueField = value;
        return this;
    }

    public boolean hasPreviousSystemMetadata() {
        if (this._previousSystemMetadataField != null) {
            return true;
        }
        return this._map.containsKey("previousSystemMetadata");
    }

    public void removePreviousSystemMetadata() {
        this._map.remove("previousSystemMetadata");
    }

    @Nullable
    public SystemMetadata getPreviousSystemMetadata(GetMode mode) {
        return this.getPreviousSystemMetadata();
    }

    @Nullable
    public SystemMetadata getPreviousSystemMetadata() {
        if (this._previousSystemMetadataField != null) {
            return this._previousSystemMetadataField;
        }
        Object __rawValue = this._map.get("previousSystemMetadata");
        this._previousSystemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._previousSystemMetadataField;
    }

    public MetadataChangeLog setPreviousSystemMetadata(@Nullable SystemMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPreviousSystemMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePreviousSystemMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "previousSystemMetadata", value.data());
                this._previousSystemMetadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "previousSystemMetadata", value.data());
                this._previousSystemMetadataField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setPreviousSystemMetadata(@Nonnull SystemMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field previousSystemMetadata of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "previousSystemMetadata", value.data());
        this._previousSystemMetadataField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public MetadataChangeLog setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public MetadataChangeLog setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.mxe.MetadataChangeLog to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    @Override
    public MetadataChangeLog clone() throws CloneNotSupportedException {
        MetadataChangeLog __clone = (MetadataChangeLog)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MetadataChangeLog copy() throws CloneNotSupportedException {
        MetadataChangeLog __copy = (MetadataChangeLog)super.copy();
        __copy._aspectNameField = null;
        __copy._headersField = null;
        __copy._auditHeaderField = null;
        __copy._entityUrnField = null;
        __copy._entityTypeField = null;
        __copy._previousSystemMetadataField = null;
        __copy._createdField = null;
        __copy._changeTypeField = null;
        __copy._aspectField = null;
        __copy._previousAspectValueField = null;
        __copy._systemMetadataField = null;
        __copy._entityKeyAspectField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MetadataChangeLog __objectRef;

        private ChangeListener(MetadataChangeLog reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "aspectName": {
                    this.__objectRef._aspectNameField = null;
                    break;
                }
                case "headers": {
                    this.__objectRef._headersField = null;
                    break;
                }
                case "auditHeader": {
                    this.__objectRef._auditHeaderField = null;
                    break;
                }
                case "entityUrn": {
                    this.__objectRef._entityUrnField = null;
                    break;
                }
                case "entityType": {
                    this.__objectRef._entityTypeField = null;
                    break;
                }
                case "previousSystemMetadata": {
                    this.__objectRef._previousSystemMetadataField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "changeType": {
                    this.__objectRef._changeTypeField = null;
                    break;
                }
                case "aspect": {
                    this.__objectRef._aspectField = null;
                    break;
                }
                case "previousAspectValue": {
                    this.__objectRef._previousAspectValueField = null;
                    break;
                }
                case "systemMetadata": {
                    this.__objectRef._systemMetadataField = null;
                    break;
                }
                case "entityKeyAspect": {
                    this.__objectRef._entityKeyAspectField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public KafkaAuditHeader.Fields auditHeader() {
            return new KafkaAuditHeader.Fields(this.getPathComponents(), "auditHeader");
        }

        public PathSpec entityType() {
            return new PathSpec(this.getPathComponents(), "entityType");
        }

        public PathSpec entityUrn() {
            return new PathSpec(this.getPathComponents(), "entityUrn");
        }

        public GenericAspect.Fields entityKeyAspect() {
            return new GenericAspect.Fields(this.getPathComponents(), "entityKeyAspect");
        }

        public PathSpec changeType() {
            return new PathSpec(this.getPathComponents(), "changeType");
        }

        public PathSpec aspectName() {
            return new PathSpec(this.getPathComponents(), "aspectName");
        }

        public GenericAspect.Fields aspect() {
            return new GenericAspect.Fields(this.getPathComponents(), "aspect");
        }

        public SystemMetadata.Fields systemMetadata() {
            return new SystemMetadata.Fields(this.getPathComponents(), "systemMetadata");
        }

        public PathSpec headers() {
            return new PathSpec(this.getPathComponents(), "headers");
        }

        public GenericAspect.Fields previousAspectValue() {
            return new GenericAspect.Fields(this.getPathComponents(), "previousAspectValue");
        }

        public SystemMetadata.Fields previousSystemMetadata() {
            return new SystemMetadata.Fields(this.getPathComponents(), "previousSystemMetadata");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private KafkaAuditHeader.ProjectionMask _auditHeaderMask;
        private GenericAspect.ProjectionMask _entityKeyAspectMask;
        private GenericAspect.ProjectionMask _aspectMask;
        private SystemMetadata.ProjectionMask _systemMetadataMask;
        private GenericAspect.ProjectionMask _previousAspectValueMask;
        private SystemMetadata.ProjectionMask _previousSystemMetadataMask;
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
        }

        public ProjectionMask withAuditHeader(Function<KafkaAuditHeader.ProjectionMask, KafkaAuditHeader.ProjectionMask> nestedMask) {
            this._auditHeaderMask = nestedMask.apply(this._auditHeaderMask == null ? KafkaAuditHeader.createMask() : this._auditHeaderMask);
            this.getDataMap().put("auditHeader", this._auditHeaderMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditHeader() {
            this._auditHeaderMask = null;
            this.getDataMap().put("auditHeader", 1);
            return this;
        }

        public ProjectionMask withEntityType() {
            this.getDataMap().put("entityType", 1);
            return this;
        }

        public ProjectionMask withEntityUrn() {
            this.getDataMap().put("entityUrn", 1);
            return this;
        }

        public ProjectionMask withEntityKeyAspect(Function<GenericAspect.ProjectionMask, GenericAspect.ProjectionMask> nestedMask) {
            this._entityKeyAspectMask = nestedMask.apply(this._entityKeyAspectMask == null ? GenericAspect.createMask() : this._entityKeyAspectMask);
            this.getDataMap().put("entityKeyAspect", this._entityKeyAspectMask.getDataMap());
            return this;
        }

        public ProjectionMask withEntityKeyAspect() {
            this._entityKeyAspectMask = null;
            this.getDataMap().put("entityKeyAspect", 1);
            return this;
        }

        public ProjectionMask withChangeType() {
            this.getDataMap().put("changeType", 1);
            return this;
        }

        public ProjectionMask withAspectName() {
            this.getDataMap().put("aspectName", 1);
            return this;
        }

        public ProjectionMask withAspect(Function<GenericAspect.ProjectionMask, GenericAspect.ProjectionMask> nestedMask) {
            this._aspectMask = nestedMask.apply(this._aspectMask == null ? GenericAspect.createMask() : this._aspectMask);
            this.getDataMap().put("aspect", this._aspectMask.getDataMap());
            return this;
        }

        public ProjectionMask withAspect() {
            this._aspectMask = null;
            this.getDataMap().put("aspect", 1);
            return this;
        }

        public ProjectionMask withSystemMetadata(Function<SystemMetadata.ProjectionMask, SystemMetadata.ProjectionMask> nestedMask) {
            this._systemMetadataMask = nestedMask.apply(this._systemMetadataMask == null ? SystemMetadata.createMask() : this._systemMetadataMask);
            this.getDataMap().put("systemMetadata", this._systemMetadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withSystemMetadata() {
            this._systemMetadataMask = null;
            this.getDataMap().put("systemMetadata", 1);
            return this;
        }

        public ProjectionMask withHeaders() {
            this.getDataMap().put("headers", 1);
            return this;
        }

        public ProjectionMask withPreviousAspectValue(Function<GenericAspect.ProjectionMask, GenericAspect.ProjectionMask> nestedMask) {
            this._previousAspectValueMask = nestedMask.apply(this._previousAspectValueMask == null ? GenericAspect.createMask() : this._previousAspectValueMask);
            this.getDataMap().put("previousAspectValue", this._previousAspectValueMask.getDataMap());
            return this;
        }

        public ProjectionMask withPreviousAspectValue() {
            this._previousAspectValueMask = null;
            this.getDataMap().put("previousAspectValue", 1);
            return this;
        }

        public ProjectionMask withPreviousSystemMetadata(Function<SystemMetadata.ProjectionMask, SystemMetadata.ProjectionMask> nestedMask) {
            this._previousSystemMetadataMask = nestedMask.apply(this._previousSystemMetadataMask == null ? SystemMetadata.createMask() : this._previousSystemMetadataMask);
            this.getDataMap().put("previousSystemMetadata", this._previousSystemMetadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withPreviousSystemMetadata() {
            this._previousSystemMetadataMask = null;
            this.getDataMap().put("previousSystemMetadata", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }
    }
}

