/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.common.VersionTag;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.ml.metadata.DeploymentStatus;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLModelDeploymentProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Properties associated with an ML Model Deployment*/@Aspect.name=\"mlModelDeploymentProperties\"record MLModelDeploymentProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Documentation of the MLModelDeployment*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:optional string/**Date when the MLModelDeployment was developed*/createdAt:optional{namespace com.linkedin.common/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long}/**Version of the MLModelDeployment*/version:optional{namespace com.linkedin.common/**A resource-defined string representing the resource state for the purpose of concurrency control*/record VersionTag{versionTag:optional string,metadataAttribution:optional/**Information about who, why, and how this metadata was applied*/record MetadataAttribution{/**When this metadata was updated.*/time:Time/**The entity (e.g. a member URN) responsible for applying the assocated metadata. This can\neither be a user (in case of UI edits) or the datahub system for automation.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The DataHub source responsible for applying the associated metadata. This will only be filled out\nwhen a DataHub source is responsible. This includes the specific metadata test urn, the automation urn.*/source:optional Urn/**The details associated with why this metadata was applied. For example, this could include\nthe actual regex rule, sql statement, ingestion pipeline ID, etc.*/sourceDetail:map[string,string]={}}}}/**Status of the deployment*/@Searchable.fieldName=\"deploymentStatus\"status:optional/**Model endpoint statuses*/enum DeploymentStatus{/**Deployments out of service.*/OUT_OF_SERVICE/**Deployments being created.*/CREATING/**Deployments being updated.*/UPDATING/**Deployments being reverted to a previous version.*/ROLLING_BACK/**Deployments that are active.*/IN_SERVICE/**Deployments being deleted.*/DELETING/**Deployments with an error state.*/FAILED/**Deployments with unknown/unmappable state.*/UNKNOWN}}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private String _descriptionField = null;
    private Long _createdAtField = null;
    private VersionTag _versionField = null;
    private DeploymentStatus _statusField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_CreatedAt;
    private static final RecordDataSchema.Field FIELD_Version;
    private static final RecordDataSchema.Field FIELD_Status;

    public MLModelDeploymentProperties() {
        super(new DataMap(8, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public MLModelDeploymentProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public MLModelDeploymentProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.ml.metadata.MLModelDeploymentProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public MLModelDeploymentProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.ml.metadata.MLModelDeploymentProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public MLModelDeploymentProperties setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public MLModelDeploymentProperties setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.ml.metadata.MLModelDeploymentProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public MLModelDeploymentProperties setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public MLModelDeploymentProperties setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.ml.metadata.MLModelDeploymentProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasCreatedAt() {
        if (this._createdAtField != null) {
            return true;
        }
        return this._map.containsKey("createdAt");
    }

    public void removeCreatedAt() {
        this._map.remove("createdAt");
    }

    @Nullable
    public Long getCreatedAt(GetMode mode) {
        return this.getCreatedAt();
    }

    @Nullable
    public Long getCreatedAt() {
        if (this._createdAtField != null) {
            return this._createdAtField;
        }
        Object __rawValue = this._map.get("createdAt");
        this._createdAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._createdAtField;
    }

    public MLModelDeploymentProperties setCreatedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreatedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreatedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
                this._createdAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
                this._createdAtField = value;
            }
        }
        return this;
    }

    public MLModelDeploymentProperties setCreatedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createdAt of com.linkedin.ml.metadata.MLModelDeploymentProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
        this._createdAtField = value;
        return this;
    }

    public MLModelDeploymentProperties setCreatedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "createdAt", DataTemplateUtil.coerceLongInput(value));
        this._createdAtField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public VersionTag getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public VersionTag getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = __rawValue == null ? null : new VersionTag(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._versionField;
    }

    public MLModelDeploymentProperties setVersion(@Nullable VersionTag value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value.data());
                this._versionField = value;
            }
        }
        return this;
    }

    public MLModelDeploymentProperties setVersion(@Nonnull VersionTag value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.ml.metadata.MLModelDeploymentProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value.data());
        this._versionField = value;
        return this;
    }

    public boolean hasStatus() {
        if (this._statusField != null) {
            return true;
        }
        return this._map.containsKey("status");
    }

    public void removeStatus() {
        this._map.remove("status");
    }

    @Nullable
    public DeploymentStatus getStatus(GetMode mode) {
        return this.getStatus();
    }

    @Nullable
    public DeploymentStatus getStatus() {
        if (this._statusField != null) {
            return this._statusField;
        }
        Object __rawValue = this._map.get("status");
        this._statusField = DataTemplateUtil.coerceEnumOutput(__rawValue, DeploymentStatus.class, DeploymentStatus.$UNKNOWN);
        return this._statusField;
    }

    public MLModelDeploymentProperties setStatus(@Nullable DeploymentStatus value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "status", value.name());
                this._statusField = value;
            }
        }
        return this;
    }

    public MLModelDeploymentProperties setStatus(@Nonnull DeploymentStatus value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field status of com.linkedin.ml.metadata.MLModelDeploymentProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "status", value.name());
        this._statusField = value;
        return this;
    }

    @Override
    public MLModelDeploymentProperties clone() throws CloneNotSupportedException {
        MLModelDeploymentProperties __clone = (MLModelDeploymentProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLModelDeploymentProperties copy() throws CloneNotSupportedException {
        MLModelDeploymentProperties __copy = (MLModelDeploymentProperties)super.copy();
        __copy._externalUrlField = null;
        __copy._createdAtField = null;
        __copy._customPropertiesField = null;
        __copy._descriptionField = null;
        __copy._versionField = null;
        __copy._statusField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_CreatedAt = SCHEMA.getField("createdAt");
        FIELD_Version = SCHEMA.getField("version");
        FIELD_Status = SCHEMA.getField("status");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLModelDeploymentProperties __objectRef;

        private ChangeListener(MLModelDeploymentProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "createdAt": {
                    this.__objectRef._createdAtField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "status": {
                    this.__objectRef._statusField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec createdAt() {
            return new PathSpec(this.getPathComponents(), "createdAt");
        }

        public VersionTag.Fields version() {
            return new VersionTag.Fields(this.getPathComponents(), "version");
        }

        public PathSpec status() {
            return new PathSpec(this.getPathComponents(), "status");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private VersionTag.ProjectionMask _versionMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withCreatedAt() {
            this.getDataMap().put("createdAt", 1);
            return this;
        }

        public ProjectionMask withVersion(Function<VersionTag.ProjectionMask, VersionTag.ProjectionMask> nestedMask) {
            this._versionMask = nestedMask.apply(this._versionMask == null ? VersionTag.createMask() : this._versionMask);
            this.getDataMap().put("version", this._versionMask.getDataMap());
            return this;
        }

        public ProjectionMask withVersion() {
            this._versionMask = null;
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withStatus() {
            this.getDataMap().put("status", 1);
            return this;
        }
    }
}

