/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.linkedin.metadata.utils.metrics.MetricUtils;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class MetricSpanExporter
implements SpanExporter {
    private static final AttributeKey<String> DROPWIZARD_ATTR_KEY = AttributeKey.stringKey((String)"dwizMetric");
    private static final AttributeKey<String> DROPWIZARD_NAME_ATTR_KEY = AttributeKey.stringKey((String)"dwizName");

    public CompletableResultCode export(Collection<SpanData> spans) {
        spans.stream().filter(this::shouldRecordMetric).forEach(this::recordSpanMetric);
        return CompletableResultCode.ofSuccess();
    }

    private boolean shouldRecordMetric(SpanData span) {
        return Boolean.parseBoolean((String)span.getAttributes().get(DROPWIZARD_ATTR_KEY)) || span.getAttributes().get(DROPWIZARD_NAME_ATTR_KEY) != null;
    }

    private void recordSpanMetric(SpanData span) {
        long durationNanos = span.getEndEpochNanos() - span.getStartEpochNanos();
        String dropWizardName = (String)span.getAttributes().get(DROPWIZARD_NAME_ATTR_KEY);
        String dropWizardMetricName = dropWizardName == null ? MetricRegistry.name((String)span.getName(), (String[])new String[0]) : MetricRegistry.name((String)dropWizardName, (String[])new String[0]);
        Timer timer = MetricUtils.get().timer(dropWizardMetricName);
        timer.update(durationNanos, TimeUnit.NANOSECONDS);
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return CompletableResultCode.ofSuccess();
    }
}

