/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils.metrics;

import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import com.linkedin.metadata.utils.metrics.MetricUtils;

public class ExceptionUtils {
    private static final String BASE_NAME = "metadata.validation.exception";
    private static final String DELIMITER = ".";

    private ExceptionUtils() {
    }

    public static ValidationExceptionCollection collectMetrics(ValidationExceptionCollection exceptions) {
        exceptions.streamAllExceptions().forEach(exception -> {
            String subTypeBaseName = String.join((CharSequence)DELIMITER, BASE_NAME, exception.getSubType().toString().toLowerCase());
            MetricUtils.counter(subTypeBaseName).inc((long)exceptions.size());
            MetricUtils.counter(String.join((CharSequence)DELIMITER, subTypeBaseName, exception.getChangeType().toString().toLowerCase())).inc();
            MetricUtils.counter(String.join((CharSequence)DELIMITER, subTypeBaseName, exception.getEntityUrn().getEntityType().toLowerCase())).inc();
            MetricUtils.counter(String.join((CharSequence)DELIMITER, subTypeBaseName, exception.getAspectName())).inc();
        });
        return exceptions;
    }
}

