/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.search.LineageSearchEntityArray;
import com.linkedin.metadata.search.SearchResultMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LineageScrollResult
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search/**The model for the result of a lineage search query*/record LineageScrollResult{/**A list of entities returned from the search results*/entities:array[/**The model for each entity returned by the lineage search query*/record LineageSearchEntity includes/**The model for each entity returned by the search query*/record SearchEntity{/**Urn of the entity being returned*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Matched field name and values*/matchedFields:array[record MatchedField{/**Matched field name*/name:string/**Matched field value*/value:string}]=[]features:optional map[string,double]score:optional double/**A list of the the restricted aspects on the entity.\nIf the key aspect is present, assume ALL aspects should be restricted including the entity's Urn.*/restrictedAspects:optional array[string]/**Extra fields from the search document based on what is requested in the search request*/extraFields:optional map[string,string]}{/**Optional list of entities between the source and destination node.\nThere can be multiple paths from the source to the destination.*/paths:array[array[com.linkedin.common.Urn]]=[]/**Optional list of entities between the source and destination node*/@deprecated,path:array[com.linkedin.common.Urn]=[]/**Degree of relationship (number of hops to get to entity)*/@deprecated,degree:int=1/**The degrees of separation (number of hops) between the source and this entity */degrees:array[int]=[]/**Marks an entity as having been explored for as a part of the graph walk*/explored:optional boolean/**Indicates this destination node has additional unexplored child relationships*/truncatedChildren:optional boolean/**Whether this relationship was ignored as a hop while performing the graph walk*/ignoredAsHop:optional boolean}]/**Metadata specific to the browse result of the queried path*/metadata:/**The model for the search result*/record SearchResultMetadata{/**A list of search result metadata such as aggregations*/aggregations:array[record AggregationMetadata{/**The name of the aggregation, e.g, platform, origin*/name:string/**Name of the filter to be displayed in the UI*/displayName:optional string/**Entity associated with this facet*/entity:optional com.linkedin.common.Urn/**List of aggregations showing the number of documents falling into each bucket. e.g, for platform aggregation, the bucket can be hive, kafka, etc*/aggregations:map[string,long]filterValues:array[record FilterValue{value:string,entity:optional com.linkedin.common.Urn,facetCount:long,filtered:optional boolean}]}]=[]/**A list of search query suggestions based on the given query*/suggestions:array[/**The model for the search result*/record SearchSuggestion{/**The suggestion text for this search query*/text:string/**The score for how close this suggestion is to the original search query.\nThe closer to 1 means it is closer to the original query and 0 is further away.*/score:float/**How many matches there are with the suggested text for the given field*/frequency:long}]=[]}/**Scroll Identifier for subsequent requests, if not present then no further results to fetch*/scrollId:optional string/**Size of each page in the result*/pageSize:int/**The total number of entities directly under searched path*/numEntities:int}", SchemaFormatType.PDL);
    private LineageSearchEntityArray _entitiesField = null;
    private SearchResultMetadata _metadataField = null;
    private String _scrollIdField = null;
    private Integer _pageSizeField = null;
    private Integer _numEntitiesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Entities = SCHEMA.getField("entities");
    private static final RecordDataSchema.Field FIELD_Metadata = SCHEMA.getField("metadata");
    private static final RecordDataSchema.Field FIELD_ScrollId = SCHEMA.getField("scrollId");
    private static final RecordDataSchema.Field FIELD_PageSize = SCHEMA.getField("pageSize");
    private static final RecordDataSchema.Field FIELD_NumEntities = SCHEMA.getField("numEntities");

    public LineageScrollResult() {
        super(new DataMap(7, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public LineageScrollResult(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntities() {
        if (this._entitiesField != null) {
            return true;
        }
        return this._map.containsKey("entities");
    }

    public void removeEntities() {
        this._map.remove("entities");
    }

    @Nullable
    public LineageSearchEntityArray getEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entitiesField != null) {
                    return this._entitiesField;
                }
                Object __rawValue = this._map.get("entities");
                this._entitiesField = __rawValue == null ? null : new LineageSearchEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._entitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public LineageSearchEntityArray getEntities() {
        if (this._entitiesField != null) {
            return this._entitiesField;
        }
        Object __rawValue = this._map.get("entities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entities");
        }
        this._entitiesField = __rawValue == null ? null : new LineageSearchEntityArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._entitiesField;
    }

    public LineageScrollResult setEntities(@Nullable LineageSearchEntityArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entities of com.linkedin.metadata.search.LineageScrollResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
            }
        }
        return this;
    }

    public LineageScrollResult setEntities(@Nonnull LineageSearchEntityArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entities of com.linkedin.metadata.search.LineageScrollResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
        this._entitiesField = value;
        return this;
    }

    public boolean hasMetadata() {
        if (this._metadataField != null) {
            return true;
        }
        return this._map.containsKey("metadata");
    }

    public void removeMetadata() {
        this._map.remove("metadata");
    }

    @Nullable
    public SearchResultMetadata getMetadata(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMetadata();
            }
            case DEFAULT: 
            case NULL: {
                if (this._metadataField != null) {
                    return this._metadataField;
                }
                Object __rawValue = this._map.get("metadata");
                this._metadataField = __rawValue == null ? null : new SearchResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._metadataField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public SearchResultMetadata getMetadata() {
        if (this._metadataField != null) {
            return this._metadataField;
        }
        Object __rawValue = this._map.get("metadata");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("metadata");
        }
        this._metadataField = __rawValue == null ? null : new SearchResultMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._metadataField;
    }

    public LineageScrollResult setMetadata(@Nullable SearchResultMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field metadata of com.linkedin.metadata.search.LineageScrollResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
                this._metadataField = value;
            }
        }
        return this;
    }

    public LineageScrollResult setMetadata(@Nonnull SearchResultMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field metadata of com.linkedin.metadata.search.LineageScrollResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "metadata", value.data());
        this._metadataField = value;
        return this;
    }

    public boolean hasScrollId() {
        if (this._scrollIdField != null) {
            return true;
        }
        return this._map.containsKey("scrollId");
    }

    public void removeScrollId() {
        this._map.remove("scrollId");
    }

    @Nullable
    public String getScrollId(GetMode mode) {
        return this.getScrollId();
    }

    @Nullable
    public String getScrollId() {
        if (this._scrollIdField != null) {
            return this._scrollIdField;
        }
        Object __rawValue = this._map.get("scrollId");
        this._scrollIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._scrollIdField;
    }

    public LineageScrollResult setScrollId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScrollId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScrollId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "scrollId", value);
                this._scrollIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "scrollId", value);
                this._scrollIdField = value;
            }
        }
        return this;
    }

    public LineageScrollResult setScrollId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field scrollId of com.linkedin.metadata.search.LineageScrollResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "scrollId", value);
        this._scrollIdField = value;
        return this;
    }

    public boolean hasPageSize() {
        if (this._pageSizeField != null) {
            return true;
        }
        return this._map.containsKey("pageSize");
    }

    public void removePageSize() {
        this._map.remove("pageSize");
    }

    @Nullable
    public Integer getPageSize(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPageSize();
            }
            case DEFAULT: 
            case NULL: {
                if (this._pageSizeField != null) {
                    return this._pageSizeField;
                }
                Object __rawValue = this._map.get("pageSize");
                this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._pageSizeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getPageSize() {
        if (this._pageSizeField != null) {
            return this._pageSizeField;
        }
        Object __rawValue = this._map.get("pageSize");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("pageSize");
        }
        this._pageSizeField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._pageSizeField;
    }

    public LineageScrollResult setPageSize(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPageSize(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field pageSize of com.linkedin.metadata.search.LineageScrollResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePageSize();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
                this._pageSizeField = value;
            }
        }
        return this;
    }

    public LineageScrollResult setPageSize(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field pageSize of com.linkedin.metadata.search.LineageScrollResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public LineageScrollResult setPageSize(int value) {
        CheckedUtil.putWithoutChecking(this._map, "pageSize", DataTemplateUtil.coerceIntInput(value));
        this._pageSizeField = value;
        return this;
    }

    public boolean hasNumEntities() {
        if (this._numEntitiesField != null) {
            return true;
        }
        return this._map.containsKey("numEntities");
    }

    public void removeNumEntities() {
        this._map.remove("numEntities");
    }

    @Nullable
    public Integer getNumEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getNumEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._numEntitiesField != null) {
                    return this._numEntitiesField;
                }
                Object __rawValue = this._map.get("numEntities");
                this._numEntitiesField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._numEntitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getNumEntities() {
        if (this._numEntitiesField != null) {
            return this._numEntitiesField;
        }
        Object __rawValue = this._map.get("numEntities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("numEntities");
        }
        this._numEntitiesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._numEntitiesField;
    }

    public LineageScrollResult setNumEntities(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field numEntities of com.linkedin.metadata.search.LineageScrollResult");
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
                this._numEntitiesField = value;
            }
        }
        return this;
    }

    public LineageScrollResult setNumEntities(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numEntities of com.linkedin.metadata.search.LineageScrollResult to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
        this._numEntitiesField = value;
        return this;
    }

    public LineageScrollResult setNumEntities(int value) {
        CheckedUtil.putWithoutChecking(this._map, "numEntities", DataTemplateUtil.coerceIntInput(value));
        this._numEntitiesField = value;
        return this;
    }

    @Override
    public LineageScrollResult clone() throws CloneNotSupportedException {
        LineageScrollResult __clone = (LineageScrollResult)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public LineageScrollResult copy() throws CloneNotSupportedException {
        LineageScrollResult __copy = (LineageScrollResult)super.copy();
        __copy._numEntitiesField = null;
        __copy._metadataField = null;
        __copy._entitiesField = null;
        __copy._pageSizeField = null;
        __copy._scrollIdField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final LineageScrollResult __objectRef;

        private ChangeListener(LineageScrollResult reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "numEntities": {
                    this.__objectRef._numEntitiesField = null;
                    break;
                }
                case "metadata": {
                    this.__objectRef._metadataField = null;
                    break;
                }
                case "entities": {
                    this.__objectRef._entitiesField = null;
                    break;
                }
                case "pageSize": {
                    this.__objectRef._pageSizeField = null;
                    break;
                }
                case "scrollId": {
                    this.__objectRef._scrollIdField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public LineageSearchEntityArray.Fields entities() {
            return new LineageSearchEntityArray.Fields(this.getPathComponents(), "entities");
        }

        public PathSpec entities(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "entities");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public SearchResultMetadata.Fields metadata() {
            return new SearchResultMetadata.Fields(this.getPathComponents(), "metadata");
        }

        public PathSpec scrollId() {
            return new PathSpec(this.getPathComponents(), "scrollId");
        }

        public PathSpec pageSize() {
            return new PathSpec(this.getPathComponents(), "pageSize");
        }

        public PathSpec numEntities() {
            return new PathSpec(this.getPathComponents(), "numEntities");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private LineageSearchEntityArray.ProjectionMask _entitiesMask;
        private SearchResultMetadata.ProjectionMask _metadataMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withEntities(Function<LineageSearchEntityArray.ProjectionMask, LineageSearchEntityArray.ProjectionMask> nestedMask) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? LineageSearchEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            return this;
        }

        public ProjectionMask withEntities() {
            this._entitiesMask = null;
            this.getDataMap().put("entities", 1);
            return this;
        }

        public ProjectionMask withEntities(Function<LineageSearchEntityArray.ProjectionMask, LineageSearchEntityArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._entitiesMask = nestedMask.apply(this._entitiesMask == null ? LineageSearchEntityArray.createMask() : this._entitiesMask);
            this.getDataMap().put("entities", this._entitiesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEntities(Integer start, Integer count) {
            this._entitiesMask = null;
            this.getDataMap().put("entities", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMetadata(Function<SearchResultMetadata.ProjectionMask, SearchResultMetadata.ProjectionMask> nestedMask) {
            this._metadataMask = nestedMask.apply(this._metadataMask == null ? SearchResultMetadata.createMask() : this._metadataMask);
            this.getDataMap().put("metadata", this._metadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withMetadata() {
            this._metadataMask = null;
            this.getDataMap().put("metadata", 1);
            return this;
        }

        public ProjectionMask withScrollId() {
            this.getDataMap().put("scrollId", 1);
            return this;
        }

        public ProjectionMask withPageSize() {
            this.getDataMap().put("pageSize", 1);
            return this;
        }

        public ProjectionMask withNumEntities() {
            this.getDataMap().put("numEntities", 1);
            return this;
        }
    }
}

