/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.search;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.LongMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.search.FilterValueArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregationMetadata
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.search,record AggregationMetadata{/**The name of the aggregation, e.g, platform, origin*/name:string/**Name of the filter to be displayed in the UI*/displayName:optional string/**Entity associated with this facet*/entity:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**List of aggregations showing the number of documents falling into each bucket. e.g, for platform aggregation, the bucket can be hive, kafka, etc*/aggregations:map[string,long]filterValues:array[record FilterValue{value:string,entity:optional com.linkedin.common.Urn,facetCount:long,filtered:optional boolean}]}", SchemaFormatType.PDL);
    private String _nameField = null;
    private String _displayNameField = null;
    private Urn _entityField = null;
    private LongMap _aggregationsField = null;
    private FilterValueArray _filterValuesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Aggregations = SCHEMA.getField("aggregations");
    private static final RecordDataSchema.Field FIELD_FilterValues = SCHEMA.getField("filterValues");

    public AggregationMetadata() {
        super(new DataMap(7, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public AggregationMetadata(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public AggregationMetadata setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.metadata.search.AggregationMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public AggregationMetadata setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.metadata.search.AggregationMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        return this.getDisplayName();
    }

    @Nullable
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public AggregationMetadata setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public AggregationMetadata setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.metadata.search.AggregationMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        return this.getEntity();
    }

    @Nullable
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public AggregationMetadata setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public AggregationMetadata setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.metadata.search.AggregationMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasAggregations() {
        if (this._aggregationsField != null) {
            return true;
        }
        return this._map.containsKey("aggregations");
    }

    public void removeAggregations() {
        this._map.remove("aggregations");
    }

    @Nullable
    public LongMap getAggregations(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAggregations();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aggregationsField != null) {
                    return this._aggregationsField;
                }
                Object __rawValue = this._map.get("aggregations");
                this._aggregationsField = __rawValue == null ? null : new LongMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._aggregationsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public LongMap getAggregations() {
        if (this._aggregationsField != null) {
            return this._aggregationsField;
        }
        Object __rawValue = this._map.get("aggregations");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aggregations");
        }
        this._aggregationsField = __rawValue == null ? null : new LongMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._aggregationsField;
    }

    public AggregationMetadata setAggregations(@Nullable LongMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAggregations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aggregations of com.linkedin.metadata.search.AggregationMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAggregations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
                this._aggregationsField = value;
            }
        }
        return this;
    }

    public AggregationMetadata setAggregations(@Nonnull LongMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aggregations of com.linkedin.metadata.search.AggregationMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aggregations", value.data());
        this._aggregationsField = value;
        return this;
    }

    public boolean hasFilterValues() {
        if (this._filterValuesField != null) {
            return true;
        }
        return this._map.containsKey("filterValues");
    }

    public void removeFilterValues() {
        this._map.remove("filterValues");
    }

    @Nullable
    public FilterValueArray getFilterValues(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getFilterValues();
            }
            case DEFAULT: 
            case NULL: {
                if (this._filterValuesField != null) {
                    return this._filterValuesField;
                }
                Object __rawValue = this._map.get("filterValues");
                this._filterValuesField = __rawValue == null ? null : new FilterValueArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._filterValuesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FilterValueArray getFilterValues() {
        if (this._filterValuesField != null) {
            return this._filterValuesField;
        }
        Object __rawValue = this._map.get("filterValues");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("filterValues");
        }
        this._filterValuesField = __rawValue == null ? null : new FilterValueArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._filterValuesField;
    }

    public AggregationMetadata setFilterValues(@Nullable FilterValueArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilterValues(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field filterValues of com.linkedin.metadata.search.AggregationMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "filterValues", value.data());
                this._filterValuesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilterValues();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filterValues", value.data());
                this._filterValuesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filterValues", value.data());
                this._filterValuesField = value;
            }
        }
        return this;
    }

    public AggregationMetadata setFilterValues(@Nonnull FilterValueArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filterValues of com.linkedin.metadata.search.AggregationMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filterValues", value.data());
        this._filterValuesField = value;
        return this;
    }

    @Override
    public AggregationMetadata clone() throws CloneNotSupportedException {
        AggregationMetadata __clone = (AggregationMetadata)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AggregationMetadata copy() throws CloneNotSupportedException {
        AggregationMetadata __copy = (AggregationMetadata)super.copy();
        __copy._filterValuesField = null;
        __copy._displayNameField = null;
        __copy._nameField = null;
        __copy._aggregationsField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AggregationMetadata __objectRef;

        private ChangeListener(AggregationMetadata reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "filterValues": {
                    this.__objectRef._filterValuesField = null;
                    break;
                }
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "aggregations": {
                    this.__objectRef._aggregationsField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public PathSpec aggregations() {
            return new PathSpec(this.getPathComponents(), "aggregations");
        }

        public FilterValueArray.Fields filterValues() {
            return new FilterValueArray.Fields(this.getPathComponents(), "filterValues");
        }

        public PathSpec filterValues(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "filterValues");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FilterValueArray.ProjectionMask _filterValuesMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withAggregations() {
            this.getDataMap().put("aggregations", 1);
            return this;
        }

        public ProjectionMask withFilterValues(Function<FilterValueArray.ProjectionMask, FilterValueArray.ProjectionMask> nestedMask) {
            this._filterValuesMask = nestedMask.apply(this._filterValuesMask == null ? FilterValueArray.createMask() : this._filterValuesMask);
            this.getDataMap().put("filterValues", this._filterValuesMask.getDataMap());
            return this;
        }

        public ProjectionMask withFilterValues() {
            this._filterValuesMask = null;
            this.getDataMap().put("filterValues", 1);
            return this;
        }

        public ProjectionMask withFilterValues(Function<FilterValueArray.ProjectionMask, FilterValueArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._filterValuesMask = nestedMask.apply(this._filterValuesMask == null ? FilterValueArray.createMask() : this._filterValuesMask);
            this.getDataMap().put("filterValues", this._filterValuesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("filterValues").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("filterValues").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFilterValues(Integer start, Integer count) {
            this._filterValuesMask = null;
            this.getDataMap().put("filterValues", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("filterValues").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("filterValues").put("$count", count);
            }
            return this;
        }
    }
}

