/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.run;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.metadata.run.UnsafeEntityInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class UnsafeEntityInfoArray
extends WrappingArrayTemplate<UnsafeEntityInfo> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.metadata.run/** This record serves as a holder of information for entities that were unsafe to fully delete as part of a rollback operation.*/record UnsafeEntityInfo{/**Name of the entity this aspect information instance refers to.*/urn:string}}]", SchemaFormatType.PDL);

    public UnsafeEntityInfoArray() {
        this(new DataList());
    }

    public UnsafeEntityInfoArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public UnsafeEntityInfoArray(Collection<UnsafeEntityInfo> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public UnsafeEntityInfoArray(DataList data) {
        super(data, SCHEMA, UnsafeEntityInfo.class);
    }

    public UnsafeEntityInfoArray(UnsafeEntityInfo first, UnsafeEntityInfo ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public UnsafeEntityInfoArray clone() throws CloneNotSupportedException {
        UnsafeEntityInfoArray __clone = (UnsafeEntityInfoArray)super.clone();
        return __clone;
    }

    @Override
    public UnsafeEntityInfoArray copy() throws CloneNotSupportedException {
        UnsafeEntityInfoArray __copy = (UnsafeEntityInfoArray)super.copy();
        return __copy;
    }

    @Override
    protected UnsafeEntityInfo coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new UnsafeEntityInfo(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private UnsafeEntityInfo.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<UnsafeEntityInfo.ProjectionMask, UnsafeEntityInfo.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? UnsafeEntityInfo.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public UnsafeEntityInfo.Fields items() {
            return new UnsafeEntityInfo.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

