/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class TimeseriesFieldCollectionAnnotation {
    public static final String ANNOTATION_NAME = "TimeseriesFieldCollection";
    private final String collectionName;
    private final String key;

    @Nonnull
    public static TimeseriesFieldCollectionAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String schemaFieldName, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> collectionName = AnnotationUtils.getField(map, "name", String.class);
        Optional<String> key = AnnotationUtils.getField(map, "key", String.class);
        if (!key.isPresent()) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: 'key' field is required", ANNOTATION_NAME, context));
        }
        return new TimeseriesFieldCollectionAnnotation(collectionName.orElse(schemaFieldName), key.get());
    }

    @Generated
    public TimeseriesFieldCollectionAnnotation(String collectionName, String key) {
        this.collectionName = collectionName;
        this.key = key;
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeseriesFieldCollectionAnnotation)) {
            return false;
        }
        TimeseriesFieldCollectionAnnotation other = (TimeseriesFieldCollectionAnnotation)o;
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeseriesFieldCollectionAnnotation(collectionName=" + this.getCollectionName() + ", key=" + this.getKey() + ")";
    }
}

