/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;

public final class TimeseriesFieldAnnotation {
    public static final String ANNOTATION_NAME = "TimeseriesField";
    private final String statName;
    private final AggregationType aggregationType;

    @Nonnull
    public static TimeseriesFieldAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String schemaFieldName, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> statName = AnnotationUtils.getField(map, "name", String.class);
        Optional<String> aggregationType = AnnotationUtils.getField(map, "aggregationType", String.class);
        return new TimeseriesFieldAnnotation(statName.orElse(schemaFieldName), aggregationType.map(AggregationType::valueOf).orElse(AggregationType.LATEST));
    }

    @Generated
    public TimeseriesFieldAnnotation(String statName, AggregationType aggregationType) {
        this.statName = statName;
        this.aggregationType = aggregationType;
    }

    @Generated
    public String getStatName() {
        return this.statName;
    }

    @Generated
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeseriesFieldAnnotation)) {
            return false;
        }
        TimeseriesFieldAnnotation other = (TimeseriesFieldAnnotation)o;
        String this$statName = this.getStatName();
        String other$statName = other.getStatName();
        if (this$statName == null ? other$statName != null : !this$statName.equals(other$statName)) {
            return false;
        }
        AggregationType this$aggregationType = this.getAggregationType();
        AggregationType other$aggregationType = other.getAggregationType();
        return !(this$aggregationType == null ? other$aggregationType != null : !((Object)((Object)this$aggregationType)).equals((Object)other$aggregationType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $statName = this.getStatName();
        result = result * 59 + ($statName == null ? 43 : $statName.hashCode());
        AggregationType $aggregationType = this.getAggregationType();
        result = result * 59 + ($aggregationType == null ? 43 : ((Object)((Object)$aggregationType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeseriesFieldAnnotation(statName=" + this.getStatName() + ", aggregationType=" + String.valueOf((Object)this.getAggregationType()) + ")";
    }

    public static enum AggregationType {
        LATEST,
        SUM;

    }
}

