/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;

public final class SearchableAnnotation {
    public static final String FIELD_NAME_ALIASES = "fieldNameAliases";
    public static final String ANNOTATION_NAME = "Searchable";
    public static final Set<FieldType> OBJECT_FIELD_TYPES = ImmutableSet.of(FieldType.OBJECT, FieldType.MAP_ARRAY);
    private static final Set<FieldType> DEFAULT_QUERY_FIELD_TYPES = ImmutableSet.of(FieldType.TEXT, FieldType.TEXT_PARTIAL, FieldType.WORD_GRAM, FieldType.URN, FieldType.URN_PARTIAL);
    private final String fieldName;
    private final FieldType fieldType;
    private final boolean queryByDefault;
    private final boolean enableAutocomplete;
    private final boolean addToFilters;
    private final boolean addHasValuesToFilters;
    private final Optional<String> filterNameOverride;
    private final Optional<String> hasValuesFilterNameOverride;
    private final double boostScore;
    private final Optional<String> hasValuesFieldName;
    private final Optional<String> numValuesFieldName;
    private final Map<Object, Double> weightsPerFieldValue;
    private final List<String> fieldNameAliases;
    private final boolean includeQueryEmptyAggregation;
    private final boolean includeSystemModifiedAt;
    private final Optional<String> systemModifiedAtFieldName;

    @Nonnull
    public static SearchableAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String schemaFieldName, @Nonnull DataSchema.Type schemaDataType, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> fieldName = AnnotationUtils.getField(map, "fieldName", String.class);
        Optional<String> fieldType = AnnotationUtils.getField(map, "fieldType", String.class);
        if (fieldType.isPresent() && !EnumUtils.isValidEnum(FieldType.class, fieldType.get())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field 'fieldType'. Invalid fieldType provided. Valid types are %s", ANNOTATION_NAME, context, Arrays.toString((Object[])FieldType.values())));
        }
        Optional<Boolean> queryByDefault = AnnotationUtils.getField(map, "queryByDefault", Boolean.class);
        Optional<Boolean> enableAutocomplete = AnnotationUtils.getField(map, "enableAutocomplete", Boolean.class);
        Optional<Boolean> addToFilters = AnnotationUtils.getField(map, "addToFilters", Boolean.class);
        Optional<Boolean> addHasValuesToFilters = AnnotationUtils.getField(map, "addHasValuesToFilters", Boolean.class);
        Optional<String> filterNameOverride = AnnotationUtils.getField(map, "filterNameOverride", String.class);
        Optional<String> hasValuesFilterNameOverride = AnnotationUtils.getField(map, "hasValuesFilterNameOverride", String.class);
        Optional<Double> boostScore = AnnotationUtils.getField(map, "boostScore", Double.class);
        Optional<String> hasValuesFieldName = AnnotationUtils.getField(map, "hasValuesFieldName", String.class);
        Optional<String> numValuesFieldName = AnnotationUtils.getField(map, "numValuesFieldName", String.class);
        Optional<Map> weightsPerFieldValueMap = AnnotationUtils.getField(map, "weightsPerFieldValue", Map.class).map(m4 -> m4);
        Optional<Boolean> includeQueryEmptyAggregation = AnnotationUtils.getField(map, "includeQueryEmptyAggregation", Boolean.class);
        List<String> fieldNameAliases = SearchableAnnotation.getFieldNameAliases(map);
        FieldType resolvedFieldType = SearchableAnnotation.getFieldType(fieldType, schemaDataType);
        Optional<Boolean> includeSystemModifiedAt = AnnotationUtils.getField(map, "includeSystemModifiedAt", Boolean.class);
        Optional<String> systemModifiedAtFieldName = AnnotationUtils.getField(map, "systemModifiedAtFieldName", String.class);
        return new SearchableAnnotation(fieldName.orElse(schemaFieldName), resolvedFieldType, SearchableAnnotation.getQueryByDefault(queryByDefault, resolvedFieldType), enableAutocomplete.orElse(false), addToFilters.orElse(false), addHasValuesToFilters.orElse(false), filterNameOverride, hasValuesFilterNameOverride, boostScore.orElse(1.0), hasValuesFieldName, numValuesFieldName, weightsPerFieldValueMap.orElse(ImmutableMap.of()), fieldNameAliases, includeQueryEmptyAggregation.orElse(false), includeSystemModifiedAt.orElse(false), systemModifiedAtFieldName);
    }

    private static FieldType getFieldType(Optional<String> maybeFieldType, DataSchema.Type schemaDataType) {
        if (!maybeFieldType.isPresent()) {
            return SearchableAnnotation.getDefaultFieldType(schemaDataType);
        }
        return FieldType.valueOf(maybeFieldType.get());
    }

    private static FieldType getDefaultFieldType(DataSchema.Type schemaDataType) {
        switch (schemaDataType) {
            case INT: {
                return FieldType.COUNT;
            }
            case MAP: {
                return FieldType.KEYWORD;
            }
            case FLOAT: 
            case DOUBLE: {
                return FieldType.DOUBLE;
            }
        }
        return FieldType.TEXT;
    }

    private static Boolean getQueryByDefault(Optional<Boolean> maybeQueryByDefault, FieldType fieldType) {
        if (!maybeQueryByDefault.isPresent()) {
            if (DEFAULT_QUERY_FIELD_TYPES.contains((Object)fieldType)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return maybeQueryByDefault.get();
    }

    public String getFilterName() {
        return this.filterNameOverride.orElse(this.fieldName);
    }

    public String getHasValuesFilterName() {
        return this.hasValuesFilterNameOverride.orElse(this.hasValuesFieldName.orElse(String.format("has%s", SearchableAnnotation.capitalizeFirstLetter(this.fieldName))));
    }

    private static String capitalizeFirstLetter(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static List<String> getFieldNameAliases(Map map) {
        ArrayList<String> aliases = new ArrayList<String>();
        Optional<List> fieldNameAliases = AnnotationUtils.getField(map, FIELD_NAME_ALIASES, List.class);
        if (fieldNameAliases.isPresent()) {
            for (Object alias : fieldNameAliases.get()) {
                aliases.add((String)alias);
            }
        }
        return aliases;
    }

    @Generated
    public SearchableAnnotation(String fieldName, FieldType fieldType, boolean queryByDefault, boolean enableAutocomplete, boolean addToFilters, boolean addHasValuesToFilters, Optional<String> filterNameOverride, Optional<String> hasValuesFilterNameOverride, double boostScore, Optional<String> hasValuesFieldName, Optional<String> numValuesFieldName, Map<Object, Double> weightsPerFieldValue, List<String> fieldNameAliases, boolean includeQueryEmptyAggregation, boolean includeSystemModifiedAt, Optional<String> systemModifiedAtFieldName) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.queryByDefault = queryByDefault;
        this.enableAutocomplete = enableAutocomplete;
        this.addToFilters = addToFilters;
        this.addHasValuesToFilters = addHasValuesToFilters;
        this.filterNameOverride = filterNameOverride;
        this.hasValuesFilterNameOverride = hasValuesFilterNameOverride;
        this.boostScore = boostScore;
        this.hasValuesFieldName = hasValuesFieldName;
        this.numValuesFieldName = numValuesFieldName;
        this.weightsPerFieldValue = weightsPerFieldValue;
        this.fieldNameAliases = fieldNameAliases;
        this.includeQueryEmptyAggregation = includeQueryEmptyAggregation;
        this.includeSystemModifiedAt = includeSystemModifiedAt;
        this.systemModifiedAtFieldName = systemModifiedAtFieldName;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Generated
    public boolean isQueryByDefault() {
        return this.queryByDefault;
    }

    @Generated
    public boolean isEnableAutocomplete() {
        return this.enableAutocomplete;
    }

    @Generated
    public boolean isAddToFilters() {
        return this.addToFilters;
    }

    @Generated
    public boolean isAddHasValuesToFilters() {
        return this.addHasValuesToFilters;
    }

    @Generated
    public Optional<String> getFilterNameOverride() {
        return this.filterNameOverride;
    }

    @Generated
    public Optional<String> getHasValuesFilterNameOverride() {
        return this.hasValuesFilterNameOverride;
    }

    @Generated
    public double getBoostScore() {
        return this.boostScore;
    }

    @Generated
    public Optional<String> getHasValuesFieldName() {
        return this.hasValuesFieldName;
    }

    @Generated
    public Optional<String> getNumValuesFieldName() {
        return this.numValuesFieldName;
    }

    @Generated
    public Map<Object, Double> getWeightsPerFieldValue() {
        return this.weightsPerFieldValue;
    }

    @Generated
    public List<String> getFieldNameAliases() {
        return this.fieldNameAliases;
    }

    @Generated
    public boolean isIncludeQueryEmptyAggregation() {
        return this.includeQueryEmptyAggregation;
    }

    @Generated
    public boolean isIncludeSystemModifiedAt() {
        return this.includeSystemModifiedAt;
    }

    @Generated
    public Optional<String> getSystemModifiedAtFieldName() {
        return this.systemModifiedAtFieldName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchableAnnotation)) {
            return false;
        }
        SearchableAnnotation other = (SearchableAnnotation)o;
        if (this.isQueryByDefault() != other.isQueryByDefault()) {
            return false;
        }
        if (this.isEnableAutocomplete() != other.isEnableAutocomplete()) {
            return false;
        }
        if (this.isAddToFilters() != other.isAddToFilters()) {
            return false;
        }
        if (this.isAddHasValuesToFilters() != other.isAddHasValuesToFilters()) {
            return false;
        }
        if (Double.compare(this.getBoostScore(), other.getBoostScore()) != 0) {
            return false;
        }
        if (this.isIncludeQueryEmptyAggregation() != other.isIncludeQueryEmptyAggregation()) {
            return false;
        }
        if (this.isIncludeSystemModifiedAt() != other.isIncludeSystemModifiedAt()) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        FieldType this$fieldType = this.getFieldType();
        FieldType other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType)) {
            return false;
        }
        Optional<String> this$filterNameOverride = this.getFilterNameOverride();
        Optional<String> other$filterNameOverride = other.getFilterNameOverride();
        if (this$filterNameOverride == null ? other$filterNameOverride != null : !((Object)this$filterNameOverride).equals(other$filterNameOverride)) {
            return false;
        }
        Optional<String> this$hasValuesFilterNameOverride = this.getHasValuesFilterNameOverride();
        Optional<String> other$hasValuesFilterNameOverride = other.getHasValuesFilterNameOverride();
        if (this$hasValuesFilterNameOverride == null ? other$hasValuesFilterNameOverride != null : !((Object)this$hasValuesFilterNameOverride).equals(other$hasValuesFilterNameOverride)) {
            return false;
        }
        Optional<String> this$hasValuesFieldName = this.getHasValuesFieldName();
        Optional<String> other$hasValuesFieldName = other.getHasValuesFieldName();
        if (this$hasValuesFieldName == null ? other$hasValuesFieldName != null : !((Object)this$hasValuesFieldName).equals(other$hasValuesFieldName)) {
            return false;
        }
        Optional<String> this$numValuesFieldName = this.getNumValuesFieldName();
        Optional<String> other$numValuesFieldName = other.getNumValuesFieldName();
        if (this$numValuesFieldName == null ? other$numValuesFieldName != null : !((Object)this$numValuesFieldName).equals(other$numValuesFieldName)) {
            return false;
        }
        Map<Object, Double> this$weightsPerFieldValue = this.getWeightsPerFieldValue();
        Map<Object, Double> other$weightsPerFieldValue = other.getWeightsPerFieldValue();
        if (this$weightsPerFieldValue == null ? other$weightsPerFieldValue != null : !((Object)this$weightsPerFieldValue).equals(other$weightsPerFieldValue)) {
            return false;
        }
        List<String> this$fieldNameAliases = this.getFieldNameAliases();
        List<String> other$fieldNameAliases = other.getFieldNameAliases();
        if (this$fieldNameAliases == null ? other$fieldNameAliases != null : !((Object)this$fieldNameAliases).equals(other$fieldNameAliases)) {
            return false;
        }
        Optional<String> this$systemModifiedAtFieldName = this.getSystemModifiedAtFieldName();
        Optional<String> other$systemModifiedAtFieldName = other.getSystemModifiedAtFieldName();
        return !(this$systemModifiedAtFieldName == null ? other$systemModifiedAtFieldName != null : !((Object)this$systemModifiedAtFieldName).equals(other$systemModifiedAtFieldName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isQueryByDefault() ? 79 : 97);
        result = result * 59 + (this.isEnableAutocomplete() ? 79 : 97);
        result = result * 59 + (this.isAddToFilters() ? 79 : 97);
        result = result * 59 + (this.isAddHasValuesToFilters() ? 79 : 97);
        long $boostScore = Double.doubleToLongBits(this.getBoostScore());
        result = result * 59 + (int)($boostScore >>> 32 ^ $boostScore);
        result = result * 59 + (this.isIncludeQueryEmptyAggregation() ? 79 : 97);
        result = result * 59 + (this.isIncludeSystemModifiedAt() ? 79 : 97);
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        FieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
        Optional<String> $filterNameOverride = this.getFilterNameOverride();
        result = result * 59 + ($filterNameOverride == null ? 43 : ((Object)$filterNameOverride).hashCode());
        Optional<String> $hasValuesFilterNameOverride = this.getHasValuesFilterNameOverride();
        result = result * 59 + ($hasValuesFilterNameOverride == null ? 43 : ((Object)$hasValuesFilterNameOverride).hashCode());
        Optional<String> $hasValuesFieldName = this.getHasValuesFieldName();
        result = result * 59 + ($hasValuesFieldName == null ? 43 : ((Object)$hasValuesFieldName).hashCode());
        Optional<String> $numValuesFieldName = this.getNumValuesFieldName();
        result = result * 59 + ($numValuesFieldName == null ? 43 : ((Object)$numValuesFieldName).hashCode());
        Map<Object, Double> $weightsPerFieldValue = this.getWeightsPerFieldValue();
        result = result * 59 + ($weightsPerFieldValue == null ? 43 : ((Object)$weightsPerFieldValue).hashCode());
        List<String> $fieldNameAliases = this.getFieldNameAliases();
        result = result * 59 + ($fieldNameAliases == null ? 43 : ((Object)$fieldNameAliases).hashCode());
        Optional<String> $systemModifiedAtFieldName = this.getSystemModifiedAtFieldName();
        result = result * 59 + ($systemModifiedAtFieldName == null ? 43 : ((Object)$systemModifiedAtFieldName).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SearchableAnnotation(fieldName=" + this.getFieldName() + ", fieldType=" + String.valueOf((Object)this.getFieldType()) + ", queryByDefault=" + this.isQueryByDefault() + ", enableAutocomplete=" + this.isEnableAutocomplete() + ", addToFilters=" + this.isAddToFilters() + ", addHasValuesToFilters=" + this.isAddHasValuesToFilters() + ", filterNameOverride=" + String.valueOf(this.getFilterNameOverride()) + ", hasValuesFilterNameOverride=" + String.valueOf(this.getHasValuesFilterNameOverride()) + ", boostScore=" + this.getBoostScore() + ", hasValuesFieldName=" + String.valueOf(this.getHasValuesFieldName()) + ", numValuesFieldName=" + String.valueOf(this.getNumValuesFieldName()) + ", weightsPerFieldValue=" + String.valueOf(this.getWeightsPerFieldValue()) + ", fieldNameAliases=" + String.valueOf(this.getFieldNameAliases()) + ", includeQueryEmptyAggregation=" + this.isIncludeQueryEmptyAggregation() + ", includeSystemModifiedAt=" + this.isIncludeSystemModifiedAt() + ", systemModifiedAtFieldName=" + String.valueOf(this.getSystemModifiedAtFieldName()) + ")";
    }

    public static enum FieldType {
        KEYWORD,
        TEXT,
        TEXT_PARTIAL,
        BROWSE_PATH,
        URN,
        URN_PARTIAL,
        BOOLEAN,
        COUNT,
        DATETIME,
        OBJECT,
        BROWSE_PATH_V2,
        WORD_GRAM,
        DOUBLE,
        MAP_ARRAY;

    }
}

