/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.annotation.SchemaVisitor;
import com.linkedin.data.schema.annotation.SchemaVisitorTraversalResult;
import com.linkedin.data.schema.annotation.TraverserContext;
import com.linkedin.metadata.models.FieldSpecUtils;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.RelationshipFieldSpec;
import com.linkedin.metadata.models.annotation.RelationshipAnnotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RelationshipFieldSpecExtractor
implements SchemaVisitor {
    private final List<RelationshipFieldSpec> _specs = new ArrayList<RelationshipFieldSpec>();

    public List<RelationshipFieldSpec> getSpecs() {
        return this._specs;
    }

    @Override
    public void callbackOnContext(TraverserContext context, DataSchemaTraverse.Order order) {
        if (context.getEnclosingField() == null) {
            return;
        }
        if (DataSchemaTraverse.Order.PRE_ORDER.equals((Object)order)) {
            Map<String, Object> resolvedProperties;
            Object resolvedAnnotationObj;
            DataSchema currentSchema = context.getCurrentSchema().getDereferencedDataSchema();
            Map<String, Object> properties = context.getEnclosingField().getProperties();
            Object primaryAnnotationObj = properties.get("Relationship");
            if (primaryAnnotationObj != null) {
                this.validatePropertiesAnnotation(currentSchema, primaryAnnotationObj, context.getTraversePath().toString());
            }
            if ((resolvedAnnotationObj = (resolvedProperties = FieldSpecUtils.getResolvedProperties(currentSchema, Collections.emptyMap())).get("Relationship")) != null) {
                if (currentSchema.isPrimitive() && this.isValidPrimitiveType((PrimitiveDataSchema)currentSchema).booleanValue()) {
                    PathSpec path = new PathSpec(context.getSchemaPathSpec());
                    RelationshipAnnotation annotation = RelationshipAnnotation.fromPegasusAnnotationObject(resolvedAnnotationObj, path.toString());
                    RelationshipFieldSpec fieldSpec = new RelationshipFieldSpec(path, annotation, currentSchema);
                    this._specs.add(fieldSpec);
                    return;
                }
                throw new ModelValidationException(String.format("Invalid @Relationship Annotation at %s", context.getSchemaPathSpec().toString()));
            }
        }
    }

    @Override
    public SchemaVisitor.VisitorContext getInitialVisitorContext() {
        return null;
    }

    @Override
    public SchemaVisitorTraversalResult getSchemaVisitorTraversalResult() {
        return new SchemaVisitorTraversalResult();
    }

    private Boolean isValidPrimitiveType(PrimitiveDataSchema schema) {
        return DataSchema.Type.STRING.equals((Object)schema.getDereferencedDataSchema().getDereferencedType());
    }

    private void validatePropertiesAnnotation(DataSchema currentSchema, Object annotationObj, String pathStr) {
        if (currentSchema.isPrimitive()) {
            return;
        }
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared inside %s: Invalid value type provided (Expected Map)", "Relationship", pathStr));
        }
        Map annotationMap = (Map)annotationObj;
        for (String key : annotationMap.keySet()) {
            if (key.startsWith(Character.toString('/'))) continue;
            throw new ModelValidationException(String.format("Invalid @Relationship Annotation at %s. Annotation placed on invalid field of type %s. Must be placed on primitive field.", new Object[]{pathStr, currentSchema.getType()}));
        }
    }
}

