/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.key;

import com.linkedin.common.FabricType;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetKey
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.key/**Key for a Dataset*/@Aspect.name=\"datasetKey\"record DatasetKey{/**Data platform urn associated with the dataset*/@Searchable={\"enableAutocomplete\":true,\"fieldType\":\"URN\"}platform:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Unique guid for dataset*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldName\":\"id\",\"fieldType\":\"WORD_GRAM\"}name:string/**Fabric type where dataset belongs to or where it was generated.*/@Searchable={\"addToFilters\":true,\"fieldType\":\"TEXT_PARTIAL\",\"filterNameOverride\":\"Environment\",\"queryByDefault\":false}origin:{namespace com.linkedin.common/**Fabric group type*/enum FabricType{/**Designates development fabrics*/DEV/**Designates testing fabrics*/TEST/**Designates quality assurance fabrics*/QA/**Designates user acceptance testing fabrics*/UAT/**Designates early-integration fabrics*/EI/**Designates pre-production fabrics*/PRE/**Designates staging fabrics*/STG/**Designates non-production fabrics*/NON_PROD/**Designates production fabrics*/PROD/**Designates corporation fabrics*/CORP/**Designates review fabrics*/RVW/**Alternative Prod spelling*/PRD/**Alternative Test spelling*/TST/**System Integration Testing*/SIT/**Alternative spelling for sandbox*/SBX/**Designates sandbox fabrics*/SANDBOX}}}", SchemaFormatType.PDL);
    private Urn _platformField = null;
    private String _nameField = null;
    private FabricType _originField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Platform = SCHEMA.getField("platform");
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Origin = SCHEMA.getField("origin");

    public DatasetKey() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetKey(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasPlatform() {
        if (this._platformField != null) {
            return true;
        }
        return this._map.containsKey("platform");
    }

    public void removePlatform() {
        this._map.remove("platform");
    }

    @Nullable
    public Urn getPlatform(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getPlatform();
            }
            case DEFAULT: 
            case NULL: {
                if (this._platformField != null) {
                    return this._platformField;
                }
                Object __rawValue = this._map.get("platform");
                this._platformField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._platformField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getPlatform() {
        if (this._platformField != null) {
            return this._platformField;
        }
        Object __rawValue = this._map.get("platform");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("platform");
        }
        this._platformField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._platformField;
    }

    public DatasetKey setPlatform(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPlatform(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field platform of com.linkedin.metadata.key.DatasetKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._platformField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePlatform();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._platformField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._platformField = value;
            }
        }
        return this;
    }

    public DatasetKey setPlatform(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field platform of com.linkedin.metadata.key.DatasetKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "platform", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._platformField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DatasetKey setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.metadata.key.DatasetKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DatasetKey setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.metadata.key.DatasetKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasOrigin() {
        if (this._originField != null) {
            return true;
        }
        return this._map.containsKey("origin");
    }

    public void removeOrigin() {
        this._map.remove("origin");
    }

    @Nullable
    public FabricType getOrigin(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOrigin();
            }
            case DEFAULT: 
            case NULL: {
                if (this._originField != null) {
                    return this._originField;
                }
                Object __rawValue = this._map.get("origin");
                this._originField = DataTemplateUtil.coerceEnumOutput(__rawValue, FabricType.class, FabricType.$UNKNOWN);
                return this._originField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FabricType getOrigin() {
        if (this._originField != null) {
            return this._originField;
        }
        Object __rawValue = this._map.get("origin");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("origin");
        }
        this._originField = DataTemplateUtil.coerceEnumOutput(__rawValue, FabricType.class, FabricType.$UNKNOWN);
        return this._originField;
    }

    public DatasetKey setOrigin(@Nullable FabricType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOrigin(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field origin of com.linkedin.metadata.key.DatasetKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "origin", value.name());
                this._originField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOrigin();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "origin", value.name());
                this._originField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "origin", value.name());
                this._originField = value;
            }
        }
        return this;
    }

    public DatasetKey setOrigin(@Nonnull FabricType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field origin of com.linkedin.metadata.key.DatasetKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "origin", value.name());
        this._originField = value;
        return this;
    }

    @Override
    public DatasetKey clone() throws CloneNotSupportedException {
        DatasetKey __clone = (DatasetKey)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetKey copy() throws CloneNotSupportedException {
        DatasetKey __copy = (DatasetKey)super.copy();
        __copy._originField = null;
        __copy._nameField = null;
        __copy._platformField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetKey __objectRef;

        private ChangeListener(DatasetKey reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "origin": {
                    this.__objectRef._originField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "platform": {
                    this.__objectRef._platformField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec platform() {
            return new PathSpec(this.getPathComponents(), "platform");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec origin() {
            return new PathSpec(this.getPathComponents(), "origin");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withPlatform() {
            this.getDataMap().put("platform", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withOrigin() {
            this.getDataMap().put("origin", 1);
            return this;
        }
    }
}

