/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.graph;

import com.linkedin.common.UrnArray;
import com.linkedin.common.UrnArrayArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.IntegerArray;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LineageRelationship
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.graph/**Metadata about a lineage relationship between two entities*/record LineageRelationship{/**The type of the relationship*/type:string/**Entity that is related via lineage*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Optional list of entities between the source and destination node.\nThere can be multiple paths from the source to the destination.*/paths:array[array[com.linkedin.common.Urn]]=[]/**Optional list of entities between the source and destination node*/@deprecated,path:array[com.linkedin.common.Urn]=[]/**Degree of relationship (number of hops to get to entity)\nDeprecated by degrees. degree field is populated by min(degrees) for backward compatibility.*/@deprecated,degree:int=1/**Timestamp for when this lineage relationship was created. Could be null.*/createdOn:optional long/**Urn of the actor that created this lineage relationship. Could be null.*/createdActor:optional com.linkedin.common.Urn/**Timestamp for when this lineage relationship was last updated. Could be null.*/updatedOn:optional long/**Urn of the actor that last updated this lineage relationship. Could be null.*/updatedActor:optional com.linkedin.common.Urn/**Whether this lineage edge is a manual edge.*/isManual:optional boolean/**The different depths at which this entity is discovered in the lineage graph.\nMarked as optional to maintain backward compatibility, but is filled out by implementations. \nReplaces the deprecated field \"degree\".\n*/degrees:optional array[int]/**Marks this relationship as explored during the graph walk*/explored:optional boolean/**Indicates this destination node has additional unexplored child relationships*/truncatedChildren:optional boolean/**Whether this relationship was ignored as a hop while performing the graph walk*/ignoredAsHop:optional boolean}", SchemaFormatType.PDL);
    private String _typeField = null;
    private Urn _entityField = null;
    private UrnArrayArray _pathsField = null;
    private UrnArray _pathField = null;
    private Integer _degreeField = null;
    private Long _createdOnField = null;
    private Urn _createdActorField = null;
    private Long _updatedOnField = null;
    private Urn _updatedActorField = null;
    private Boolean _isManualField = null;
    private IntegerArray _degreesField = null;
    private Boolean _exploredField = null;
    private Boolean _truncatedChildrenField = null;
    private Boolean _ignoredAsHopField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Paths = SCHEMA.getField("paths");
    private static final UrnArrayArray DEFAULT_Paths;
    private static final RecordDataSchema.Field FIELD_Path;
    private static final UrnArray DEFAULT_Path;
    private static final RecordDataSchema.Field FIELD_Degree;
    private static final Integer DEFAULT_Degree;
    private static final RecordDataSchema.Field FIELD_CreatedOn;
    private static final RecordDataSchema.Field FIELD_CreatedActor;
    private static final RecordDataSchema.Field FIELD_UpdatedOn;
    private static final RecordDataSchema.Field FIELD_UpdatedActor;
    private static final RecordDataSchema.Field FIELD_IsManual;
    private static final RecordDataSchema.Field FIELD_Degrees;
    private static final RecordDataSchema.Field FIELD_Explored;
    private static final RecordDataSchema.Field FIELD_TruncatedChildren;
    private static final RecordDataSchema.Field FIELD_IgnoredAsHop;

    public LineageRelationship() {
        super(new DataMap(), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public LineageRelationship(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public LineageRelationship setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.metadata.graph.LineageRelationship");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public LineageRelationship setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public LineageRelationship setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.metadata.graph.LineageRelationship");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public LineageRelationship setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasPaths() {
        if (this._pathsField != null) {
            return true;
        }
        return this._map.containsKey("paths");
    }

    public void removePaths() {
        this._map.remove("paths");
    }

    @Nullable
    public UrnArrayArray getPaths(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPaths();
            }
            case NULL: {
                if (this._pathsField != null) {
                    return this._pathsField;
                }
                Object __rawValue = this._map.get("paths");
                this._pathsField = __rawValue == null ? null : new UrnArrayArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._pathsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArrayArray getPaths() {
        if (this._pathsField != null) {
            return this._pathsField;
        }
        Object __rawValue = this._map.get("paths");
        if (__rawValue == null) {
            return DEFAULT_Paths;
        }
        this._pathsField = __rawValue == null ? null : new UrnArrayArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._pathsField;
    }

    public LineageRelationship setPaths(@Nullable UrnArrayArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPaths(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field paths of com.linkedin.metadata.graph.LineageRelationship");
                }
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePaths();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
                this._pathsField = value;
            }
        }
        return this;
    }

    public LineageRelationship setPaths(@Nonnull UrnArrayArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field paths of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "paths", value.data());
        this._pathsField = value;
        return this;
    }

    @Deprecated
    public boolean hasPath() {
        if (this._pathField != null) {
            return true;
        }
        return this._map.containsKey("path");
    }

    @Deprecated
    public void removePath() {
        this._map.remove("path");
    }

    @Deprecated
    @Nullable
    public UrnArray getPath(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPath();
            }
            case NULL: {
                if (this._pathField != null) {
                    return this._pathField;
                }
                Object __rawValue = this._map.get("path");
                this._pathField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._pathField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public UrnArray getPath() {
        if (this._pathField != null) {
            return this._pathField;
        }
        Object __rawValue = this._map.get("path");
        if (__rawValue == null) {
            return DEFAULT_Path;
        }
        this._pathField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._pathField;
    }

    @Deprecated
    public LineageRelationship setPath(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPath(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field path of com.linkedin.metadata.graph.LineageRelationship");
                }
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePath();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "path", value.data());
                this._pathField = value;
            }
        }
        return this;
    }

    @Deprecated
    public LineageRelationship setPath(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field path of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "path", value.data());
        this._pathField = value;
        return this;
    }

    @Deprecated
    public boolean hasDegree() {
        if (this._degreeField != null) {
            return true;
        }
        return this._map.containsKey("degree");
    }

    @Deprecated
    public void removeDegree() {
        this._map.remove("degree");
    }

    @Deprecated
    @Nullable
    public Integer getDegree(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getDegree();
            }
            case NULL: {
                if (this._degreeField != null) {
                    return this._degreeField;
                }
                Object __rawValue = this._map.get("degree");
                this._degreeField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._degreeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public Integer getDegree() {
        if (this._degreeField != null) {
            return this._degreeField;
        }
        Object __rawValue = this._map.get("degree");
        if (__rawValue == null) {
            return DEFAULT_Degree;
        }
        this._degreeField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._degreeField;
    }

    @Deprecated
    public LineageRelationship setDegree(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDegree(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field degree of com.linkedin.metadata.graph.LineageRelationship");
                }
                CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
                this._degreeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDegree();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
                this._degreeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
                this._degreeField = value;
            }
        }
        return this;
    }

    @Deprecated
    public LineageRelationship setDegree(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field degree of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
        this._degreeField = value;
        return this;
    }

    @Deprecated
    public LineageRelationship setDegree(int value) {
        CheckedUtil.putWithoutChecking(this._map, "degree", DataTemplateUtil.coerceIntInput(value));
        this._degreeField = value;
        return this;
    }

    public boolean hasCreatedOn() {
        if (this._createdOnField != null) {
            return true;
        }
        return this._map.containsKey("createdOn");
    }

    public void removeCreatedOn() {
        this._map.remove("createdOn");
    }

    @Nullable
    public Long getCreatedOn(GetMode mode) {
        return this.getCreatedOn();
    }

    @Nullable
    public Long getCreatedOn() {
        if (this._createdOnField != null) {
            return this._createdOnField;
        }
        Object __rawValue = this._map.get("createdOn");
        this._createdOnField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._createdOnField;
    }

    public LineageRelationship setCreatedOn(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreatedOn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreatedOn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createdOn", DataTemplateUtil.coerceLongInput(value));
                this._createdOnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createdOn", DataTemplateUtil.coerceLongInput(value));
                this._createdOnField = value;
            }
        }
        return this;
    }

    public LineageRelationship setCreatedOn(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createdOn of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createdOn", DataTemplateUtil.coerceLongInput(value));
        this._createdOnField = value;
        return this;
    }

    public LineageRelationship setCreatedOn(long value) {
        CheckedUtil.putWithoutChecking(this._map, "createdOn", DataTemplateUtil.coerceLongInput(value));
        this._createdOnField = value;
        return this;
    }

    public boolean hasCreatedActor() {
        if (this._createdActorField != null) {
            return true;
        }
        return this._map.containsKey("createdActor");
    }

    public void removeCreatedActor() {
        this._map.remove("createdActor");
    }

    @Nullable
    public Urn getCreatedActor(GetMode mode) {
        return this.getCreatedActor();
    }

    @Nullable
    public Urn getCreatedActor() {
        if (this._createdActorField != null) {
            return this._createdActorField;
        }
        Object __rawValue = this._map.get("createdActor");
        this._createdActorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._createdActorField;
    }

    public LineageRelationship setCreatedActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreatedActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreatedActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createdActor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._createdActorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createdActor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._createdActorField = value;
            }
        }
        return this;
    }

    public LineageRelationship setCreatedActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createdActor of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createdActor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._createdActorField = value;
        return this;
    }

    public boolean hasUpdatedOn() {
        if (this._updatedOnField != null) {
            return true;
        }
        return this._map.containsKey("updatedOn");
    }

    public void removeUpdatedOn() {
        this._map.remove("updatedOn");
    }

    @Nullable
    public Long getUpdatedOn(GetMode mode) {
        return this.getUpdatedOn();
    }

    @Nullable
    public Long getUpdatedOn() {
        if (this._updatedOnField != null) {
            return this._updatedOnField;
        }
        Object __rawValue = this._map.get("updatedOn");
        this._updatedOnField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._updatedOnField;
    }

    public LineageRelationship setUpdatedOn(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUpdatedOn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUpdatedOn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "updatedOn", DataTemplateUtil.coerceLongInput(value));
                this._updatedOnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "updatedOn", DataTemplateUtil.coerceLongInput(value));
                this._updatedOnField = value;
            }
        }
        return this;
    }

    public LineageRelationship setUpdatedOn(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field updatedOn of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "updatedOn", DataTemplateUtil.coerceLongInput(value));
        this._updatedOnField = value;
        return this;
    }

    public LineageRelationship setUpdatedOn(long value) {
        CheckedUtil.putWithoutChecking(this._map, "updatedOn", DataTemplateUtil.coerceLongInput(value));
        this._updatedOnField = value;
        return this;
    }

    public boolean hasUpdatedActor() {
        if (this._updatedActorField != null) {
            return true;
        }
        return this._map.containsKey("updatedActor");
    }

    public void removeUpdatedActor() {
        this._map.remove("updatedActor");
    }

    @Nullable
    public Urn getUpdatedActor(GetMode mode) {
        return this.getUpdatedActor();
    }

    @Nullable
    public Urn getUpdatedActor() {
        if (this._updatedActorField != null) {
            return this._updatedActorField;
        }
        Object __rawValue = this._map.get("updatedActor");
        this._updatedActorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._updatedActorField;
    }

    public LineageRelationship setUpdatedActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUpdatedActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUpdatedActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "updatedActor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._updatedActorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "updatedActor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._updatedActorField = value;
            }
        }
        return this;
    }

    public LineageRelationship setUpdatedActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field updatedActor of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "updatedActor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._updatedActorField = value;
        return this;
    }

    public boolean hasIsManual() {
        if (this._isManualField != null) {
            return true;
        }
        return this._map.containsKey("isManual");
    }

    public void removeIsManual() {
        this._map.remove("isManual");
    }

    @Nullable
    public Boolean isIsManual(GetMode mode) {
        return this.isIsManual();
    }

    @Nullable
    public Boolean isIsManual() {
        if (this._isManualField != null) {
            return this._isManualField;
        }
        Object __rawValue = this._map.get("isManual");
        this._isManualField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isManualField;
    }

    public LineageRelationship setIsManual(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsManual(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsManual();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isManual", value);
                this._isManualField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isManual", value);
                this._isManualField = value;
            }
        }
        return this;
    }

    public LineageRelationship setIsManual(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isManual of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isManual", value);
        this._isManualField = value;
        return this;
    }

    public LineageRelationship setIsManual(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isManual", value);
        this._isManualField = value;
        return this;
    }

    public boolean hasDegrees() {
        if (this._degreesField != null) {
            return true;
        }
        return this._map.containsKey("degrees");
    }

    public void removeDegrees() {
        this._map.remove("degrees");
    }

    @Nullable
    public IntegerArray getDegrees(GetMode mode) {
        return this.getDegrees();
    }

    @Nullable
    public IntegerArray getDegrees() {
        if (this._degreesField != null) {
            return this._degreesField;
        }
        Object __rawValue = this._map.get("degrees");
        this._degreesField = __rawValue == null ? null : new IntegerArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._degreesField;
    }

    public LineageRelationship setDegrees(@Nullable IntegerArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDegrees(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDegrees();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "degrees", value.data());
                this._degreesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "degrees", value.data());
                this._degreesField = value;
            }
        }
        return this;
    }

    public LineageRelationship setDegrees(@Nonnull IntegerArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field degrees of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "degrees", value.data());
        this._degreesField = value;
        return this;
    }

    public boolean hasExplored() {
        if (this._exploredField != null) {
            return true;
        }
        return this._map.containsKey("explored");
    }

    public void removeExplored() {
        this._map.remove("explored");
    }

    @Nullable
    public Boolean isExplored(GetMode mode) {
        return this.isExplored();
    }

    @Nullable
    public Boolean isExplored() {
        if (this._exploredField != null) {
            return this._exploredField;
        }
        Object __rawValue = this._map.get("explored");
        this._exploredField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._exploredField;
    }

    public LineageRelationship setExplored(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExplored(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExplored();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "explored", value);
                this._exploredField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "explored", value);
                this._exploredField = value;
            }
        }
        return this;
    }

    public LineageRelationship setExplored(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field explored of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "explored", value);
        this._exploredField = value;
        return this;
    }

    public LineageRelationship setExplored(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "explored", value);
        this._exploredField = value;
        return this;
    }

    public boolean hasTruncatedChildren() {
        if (this._truncatedChildrenField != null) {
            return true;
        }
        return this._map.containsKey("truncatedChildren");
    }

    public void removeTruncatedChildren() {
        this._map.remove("truncatedChildren");
    }

    @Nullable
    public Boolean isTruncatedChildren(GetMode mode) {
        return this.isTruncatedChildren();
    }

    @Nullable
    public Boolean isTruncatedChildren() {
        if (this._truncatedChildrenField != null) {
            return this._truncatedChildrenField;
        }
        Object __rawValue = this._map.get("truncatedChildren");
        this._truncatedChildrenField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._truncatedChildrenField;
    }

    public LineageRelationship setTruncatedChildren(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTruncatedChildren(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTruncatedChildren();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
                this._truncatedChildrenField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
                this._truncatedChildrenField = value;
            }
        }
        return this;
    }

    public LineageRelationship setTruncatedChildren(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field truncatedChildren of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
        this._truncatedChildrenField = value;
        return this;
    }

    public LineageRelationship setTruncatedChildren(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "truncatedChildren", value);
        this._truncatedChildrenField = value;
        return this;
    }

    public boolean hasIgnoredAsHop() {
        if (this._ignoredAsHopField != null) {
            return true;
        }
        return this._map.containsKey("ignoredAsHop");
    }

    public void removeIgnoredAsHop() {
        this._map.remove("ignoredAsHop");
    }

    @Nullable
    public Boolean isIgnoredAsHop(GetMode mode) {
        return this.isIgnoredAsHop();
    }

    @Nullable
    public Boolean isIgnoredAsHop() {
        if (this._ignoredAsHopField != null) {
            return this._ignoredAsHopField;
        }
        Object __rawValue = this._map.get("ignoredAsHop");
        this._ignoredAsHopField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._ignoredAsHopField;
    }

    public LineageRelationship setIgnoredAsHop(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIgnoredAsHop(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIgnoredAsHop();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
                this._ignoredAsHopField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
                this._ignoredAsHopField = value;
            }
        }
        return this;
    }

    public LineageRelationship setIgnoredAsHop(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field ignoredAsHop of com.linkedin.metadata.graph.LineageRelationship to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
        this._ignoredAsHopField = value;
        return this;
    }

    public LineageRelationship setIgnoredAsHop(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "ignoredAsHop", value);
        this._ignoredAsHopField = value;
        return this;
    }

    @Override
    public LineageRelationship clone() throws CloneNotSupportedException {
        LineageRelationship __clone = (LineageRelationship)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public LineageRelationship copy() throws CloneNotSupportedException {
        LineageRelationship __copy = (LineageRelationship)super.copy();
        __copy._ignoredAsHopField = null;
        __copy._isManualField = null;
        __copy._degreeField = null;
        __copy._truncatedChildrenField = null;
        __copy._updatedOnField = null;
        __copy._typeField = null;
        __copy._createdOnField = null;
        __copy._degreesField = null;
        __copy._pathField = null;
        __copy._pathsField = null;
        __copy._exploredField = null;
        __copy._updatedActorField = null;
        __copy._createdActorField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Path = SCHEMA.getField("path");
        FIELD_Degree = SCHEMA.getField("degree");
        FIELD_CreatedOn = SCHEMA.getField("createdOn");
        FIELD_CreatedActor = SCHEMA.getField("createdActor");
        FIELD_UpdatedOn = SCHEMA.getField("updatedOn");
        FIELD_UpdatedActor = SCHEMA.getField("updatedActor");
        FIELD_IsManual = SCHEMA.getField("isManual");
        FIELD_Degrees = SCHEMA.getField("degrees");
        FIELD_Explored = SCHEMA.getField("explored");
        FIELD_TruncatedChildren = SCHEMA.getField("truncatedChildren");
        FIELD_IgnoredAsHop = SCHEMA.getField("ignoredAsHop");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_Paths = FIELD_Paths.getDefault() == null ? null : new UrnArrayArray(DataTemplateUtil.castOrThrow(FIELD_Paths.getDefault(), DataList.class));
        DEFAULT_Path = FIELD_Path.getDefault() == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(FIELD_Path.getDefault(), DataList.class));
        DEFAULT_Degree = DataTemplateUtil.coerceIntOutput(FIELD_Degree.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final LineageRelationship __objectRef;

        private ChangeListener(LineageRelationship reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "ignoredAsHop": {
                    this.__objectRef._ignoredAsHopField = null;
                    break;
                }
                case "isManual": {
                    this.__objectRef._isManualField = null;
                    break;
                }
                case "degree": {
                    this.__objectRef._degreeField = null;
                    break;
                }
                case "truncatedChildren": {
                    this.__objectRef._truncatedChildrenField = null;
                    break;
                }
                case "updatedOn": {
                    this.__objectRef._updatedOnField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "createdOn": {
                    this.__objectRef._createdOnField = null;
                    break;
                }
                case "degrees": {
                    this.__objectRef._degreesField = null;
                    break;
                }
                case "path": {
                    this.__objectRef._pathField = null;
                    break;
                }
                case "paths": {
                    this.__objectRef._pathsField = null;
                    break;
                }
                case "explored": {
                    this.__objectRef._exploredField = null;
                    break;
                }
                case "updatedActor": {
                    this.__objectRef._updatedActorField = null;
                    break;
                }
                case "createdActor": {
                    this.__objectRef._createdActorField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public PathSpec paths() {
            return new PathSpec(this.getPathComponents(), "paths");
        }

        public PathSpec paths(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "paths");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec path() {
            return new PathSpec(this.getPathComponents(), "path");
        }

        @Deprecated
        public PathSpec path(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "path");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec degree() {
            return new PathSpec(this.getPathComponents(), "degree");
        }

        public PathSpec createdOn() {
            return new PathSpec(this.getPathComponents(), "createdOn");
        }

        public PathSpec createdActor() {
            return new PathSpec(this.getPathComponents(), "createdActor");
        }

        public PathSpec updatedOn() {
            return new PathSpec(this.getPathComponents(), "updatedOn");
        }

        public PathSpec updatedActor() {
            return new PathSpec(this.getPathComponents(), "updatedActor");
        }

        public PathSpec isManual() {
            return new PathSpec(this.getPathComponents(), "isManual");
        }

        public PathSpec degrees() {
            return new PathSpec(this.getPathComponents(), "degrees");
        }

        public PathSpec degrees(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "degrees");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec explored() {
            return new PathSpec(this.getPathComponents(), "explored");
        }

        public PathSpec truncatedChildren() {
            return new PathSpec(this.getPathComponents(), "truncatedChildren");
        }

        public PathSpec ignoredAsHop() {
            return new PathSpec(this.getPathComponents(), "ignoredAsHop");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withPaths() {
            this.getDataMap().put("paths", 1);
            return this;
        }

        public ProjectionMask withPaths(Integer start, Integer count) {
            this.getDataMap().put("paths", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("paths").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("paths").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withPath() {
            this.getDataMap().put("path", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withPath(Integer start, Integer count) {
            this.getDataMap().put("path", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("path").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("path").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withDegree() {
            this.getDataMap().put("degree", 1);
            return this;
        }

        public ProjectionMask withCreatedOn() {
            this.getDataMap().put("createdOn", 1);
            return this;
        }

        public ProjectionMask withCreatedActor() {
            this.getDataMap().put("createdActor", 1);
            return this;
        }

        public ProjectionMask withUpdatedOn() {
            this.getDataMap().put("updatedOn", 1);
            return this;
        }

        public ProjectionMask withUpdatedActor() {
            this.getDataMap().put("updatedActor", 1);
            return this;
        }

        public ProjectionMask withIsManual() {
            this.getDataMap().put("isManual", 1);
            return this;
        }

        public ProjectionMask withDegrees() {
            this.getDataMap().put("degrees", 1);
            return this;
        }

        public ProjectionMask withDegrees(Integer start, Integer count) {
            this.getDataMap().put("degrees", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("degrees").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("degrees").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withExplored() {
            this.getDataMap().put("explored", 1);
            return this;
        }

        public ProjectionMask withTruncatedChildren() {
            this.getDataMap().put("truncatedChildren", 1);
            return this;
        }

        public ProjectionMask withIgnoredAsHop() {
            this.getDataMap().put("ignoredAsHop", 1);
            return this;
        }
    }
}

