/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.entity.ebean.batch;

import com.datahub.util.exception.ModelConversionException;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.AspectRetriever;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.MCLItem;
import com.linkedin.metadata.aspect.batch.MCPItem;
import com.linkedin.metadata.entity.AspectUtils;
import com.linkedin.metadata.entity.validation.ValidationApiUtils;
import com.linkedin.metadata.models.AspectSpec;
import com.linkedin.metadata.models.EntitySpec;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.utils.EntityKeyUtils;
import com.linkedin.metadata.utils.GenericRecordUtils;
import com.linkedin.metadata.utils.PegasusUtils;
import com.linkedin.mxe.MetadataChangeLog;
import com.linkedin.mxe.SystemMetadata;
import com.linkedin.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCLItemImpl
implements MCLItem {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MCLItemImpl.class);
    @Nonnull
    private final MetadataChangeLog metadataChangeLog;
    @Nullable
    private final RecordTemplate recordTemplate;
    @Nullable
    private final RecordTemplate previousRecordTemplate;
    private final EntitySpec entitySpec;
    private final AspectSpec aspectSpec;

    @Override
    public boolean isDatabaseDuplicateOf(BatchItem other) {
        return this.equals(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCLItemImpl that = (MCLItemImpl)o;
        return this.metadataChangeLog.equals(that.metadataChangeLog);
    }

    public int hashCode() {
        return this.metadataChangeLog.hashCode();
    }

    @Generated
    MCLItemImpl(@Nonnull MetadataChangeLog metadataChangeLog, @Nullable RecordTemplate recordTemplate, @Nullable RecordTemplate previousRecordTemplate, EntitySpec entitySpec, AspectSpec aspectSpec) {
        if (metadataChangeLog == null) {
            throw new NullPointerException("metadataChangeLog is marked non-null but is null");
        }
        this.metadataChangeLog = metadataChangeLog;
        this.recordTemplate = recordTemplate;
        this.previousRecordTemplate = previousRecordTemplate;
        this.entitySpec = entitySpec;
        this.aspectSpec = aspectSpec;
    }

    @Generated
    public static MCLItemImplBuilder builder() {
        return new MCLItemImplBuilder();
    }

    @Generated
    public MCLItemImplBuilder toBuilder() {
        return new MCLItemImplBuilder().metadataChangeLog(this.metadataChangeLog).recordTemplate(this.recordTemplate).previousRecordTemplate(this.previousRecordTemplate).entitySpec(this.entitySpec).aspectSpec(this.aspectSpec);
    }

    @Override
    @Nonnull
    @Generated
    public MetadataChangeLog getMetadataChangeLog() {
        return this.metadataChangeLog;
    }

    @Override
    @Nullable
    @Generated
    public RecordTemplate getRecordTemplate() {
        return this.recordTemplate;
    }

    @Override
    @Nullable
    @Generated
    public RecordTemplate getPreviousRecordTemplate() {
        return this.previousRecordTemplate;
    }

    @Override
    @Generated
    public EntitySpec getEntitySpec() {
        return this.entitySpec;
    }

    @Override
    @Generated
    public AspectSpec getAspectSpec() {
        return this.aspectSpec;
    }

    public static class MCLItemImplBuilder {
        @Generated
        private MetadataChangeLog metadataChangeLog;
        @Generated
        private RecordTemplate recordTemplate;
        @Generated
        private RecordTemplate previousRecordTemplate;
        @Generated
        private EntitySpec entitySpec;
        @Generated
        private AspectSpec aspectSpec;

        private MCLItemImpl build() {
            return null;
        }

        public MCLItemImpl build(MCPItem mcpItem, @Nullable RecordTemplate oldAspectValue, @Nullable SystemMetadata oldSystemMetadata, AspectRetriever aspectRetriever) {
            return MCLItemImpl.builder().build(PegasusUtils.constructMCL(mcpItem.getMetadataChangeProposal(), mcpItem.getUrn().getEntityType(), mcpItem.getUrn(), mcpItem.getChangeType(), mcpItem.getAspectName(), mcpItem.getAuditStamp(), mcpItem.getRecordTemplate(), mcpItem.getSystemMetadata(), oldAspectValue, oldSystemMetadata), aspectRetriever);
        }

        public MCLItemImpl build(MetadataChangeLog metadataChangeLog, AspectRetriever aspectRetriever) {
            return MCLItemImpl.builder().metadataChangeLog(metadataChangeLog).build(aspectRetriever);
        }

        public MCLItemImpl build(AspectRetriever aspectRetriever) {
            EntityRegistry entityRegistry = aspectRetriever.getEntityRegistry();
            log.debug("entity type = {}", (Object)this.metadataChangeLog.getEntityType());
            this.entitySpec(aspectRetriever.getEntityRegistry().getEntitySpec(this.metadataChangeLog.getEntityType()));
            this.aspectSpec(AspectUtils.validateAspect((MetadataChangeLog)this.metadataChangeLog, (EntitySpec)this.entitySpec));
            Urn urn = this.metadataChangeLog.getEntityUrn();
            if (urn == null) {
                urn = EntityKeyUtils.getUrnFromLog(this.metadataChangeLog, this.entitySpec.getKeyAspectSpec());
            }
            ValidationApiUtils.validateUrn(entityRegistry, urn);
            log.debug("entity type = {}", (Object)urn.getEntityType());
            this.entitySpec(entityRegistry.getEntitySpec(urn.getEntityType()));
            log.debug("entity spec = {}", (Object)this.entitySpec);
            this.aspectSpec(ValidationApiUtils.validateAspect(this.entitySpec, this.metadataChangeLog.getAspectName()));
            log.debug("aspect spec = {}", (Object)this.aspectSpec);
            Pair<RecordTemplate, RecordTemplate> aspects = MCLItemImplBuilder.convertToRecordTemplate(this.metadataChangeLog, this.aspectSpec);
            ValidationApiUtils.validateRecordTemplate(this.entitySpec, urn, aspects.getFirst(), aspectRetriever);
            return new MCLItemImpl(this.metadataChangeLog, aspects.getFirst(), aspects.getSecond(), this.entitySpec, this.aspectSpec);
        }

        private MCLItemImplBuilder entitySpec(EntitySpec entitySpec) {
            this.entitySpec = entitySpec;
            return this;
        }

        private MCLItemImplBuilder aspectSpec(AspectSpec aspectSpec) {
            this.aspectSpec = aspectSpec;
            return this;
        }

        private static Pair<RecordTemplate, RecordTemplate> convertToRecordTemplate(MetadataChangeLog mcl, AspectSpec aspectSpec) {
            RecordTemplate prevAspect;
            RecordTemplate aspect;
            try {
                if (!ChangeType.DELETE.equals((Object)mcl.getChangeType())) {
                    aspect = GenericRecordUtils.deserializeAspect(mcl.getAspect().getValue(), mcl.getAspect().getContentType(), aspectSpec);
                    ValidationApiUtils.validateTrimOrThrow(aspect);
                } else {
                    aspect = null;
                }
                if (mcl.getPreviousAspectValue() != null) {
                    prevAspect = GenericRecordUtils.deserializeAspect(mcl.getPreviousAspectValue().getValue(), mcl.getPreviousAspectValue().getContentType(), aspectSpec);
                    ValidationApiUtils.validateTrimOrThrow(prevAspect);
                } else {
                    prevAspect = null;
                }
            }
            catch (ModelConversionException e) {
                throw new RuntimeException(String.format("Could not deserialize %s for aspect %s", mcl.getAspect().getValue(), mcl.getAspectName()));
            }
            return Pair.of(aspect, prevAspect);
        }

        @Generated
        MCLItemImplBuilder() {
        }

        @Generated
        public MCLItemImplBuilder metadataChangeLog(@Nonnull MetadataChangeLog metadataChangeLog) {
            if (metadataChangeLog == null) {
                throw new NullPointerException("metadataChangeLog is marked non-null but is null");
            }
            this.metadataChangeLog = metadataChangeLog;
            return this;
        }

        @Generated
        public MCLItemImplBuilder recordTemplate(@Nullable RecordTemplate recordTemplate) {
            this.recordTemplate = recordTemplate;
            return this;
        }

        @Generated
        public MCLItemImplBuilder previousRecordTemplate(@Nullable RecordTemplate previousRecordTemplate) {
            this.previousRecordTemplate = previousRecordTemplate;
            return this;
        }

        @Generated
        public String toString() {
            return "MCLItemImpl.MCLItemImplBuilder(metadataChangeLog=" + String.valueOf(this.metadataChangeLog) + ", recordTemplate=" + String.valueOf(this.recordTemplate) + ", previousRecordTemplate=" + String.valueOf(this.previousRecordTemplate) + ", entitySpec=" + String.valueOf(this.entitySpec) + ", aspectSpec=" + String.valueOf(this.aspectSpec) + ")";
        }
    }
}

