/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.builder;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.ByteString;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.mxe.GenericAspect;
import com.linkedin.mxe.MetadataChangeProposal;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.ArrayNode;
import datahub.shaded.jackson.databind.node.JsonNodeFactory;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class AbstractMultiFieldPatchBuilder<T extends AbstractMultiFieldPatchBuilder<T>> {
    public static final String OP_KEY = "op";
    public static final String VALUE_KEY = "value";
    public static final String PATH_KEY = "path";
    protected List<ImmutableTriple<String, String, JsonNode>> pathValues = new ArrayList<ImmutableTriple<String, String, JsonNode>>();
    protected Urn targetEntityUrn = null;

    public MetadataChangeProposal build() {
        MetadataChangeProposal proposal = new MetadataChangeProposal();
        proposal.setChangeType(ChangeType.PATCH);
        proposal.setEntityType(this.getEntityType());
        proposal.setEntityUrn(this.targetEntityUrn);
        proposal.setAspectName(this.getAspectName());
        proposal.setAspect(this.buildPatch());
        return proposal;
    }

    public T urn(Urn urn) {
        this.targetEntityUrn = urn;
        return (T)this;
    }

    protected abstract String getAspectName();

    protected abstract String getEntityType();

    protected static String encodeValue(@Nonnull String value) {
        return value.replace("~ ", "~0").replace("/", "~1");
    }

    protected static String encodeValueUrn(@Nonnull Urn urn) {
        return AbstractMultiFieldPatchBuilder.encodeValue(urn.toString());
    }

    protected GenericAspect buildPatch() {
        if (this.pathValues.isEmpty()) {
            throw new IllegalArgumentException("No patches specified.");
        }
        ArrayNode patches = JsonNodeFactory.instance.arrayNode();
        List<ImmutableTriple<String, String, JsonNode>> triples = this.getPathValues();
        triples.forEach(triple -> patches.add((JsonNode)JsonNodeFactory.instance.objectNode().put(OP_KEY, (String)triple.left).put(PATH_KEY, (String)triple.middle).set(VALUE_KEY, (JsonNode)triple.right)));
        GenericAspect genericAspect = new GenericAspect();
        genericAspect.setContentType("application/json");
        genericAspect.setValue(ByteString.copyString(patches.toString(), StandardCharsets.UTF_8));
        return genericAspect;
    }

    protected List<ImmutableTriple<String, String, JsonNode>> getPathValues() {
        return this.pathValues;
    }
}

