/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.incident;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.incident.IncidentAssigneeArray;
import com.linkedin.incident.IncidentSource;
import com.linkedin.incident.IncidentStatus;
import com.linkedin.incident.IncidentType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncidentInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.incident/**Information about an incident raised on an asset.*/@Aspect.name=\"incidentInfo\"record IncidentInfo{/**The type of incident*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Type\"}type:/**A type of asset incident*/enum IncidentType{/**An Freshness Assertion has failed, triggering the incident.\nRaised on entities where assertions are configured to generate incidents.*/FRESHNESS/**An Volume Assertion has failed, triggering the incident.\nRaised on entities where assertions are configured to generate incidents.*/VOLUME/**A Field Assertion has failed, triggering the incident.\nRaised on entities where assertions are configured to generate incidents.*/FIELD/**A raw SQL-statement based assertion has failed, triggering the incident.\nRaised on entities where assertions are configured to generate incidents.*/SQL/**A Data Schema assertion has failed, triggering the incident.\nRaised on entities where assertions are configured to generate incidents.*/DATA_SCHEMA/**A misc. operational incident, e.g. failure to materialize a dataset.*/OPERATIONAL/**A custom type of incident*/CUSTOM}/**An optional custom incident type. Present only if type is 'CUSTOM'.*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Other Type\"}customType:optional string/**Optional title associated with the incident*/title:optional string/**Optional description associated with the incident*/description:optional string/**A reference to the entity associated with the incident.*/@Relationship.`/*`={\"entityTypes\":[\"dataset\",\"chart\",\"dashboard\",\"dataFlow\",\"dataJob\",\"schemaField\"],\"name\":\"IncidentOn\"}@Searchable.`/*`.fieldType=\"URN\"entities:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**A numeric severity or priority for the incident. On the UI we will translate this into something easy to understand.\nCurrently supported: 0 - CRITICAL, 1 - HIGH, 2 - MED, 3 - LOW\n(We probably should have modeled as an enum)*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Priority\"}priority:optional int=0/**The parties assigned with resolving the incident*/assignees:optional array[/**The incident assignee type.\nThis is in a record so that we can add additional fields if we need to later (e.g.\nthe type of the assignee.*/record IncidentAssignee{/**The user or group assigned to the incident.*/@Searchable={\"addToFilters\":true,\"fieldName\":\"assignees\",\"filterNameOverride\":\"Assignee\"}actor:com.linkedin.common.Urn/**The time & actor responsible for assiging the assignee.*/assignedAt:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}]/**The current status of an incident, i.e. active or inactive.*/status:/**Information about an incident raised on an asset*/record IncidentStatus{/**The top-level state of the incident, whether it's active or resolved.*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Status\"}state:enum IncidentState{/**The incident is ongoing, or active.*/ACTIVE/**The incident is resolved.*/RESOLVED}/**The lifecycle stage for the incident - Null means no stage was assigned yet.\nIn the future, we may add CUSTOM here with a customStage string field for user-defined stages.*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Stage\"}stage:optional enum IncidentStage{/**The impact and priority of the incident is being actively assessed.*/TRIAGE/**The incident root cause is being investigated.*/INVESTIGATION/**The incident is in the remediation stage.*/WORK_IN_PROGRESS/**The incident is in the resolved as completed stage.*/FIXED/**The incident is in the resolved with no action required state, e.g. the\nincident was a false positive, or was expected.*/NO_ACTION_REQUIRED}/**Optional message associated with the incident*/message:optional string/**The time at which the request was initially created*/@Searchable.`/time`={\"fieldName\":\"lastUpdated\",\"fieldType\":\"COUNT\"}lastUpdated:com.linkedin.common.AuditStamp}/**The source of an incident, i.e. how it was generated.*/source:optional/**Information about the source of an incident raised on an asset.*/@Aspect.name=\"incidentSource\"record IncidentSource{/**Message associated with the incident*/@Searchable={\"addToFilters\":true,\"filterNameOverride\":\"Source\"}type:enum IncidentSourceType{/**Manually created incident, via UI or API.*/MANUAL/**An assertion has failed, triggering the incident.*/ASSERTION_FAILURE}/**Reference to an URN related to the source of an incident.*/@Searchable.fieldType=\"URN\"sourceUrn:optional com.linkedin.common.Urn}/**The time at which the incident actually started (may be before the date it was raised).*/@Searchable.`/time`={\"fieldName\":\"startedAt\",\"fieldType\":\"COUNT\"}startedAt:optional com.linkedin.common.Time/**The time at which the request was initially created*/@Searchable.`/time`={\"fieldName\":\"created\",\"fieldType\":\"COUNT\"}created:com.linkedin.common.AuditStamp}", SchemaFormatType.PDL);
    private IncidentType _typeField = null;
    private String _customTypeField = null;
    private String _titleField = null;
    private String _descriptionField = null;
    private UrnArray _entitiesField = null;
    private Integer _priorityField = null;
    private IncidentAssigneeArray _assigneesField = null;
    private IncidentStatus _statusField = null;
    private IncidentSource _sourceField = null;
    private Long _startedAtField = null;
    private AuditStamp _createdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_CustomType = SCHEMA.getField("customType");
    private static final RecordDataSchema.Field FIELD_Title = SCHEMA.getField("title");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Entities = SCHEMA.getField("entities");
    private static final RecordDataSchema.Field FIELD_Priority = SCHEMA.getField("priority");
    private static final Integer DEFAULT_Priority;
    private static final RecordDataSchema.Field FIELD_Assignees;
    private static final RecordDataSchema.Field FIELD_Status;
    private static final RecordDataSchema.Field FIELD_Source;
    private static final RecordDataSchema.Field FIELD_StartedAt;
    private static final RecordDataSchema.Field FIELD_Created;

    public IncidentInfo() {
        super(new DataMap(15, 0.75f), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public IncidentInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public IncidentType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, IncidentType.class, IncidentType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IncidentType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, IncidentType.class, IncidentType.$UNKNOWN);
        return this._typeField;
    }

    public IncidentInfo setType(@Nullable IncidentType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.incident.IncidentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public IncidentInfo setType(@Nonnull IncidentType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasCustomType() {
        if (this._customTypeField != null) {
            return true;
        }
        return this._map.containsKey("customType");
    }

    public void removeCustomType() {
        this._map.remove("customType");
    }

    @Nullable
    public String getCustomType(GetMode mode) {
        return this.getCustomType();
    }

    @Nullable
    public String getCustomType() {
        if (this._customTypeField != null) {
            return this._customTypeField;
        }
        Object __rawValue = this._map.get("customType");
        this._customTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._customTypeField;
    }

    public IncidentInfo setCustomType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customType", value);
                this._customTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customType", value);
                this._customTypeField = value;
            }
        }
        return this;
    }

    public IncidentInfo setCustomType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customType of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customType", value);
        this._customTypeField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        return this.getTitle();
    }

    @Nullable
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public IncidentInfo setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public IncidentInfo setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public IncidentInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public IncidentInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasEntities() {
        if (this._entitiesField != null) {
            return true;
        }
        return this._map.containsKey("entities");
    }

    public void removeEntities() {
        this._map.remove("entities");
    }

    @Nullable
    public UrnArray getEntities(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntities();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entitiesField != null) {
                    return this._entitiesField;
                }
                Object __rawValue = this._map.get("entities");
                this._entitiesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._entitiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getEntities() {
        if (this._entitiesField != null) {
            return this._entitiesField;
        }
        Object __rawValue = this._map.get("entities");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entities");
        }
        this._entitiesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._entitiesField;
    }

    public IncidentInfo setEntities(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntities(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entities of com.linkedin.incident.IncidentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntities();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
                this._entitiesField = value;
            }
        }
        return this;
    }

    public IncidentInfo setEntities(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entities of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entities", value.data());
        this._entitiesField = value;
        return this;
    }

    public boolean hasPriority() {
        if (this._priorityField != null) {
            return true;
        }
        return this._map.containsKey("priority");
    }

    public void removePriority() {
        this._map.remove("priority");
    }

    @Nullable
    public Integer getPriority(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPriority();
            }
            case NULL: {
                if (this._priorityField != null) {
                    return this._priorityField;
                }
                Object __rawValue = this._map.get("priority");
                this._priorityField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._priorityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public Integer getPriority() {
        if (this._priorityField != null) {
            return this._priorityField;
        }
        Object __rawValue = this._map.get("priority");
        if (__rawValue == null) {
            return DEFAULT_Priority;
        }
        this._priorityField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._priorityField;
    }

    public IncidentInfo setPriority(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPriority(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePriority();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
                this._priorityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
                this._priorityField = value;
            }
        }
        return this;
    }

    public IncidentInfo setPriority(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field priority of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
        this._priorityField = value;
        return this;
    }

    public IncidentInfo setPriority(int value) {
        CheckedUtil.putWithoutChecking(this._map, "priority", DataTemplateUtil.coerceIntInput(value));
        this._priorityField = value;
        return this;
    }

    public boolean hasAssignees() {
        if (this._assigneesField != null) {
            return true;
        }
        return this._map.containsKey("assignees");
    }

    public void removeAssignees() {
        this._map.remove("assignees");
    }

    @Nullable
    public IncidentAssigneeArray getAssignees(GetMode mode) {
        return this.getAssignees();
    }

    @Nullable
    public IncidentAssigneeArray getAssignees() {
        if (this._assigneesField != null) {
            return this._assigneesField;
        }
        Object __rawValue = this._map.get("assignees");
        this._assigneesField = __rawValue == null ? null : new IncidentAssigneeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._assigneesField;
    }

    public IncidentInfo setAssignees(@Nullable IncidentAssigneeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAssignees(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAssignees();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "assignees", value.data());
                this._assigneesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "assignees", value.data());
                this._assigneesField = value;
            }
        }
        return this;
    }

    public IncidentInfo setAssignees(@Nonnull IncidentAssigneeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field assignees of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "assignees", value.data());
        this._assigneesField = value;
        return this;
    }

    public boolean hasStatus() {
        if (this._statusField != null) {
            return true;
        }
        return this._map.containsKey("status");
    }

    public void removeStatus() {
        this._map.remove("status");
    }

    @Nullable
    public IncidentStatus getStatus(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getStatus();
            }
            case DEFAULT: 
            case NULL: {
                if (this._statusField != null) {
                    return this._statusField;
                }
                Object __rawValue = this._map.get("status");
                this._statusField = __rawValue == null ? null : new IncidentStatus(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._statusField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public IncidentStatus getStatus() {
        if (this._statusField != null) {
            return this._statusField;
        }
        Object __rawValue = this._map.get("status");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("status");
        }
        this._statusField = __rawValue == null ? null : new IncidentStatus(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._statusField;
    }

    public IncidentInfo setStatus(@Nullable IncidentStatus value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStatus(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field status of com.linkedin.incident.IncidentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.data());
                this._statusField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStatus();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "status", value.data());
                this._statusField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "status", value.data());
                this._statusField = value;
            }
        }
        return this;
    }

    public IncidentInfo setStatus(@Nonnull IncidentStatus value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field status of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "status", value.data());
        this._statusField = value;
        return this;
    }

    public boolean hasSource() {
        if (this._sourceField != null) {
            return true;
        }
        return this._map.containsKey("source");
    }

    public void removeSource() {
        this._map.remove("source");
    }

    @Nullable
    public IncidentSource getSource(GetMode mode) {
        return this.getSource();
    }

    @Nullable
    public IncidentSource getSource() {
        if (this._sourceField != null) {
            return this._sourceField;
        }
        Object __rawValue = this._map.get("source");
        this._sourceField = __rawValue == null ? null : new IncidentSource(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._sourceField;
    }

    public IncidentInfo setSource(@Nullable IncidentSource value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "source", value.data());
                this._sourceField = value;
            }
        }
        return this;
    }

    public IncidentInfo setSource(@Nonnull IncidentSource value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field source of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "source", value.data());
        this._sourceField = value;
        return this;
    }

    public boolean hasStartedAt() {
        if (this._startedAtField != null) {
            return true;
        }
        return this._map.containsKey("startedAt");
    }

    public void removeStartedAt() {
        this._map.remove("startedAt");
    }

    @Nullable
    public Long getStartedAt(GetMode mode) {
        return this.getStartedAt();
    }

    @Nullable
    public Long getStartedAt() {
        if (this._startedAtField != null) {
            return this._startedAtField;
        }
        Object __rawValue = this._map.get("startedAt");
        this._startedAtField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._startedAtField;
    }

    public IncidentInfo setStartedAt(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setStartedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeStartedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "startedAt", DataTemplateUtil.coerceLongInput(value));
                this._startedAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "startedAt", DataTemplateUtil.coerceLongInput(value));
                this._startedAtField = value;
            }
        }
        return this;
    }

    public IncidentInfo setStartedAt(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field startedAt of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "startedAt", DataTemplateUtil.coerceLongInput(value));
        this._startedAtField = value;
        return this;
    }

    public IncidentInfo setStartedAt(long value) {
        CheckedUtil.putWithoutChecking(this._map, "startedAt", DataTemplateUtil.coerceLongInput(value));
        this._startedAtField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public IncidentInfo setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.incident.IncidentInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public IncidentInfo setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.incident.IncidentInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    @Override
    public IncidentInfo clone() throws CloneNotSupportedException {
        IncidentInfo __clone = (IncidentInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncidentInfo copy() throws CloneNotSupportedException {
        IncidentInfo __copy = (IncidentInfo)super.copy();
        __copy._customTypeField = null;
        __copy._entitiesField = null;
        __copy._createdField = null;
        __copy._descriptionField = null;
        __copy._assigneesField = null;
        __copy._startedAtField = null;
        __copy._sourceField = null;
        __copy._typeField = null;
        __copy._titleField = null;
        __copy._priorityField = null;
        __copy._statusField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Assignees = SCHEMA.getField("assignees");
        FIELD_Status = SCHEMA.getField("status");
        FIELD_Source = SCHEMA.getField("source");
        FIELD_StartedAt = SCHEMA.getField("startedAt");
        FIELD_Created = SCHEMA.getField("created");
        DEFAULT_Priority = DataTemplateUtil.coerceIntOutput(FIELD_Priority.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncidentInfo __objectRef;

        private ChangeListener(IncidentInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "customType": {
                    this.__objectRef._customTypeField = null;
                    break;
                }
                case "entities": {
                    this.__objectRef._entitiesField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "assignees": {
                    this.__objectRef._assigneesField = null;
                    break;
                }
                case "startedAt": {
                    this.__objectRef._startedAtField = null;
                    break;
                }
                case "source": {
                    this.__objectRef._sourceField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "priority": {
                    this.__objectRef._priorityField = null;
                    break;
                }
                case "status": {
                    this.__objectRef._statusField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec customType() {
            return new PathSpec(this.getPathComponents(), "customType");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec entities() {
            return new PathSpec(this.getPathComponents(), "entities");
        }

        public PathSpec entities(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "entities");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec priority() {
            return new PathSpec(this.getPathComponents(), "priority");
        }

        public IncidentAssigneeArray.Fields assignees() {
            return new IncidentAssigneeArray.Fields(this.getPathComponents(), "assignees");
        }

        public PathSpec assignees(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "assignees");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public IncidentStatus.Fields status() {
            return new IncidentStatus.Fields(this.getPathComponents(), "status");
        }

        public IncidentSource.Fields source() {
            return new IncidentSource.Fields(this.getPathComponents(), "source");
        }

        public PathSpec startedAt() {
            return new PathSpec(this.getPathComponents(), "startedAt");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private IncidentAssigneeArray.ProjectionMask _assigneesMask;
        private IncidentStatus.ProjectionMask _statusMask;
        private IncidentSource.ProjectionMask _sourceMask;
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
            super(15);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withCustomType() {
            this.getDataMap().put("customType", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withEntities() {
            this.getDataMap().put("entities", 1);
            return this;
        }

        public ProjectionMask withEntities(Integer start, Integer count) {
            this.getDataMap().put("entities", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("entities").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entities").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPriority() {
            this.getDataMap().put("priority", 1);
            return this;
        }

        public ProjectionMask withAssignees(Function<IncidentAssigneeArray.ProjectionMask, IncidentAssigneeArray.ProjectionMask> nestedMask) {
            this._assigneesMask = nestedMask.apply(this._assigneesMask == null ? IncidentAssigneeArray.createMask() : this._assigneesMask);
            this.getDataMap().put("assignees", this._assigneesMask.getDataMap());
            return this;
        }

        public ProjectionMask withAssignees() {
            this._assigneesMask = null;
            this.getDataMap().put("assignees", 1);
            return this;
        }

        public ProjectionMask withAssignees(Function<IncidentAssigneeArray.ProjectionMask, IncidentAssigneeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._assigneesMask = nestedMask.apply(this._assigneesMask == null ? IncidentAssigneeArray.createMask() : this._assigneesMask);
            this.getDataMap().put("assignees", this._assigneesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("assignees").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("assignees").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAssignees(Integer start, Integer count) {
            this._assigneesMask = null;
            this.getDataMap().put("assignees", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("assignees").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("assignees").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withStatus(Function<IncidentStatus.ProjectionMask, IncidentStatus.ProjectionMask> nestedMask) {
            this._statusMask = nestedMask.apply(this._statusMask == null ? IncidentStatus.createMask() : this._statusMask);
            this.getDataMap().put("status", this._statusMask.getDataMap());
            return this;
        }

        public ProjectionMask withStatus() {
            this._statusMask = null;
            this.getDataMap().put("status", 1);
            return this;
        }

        public ProjectionMask withSource(Function<IncidentSource.ProjectionMask, IncidentSource.ProjectionMask> nestedMask) {
            this._sourceMask = nestedMask.apply(this._sourceMask == null ? IncidentSource.createMask() : this._sourceMask);
            this.getDataMap().put("source", this._sourceMask.getDataMap());
            return this;
        }

        public ProjectionMask withSource() {
            this._sourceMask = null;
            this.getDataMap().put("source", 1);
            return this;
        }

        public ProjectionMask withStartedAt() {
            this.getDataMap().put("startedAt", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }
    }
}

