/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.incident;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IncidentAssignee
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.incident/**The incident assignee type.\nThis is in a record so that we can add additional fields if we need to later (e.g.\nthe type of the assignee.*/record IncidentAssignee{/**The user or group assigned to the incident.*/@Searchable={\"addToFilters\":true,\"fieldName\":\"assignees\",\"filterNameOverride\":\"Assignee\"}actor:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The time & actor responsible for assiging the assignee.*/assignedAt:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private Urn _actorField = null;
    private AuditStamp _assignedAtField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Actor = SCHEMA.getField("actor");
    private static final RecordDataSchema.Field FIELD_AssignedAt = SCHEMA.getField("assignedAt");

    public IncidentAssignee() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public IncidentAssignee(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasActor() {
        if (this._actorField != null) {
            return true;
        }
        return this._map.containsKey("actor");
    }

    public void removeActor() {
        this._map.remove("actor");
    }

    @Nullable
    public Urn getActor(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getActor();
            }
            case DEFAULT: 
            case NULL: {
                if (this._actorField != null) {
                    return this._actorField;
                }
                Object __rawValue = this._map.get("actor");
                this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._actorField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getActor() {
        if (this._actorField != null) {
            return this._actorField;
        }
        Object __rawValue = this._map.get("actor");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("actor");
        }
        this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._actorField;
    }

    public IncidentAssignee setActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field actor of com.linkedin.incident.IncidentAssignee");
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
            }
        }
        return this;
    }

    public IncidentAssignee setActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actor of com.linkedin.incident.IncidentAssignee to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._actorField = value;
        return this;
    }

    public boolean hasAssignedAt() {
        if (this._assignedAtField != null) {
            return true;
        }
        return this._map.containsKey("assignedAt");
    }

    public void removeAssignedAt() {
        this._map.remove("assignedAt");
    }

    @Nullable
    public AuditStamp getAssignedAt(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAssignedAt();
            }
            case DEFAULT: 
            case NULL: {
                if (this._assignedAtField != null) {
                    return this._assignedAtField;
                }
                Object __rawValue = this._map.get("assignedAt");
                this._assignedAtField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._assignedAtField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getAssignedAt() {
        if (this._assignedAtField != null) {
            return this._assignedAtField;
        }
        Object __rawValue = this._map.get("assignedAt");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("assignedAt");
        }
        this._assignedAtField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._assignedAtField;
    }

    public IncidentAssignee setAssignedAt(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAssignedAt(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field assignedAt of com.linkedin.incident.IncidentAssignee");
                }
                CheckedUtil.putWithoutChecking(this._map, "assignedAt", value.data());
                this._assignedAtField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAssignedAt();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "assignedAt", value.data());
                this._assignedAtField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "assignedAt", value.data());
                this._assignedAtField = value;
            }
        }
        return this;
    }

    public IncidentAssignee setAssignedAt(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field assignedAt of com.linkedin.incident.IncidentAssignee to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "assignedAt", value.data());
        this._assignedAtField = value;
        return this;
    }

    @Override
    public IncidentAssignee clone() throws CloneNotSupportedException {
        IncidentAssignee __clone = (IncidentAssignee)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public IncidentAssignee copy() throws CloneNotSupportedException {
        IncidentAssignee __copy = (IncidentAssignee)super.copy();
        __copy._actorField = null;
        __copy._assignedAtField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final IncidentAssignee __objectRef;

        private ChangeListener(IncidentAssignee reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "actor": {
                    this.__objectRef._actorField = null;
                    break;
                }
                case "assignedAt": {
                    this.__objectRef._assignedAtField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec actor() {
            return new PathSpec(this.getPathComponents(), "actor");
        }

        public AuditStamp.Fields assignedAt() {
            return new AuditStamp.Fields(this.getPathComponents(), "assignedAt");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _assignedAtMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withActor() {
            this.getDataMap().put("actor", 1);
            return this;
        }

        public ProjectionMask withAssignedAt(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._assignedAtMask = nestedMask.apply(this._assignedAtMask == null ? AuditStamp.createMask() : this._assignedAtMask);
            this.getDataMap().put("assignedAt", this._assignedAtMask.getDataMap());
            return this;
        }

        public ProjectionMask withAssignedAt(MaskMap nestedMask) {
            this.getDataMap().put("assignedAt", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAssignedAt() {
            this._assignedAtMask = null;
            this.getDataMap().put("assignedAt", 1);
            return this;
        }
    }
}

