/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.identity;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.event.notification.settings.NotificationSettings;
import com.linkedin.identity.CorpUserAppearanceSettings;
import com.linkedin.identity.CorpUserViewsSettings;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CorpUserSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.identity/**Settings that a user can customize through the datahub ui*/@Aspect.name=\"corpUserSettings\"record CorpUserSettings{/**Settings for a user around the appearance of their DataHub U*/appearance:/**Settings for a user around the appearance of their DataHub UI*/record CorpUserAppearanceSettings{/**Flag whether the user should see a homepage with only datasets, charts and dashboards. Intended for users\nwho have less operational use cases for the datahub tool.*/showSimplifiedHomepage:optional boolean/**Flag controlling whether the V2 UI for DataHub is shown.*/showThemeV2:optional boolean}/**User preferences for the Views feature.*/views:optional/**Settings related to the 'Views' feature.*/record CorpUserViewsSettings{/**The default View which is selected for the user.\nIf none is chosen, then this value will be left blank.*/defaultView:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**Notification settings for a user*/notificationSettings:optional{namespace com.linkedin.event.notification.settings/**Notification settings for an actor or subscription.*/record NotificationSettings{/**Sink types that notifications are sent to.*/sinkTypes:array[{namespace com.linkedin.event.notification/**A type of sink / platform to send a notification to.*/enum NotificationSinkType{/**Slack target type.*/SLACK/**Email target type.*/EMAIL}}]/**Slack Notification Settings*/slackSettings:optional/**Slack Notification settings for an actor.*/record SlackNotificationSettings{/**Optional user handle*/userHandle:optional string/**Optional list of channels to send notifications to*/channels:optional array[string]}/**Email Notification Settings*/emailSettings:optional/**Email Notification settings for an actor.*/record EmailNotificationSettings{/**Optional user or group email address*/email:string}}}}", SchemaFormatType.PDL);
    private CorpUserAppearanceSettings _appearanceField = null;
    private CorpUserViewsSettings _viewsField = null;
    private NotificationSettings _notificationSettingsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Appearance = SCHEMA.getField("appearance");
    private static final RecordDataSchema.Field FIELD_Views = SCHEMA.getField("views");
    private static final RecordDataSchema.Field FIELD_NotificationSettings = SCHEMA.getField("notificationSettings");

    public CorpUserSettings() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public CorpUserSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasAppearance() {
        if (this._appearanceField != null) {
            return true;
        }
        return this._map.containsKey("appearance");
    }

    public void removeAppearance() {
        this._map.remove("appearance");
    }

    @Nullable
    public CorpUserAppearanceSettings getAppearance(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAppearance();
            }
            case DEFAULT: 
            case NULL: {
                if (this._appearanceField != null) {
                    return this._appearanceField;
                }
                Object __rawValue = this._map.get("appearance");
                this._appearanceField = __rawValue == null ? null : new CorpUserAppearanceSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._appearanceField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public CorpUserAppearanceSettings getAppearance() {
        if (this._appearanceField != null) {
            return this._appearanceField;
        }
        Object __rawValue = this._map.get("appearance");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("appearance");
        }
        this._appearanceField = __rawValue == null ? null : new CorpUserAppearanceSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._appearanceField;
    }

    public CorpUserSettings setAppearance(@Nullable CorpUserAppearanceSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAppearance(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field appearance of com.linkedin.identity.CorpUserSettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "appearance", value.data());
                this._appearanceField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAppearance();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "appearance", value.data());
                this._appearanceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "appearance", value.data());
                this._appearanceField = value;
            }
        }
        return this;
    }

    public CorpUserSettings setAppearance(@Nonnull CorpUserAppearanceSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field appearance of com.linkedin.identity.CorpUserSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "appearance", value.data());
        this._appearanceField = value;
        return this;
    }

    public boolean hasViews() {
        if (this._viewsField != null) {
            return true;
        }
        return this._map.containsKey("views");
    }

    public void removeViews() {
        this._map.remove("views");
    }

    @Nullable
    public CorpUserViewsSettings getViews(GetMode mode) {
        return this.getViews();
    }

    @Nullable
    public CorpUserViewsSettings getViews() {
        if (this._viewsField != null) {
            return this._viewsField;
        }
        Object __rawValue = this._map.get("views");
        this._viewsField = __rawValue == null ? null : new CorpUserViewsSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._viewsField;
    }

    public CorpUserSettings setViews(@Nullable CorpUserViewsSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setViews(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeViews();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "views", value.data());
                this._viewsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "views", value.data());
                this._viewsField = value;
            }
        }
        return this;
    }

    public CorpUserSettings setViews(@Nonnull CorpUserViewsSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field views of com.linkedin.identity.CorpUserSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "views", value.data());
        this._viewsField = value;
        return this;
    }

    public boolean hasNotificationSettings() {
        if (this._notificationSettingsField != null) {
            return true;
        }
        return this._map.containsKey("notificationSettings");
    }

    public void removeNotificationSettings() {
        this._map.remove("notificationSettings");
    }

    @Nullable
    public NotificationSettings getNotificationSettings(GetMode mode) {
        return this.getNotificationSettings();
    }

    @Nullable
    public NotificationSettings getNotificationSettings() {
        if (this._notificationSettingsField != null) {
            return this._notificationSettingsField;
        }
        Object __rawValue = this._map.get("notificationSettings");
        this._notificationSettingsField = __rawValue == null ? null : new NotificationSettings(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._notificationSettingsField;
    }

    public CorpUserSettings setNotificationSettings(@Nullable NotificationSettings value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNotificationSettings(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNotificationSettings();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "notificationSettings", value.data());
                this._notificationSettingsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "notificationSettings", value.data());
                this._notificationSettingsField = value;
            }
        }
        return this;
    }

    public CorpUserSettings setNotificationSettings(@Nonnull NotificationSettings value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field notificationSettings of com.linkedin.identity.CorpUserSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "notificationSettings", value.data());
        this._notificationSettingsField = value;
        return this;
    }

    @Override
    public CorpUserSettings clone() throws CloneNotSupportedException {
        CorpUserSettings __clone = (CorpUserSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public CorpUserSettings copy() throws CloneNotSupportedException {
        CorpUserSettings __copy = (CorpUserSettings)super.copy();
        __copy._appearanceField = null;
        __copy._viewsField = null;
        __copy._notificationSettingsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final CorpUserSettings __objectRef;

        private ChangeListener(CorpUserSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "appearance": {
                    this.__objectRef._appearanceField = null;
                    break;
                }
                case "views": {
                    this.__objectRef._viewsField = null;
                    break;
                }
                case "notificationSettings": {
                    this.__objectRef._notificationSettingsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public CorpUserAppearanceSettings.Fields appearance() {
            return new CorpUserAppearanceSettings.Fields(this.getPathComponents(), "appearance");
        }

        public CorpUserViewsSettings.Fields views() {
            return new CorpUserViewsSettings.Fields(this.getPathComponents(), "views");
        }

        public NotificationSettings.Fields notificationSettings() {
            return new NotificationSettings.Fields(this.getPathComponents(), "notificationSettings");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private CorpUserAppearanceSettings.ProjectionMask _appearanceMask;
        private CorpUserViewsSettings.ProjectionMask _viewsMask;
        private NotificationSettings.ProjectionMask _notificationSettingsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withAppearance(Function<CorpUserAppearanceSettings.ProjectionMask, CorpUserAppearanceSettings.ProjectionMask> nestedMask) {
            this._appearanceMask = nestedMask.apply(this._appearanceMask == null ? CorpUserAppearanceSettings.createMask() : this._appearanceMask);
            this.getDataMap().put("appearance", this._appearanceMask.getDataMap());
            return this;
        }

        public ProjectionMask withAppearance() {
            this._appearanceMask = null;
            this.getDataMap().put("appearance", 1);
            return this;
        }

        public ProjectionMask withViews(Function<CorpUserViewsSettings.ProjectionMask, CorpUserViewsSettings.ProjectionMask> nestedMask) {
            this._viewsMask = nestedMask.apply(this._viewsMask == null ? CorpUserViewsSettings.createMask() : this._viewsMask);
            this.getDataMap().put("views", this._viewsMask.getDataMap());
            return this;
        }

        public ProjectionMask withViews() {
            this._viewsMask = null;
            this.getDataMap().put("views", 1);
            return this;
        }

        public ProjectionMask withNotificationSettings(Function<NotificationSettings.ProjectionMask, NotificationSettings.ProjectionMask> nestedMask) {
            this._notificationSettingsMask = nestedMask.apply(this._notificationSettingsMask == null ? NotificationSettings.createMask() : this._notificationSettingsMask);
            this.getDataMap().put("notificationSettings", this._notificationSettingsMask.getDataMap());
            return this;
        }

        public ProjectionMask withNotificationSettings() {
            this._notificationSettingsMask = null;
            this.getDataMap().put("notificationSettings", 1);
            return this;
        }
    }
}

