/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.dataset.DatasetFieldUpstream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class DatasetFieldUpstreamArray
extends WrappingArrayTemplate<DatasetFieldUpstream> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[union[{namespace com.linkedin.common/**Standardized dataset field information identifier.*/@deprecated=\"use SchemaFieldPath and represent as generic Urn instead\"@java.class=\"com.linkedin.common.urn.DatasetFieldUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset field information identifier\",\"entityType\":\"datasetField\",\"fields\":[{\"doc\":\"Dataset that this dataset field belongs to.\",\"name\":\"dataset\",\"type\":\"com.linkedin.common.urn.DatasetUrn\"},{\"doc\":\"Dataset field path\",\"maxLength\":500,\"name\":\"fieldPath\",\"type\":\"string\"}],\"maxLength\":807,\"name\":\"DatasetField\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetFieldUrn=string}]]", SchemaFormatType.PDL);

    public DatasetFieldUpstreamArray() {
        this(new DataList());
    }

    public DatasetFieldUpstreamArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public DatasetFieldUpstreamArray(Collection<DatasetFieldUpstream> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public DatasetFieldUpstreamArray(DataList data) {
        super(data, SCHEMA, DatasetFieldUpstream.class);
    }

    public DatasetFieldUpstreamArray(DatasetFieldUpstream first, DatasetFieldUpstream ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DatasetFieldUpstreamArray clone() throws CloneNotSupportedException {
        DatasetFieldUpstreamArray __clone = (DatasetFieldUpstreamArray)super.clone();
        return __clone;
    }

    @Override
    public DatasetFieldUpstreamArray copy() throws CloneNotSupportedException {
        DatasetFieldUpstreamArray __copy = (DatasetFieldUpstreamArray)super.copy();
        return __copy;
    }

    @Override
    protected DatasetFieldUpstream coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new DatasetFieldUpstream(object);
    }

    public static class ProjectionMask
    extends MaskMap {
        private DatasetFieldUpstream.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<DatasetFieldUpstream.ProjectionMask, DatasetFieldUpstream.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? DatasetFieldUpstream.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DatasetFieldUpstream.Fields items() {
            return new DatasetFieldUpstream.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

