/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataprocess;

import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataProcessInstanceRelationships
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataprocess/**Information about Data process relationships*/@Aspect.name=\"dataProcessInstanceRelationships\"record DataProcessInstanceRelationships{/**The parent entity whose run instance it is*/@Relationship={\"entityTypes\":[\"dataJob\",\"dataFlow\",\"dataset\"],\"name\":\"InstanceOf\"}@Searchable.`/*`={\"fieldName\":\"parentTemplate\",\"fieldType\":\"URN\",\"queryByDefault\":false}parentTemplate:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The parent DataProcessInstance where it belongs to.\nIf it is a Airflow Task then it should belong to an Airflow Dag run as well\nwhich will be another DataProcessInstance*/@Relationship={\"entityTypes\":[\"dataProcessInstance\"],\"name\":\"ChildOf\"}@Searchable.`/*`={\"fieldName\":\"parentInstance\",\"fieldType\":\"URN\",\"queryByDefault\":false}parentInstance:optional com.linkedin.common.Urn/**Input DataProcessInstance which triggered this dataprocess instance*/@Relationship.`/*`={\"entityTypes\":[\"dataProcessInstance\"],\"name\":\"UpstreamOf\"}@Searchable.`/*`={\"fieldName\":\"upstream\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numUpstreams\",\"queryByDefault\":false}upstreamInstances:array[com.linkedin.common.Urn]}", SchemaFormatType.PDL);
    private Urn _parentTemplateField = null;
    private Urn _parentInstanceField = null;
    private UrnArray _upstreamInstancesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ParentTemplate = SCHEMA.getField("parentTemplate");
    private static final RecordDataSchema.Field FIELD_ParentInstance = SCHEMA.getField("parentInstance");
    private static final RecordDataSchema.Field FIELD_UpstreamInstances = SCHEMA.getField("upstreamInstances");

    public DataProcessInstanceRelationships() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataProcessInstanceRelationships(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasParentTemplate() {
        if (this._parentTemplateField != null) {
            return true;
        }
        return this._map.containsKey("parentTemplate");
    }

    public void removeParentTemplate() {
        this._map.remove("parentTemplate");
    }

    @Nullable
    public Urn getParentTemplate(GetMode mode) {
        return this.getParentTemplate();
    }

    @Nullable
    public Urn getParentTemplate() {
        if (this._parentTemplateField != null) {
            return this._parentTemplateField;
        }
        Object __rawValue = this._map.get("parentTemplate");
        this._parentTemplateField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._parentTemplateField;
    }

    public DataProcessInstanceRelationships setParentTemplate(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParentTemplate(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParentTemplate();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parentTemplate", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._parentTemplateField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parentTemplate", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._parentTemplateField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRelationships setParentTemplate(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parentTemplate of com.linkedin.dataprocess.DataProcessInstanceRelationships to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parentTemplate", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._parentTemplateField = value;
        return this;
    }

    public boolean hasParentInstance() {
        if (this._parentInstanceField != null) {
            return true;
        }
        return this._map.containsKey("parentInstance");
    }

    public void removeParentInstance() {
        this._map.remove("parentInstance");
    }

    @Nullable
    public Urn getParentInstance(GetMode mode) {
        return this.getParentInstance();
    }

    @Nullable
    public Urn getParentInstance() {
        if (this._parentInstanceField != null) {
            return this._parentInstanceField;
        }
        Object __rawValue = this._map.get("parentInstance");
        this._parentInstanceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._parentInstanceField;
    }

    public DataProcessInstanceRelationships setParentInstance(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParentInstance(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParentInstance();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parentInstance", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._parentInstanceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parentInstance", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._parentInstanceField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRelationships setParentInstance(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parentInstance of com.linkedin.dataprocess.DataProcessInstanceRelationships to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parentInstance", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._parentInstanceField = value;
        return this;
    }

    public boolean hasUpstreamInstances() {
        if (this._upstreamInstancesField != null) {
            return true;
        }
        return this._map.containsKey("upstreamInstances");
    }

    public void removeUpstreamInstances() {
        this._map.remove("upstreamInstances");
    }

    @Nullable
    public UrnArray getUpstreamInstances(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUpstreamInstances();
            }
            case DEFAULT: 
            case NULL: {
                if (this._upstreamInstancesField != null) {
                    return this._upstreamInstancesField;
                }
                Object __rawValue = this._map.get("upstreamInstances");
                this._upstreamInstancesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._upstreamInstancesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getUpstreamInstances() {
        if (this._upstreamInstancesField != null) {
            return this._upstreamInstancesField;
        }
        Object __rawValue = this._map.get("upstreamInstances");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("upstreamInstances");
        }
        this._upstreamInstancesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._upstreamInstancesField;
    }

    public DataProcessInstanceRelationships setUpstreamInstances(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUpstreamInstances(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field upstreamInstances of com.linkedin.dataprocess.DataProcessInstanceRelationships");
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreamInstances", value.data());
                this._upstreamInstancesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUpstreamInstances();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "upstreamInstances", value.data());
                this._upstreamInstancesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "upstreamInstances", value.data());
                this._upstreamInstancesField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceRelationships setUpstreamInstances(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field upstreamInstances of com.linkedin.dataprocess.DataProcessInstanceRelationships to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "upstreamInstances", value.data());
        this._upstreamInstancesField = value;
        return this;
    }

    @Override
    public DataProcessInstanceRelationships clone() throws CloneNotSupportedException {
        DataProcessInstanceRelationships __clone = (DataProcessInstanceRelationships)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataProcessInstanceRelationships copy() throws CloneNotSupportedException {
        DataProcessInstanceRelationships __copy = (DataProcessInstanceRelationships)super.copy();
        __copy._parentInstanceField = null;
        __copy._parentTemplateField = null;
        __copy._upstreamInstancesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataProcessInstanceRelationships __objectRef;

        private ChangeListener(DataProcessInstanceRelationships reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "parentInstance": {
                    this.__objectRef._parentInstanceField = null;
                    break;
                }
                case "parentTemplate": {
                    this.__objectRef._parentTemplateField = null;
                    break;
                }
                case "upstreamInstances": {
                    this.__objectRef._upstreamInstancesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec parentTemplate() {
            return new PathSpec(this.getPathComponents(), "parentTemplate");
        }

        public PathSpec parentInstance() {
            return new PathSpec(this.getPathComponents(), "parentInstance");
        }

        public PathSpec upstreamInstances() {
            return new PathSpec(this.getPathComponents(), "upstreamInstances");
        }

        public PathSpec upstreamInstances(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "upstreamInstances");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withParentTemplate() {
            this.getDataMap().put("parentTemplate", 1);
            return this;
        }

        public ProjectionMask withParentInstance() {
            this.getDataMap().put("parentInstance", 1);
            return this;
        }

        public ProjectionMask withUpstreamInstances() {
            this.getDataMap().put("upstreamInstances", 1);
            return this;
        }

        public ProjectionMask withUpstreamInstances(Integer start, Integer count) {
            this.getDataMap().put("upstreamInstances", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("upstreamInstances").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("upstreamInstances").put("$count", count);
            }
            return this;
        }
    }
}

