/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataprocess;

import com.linkedin.common.EdgeArray;
import com.linkedin.common.UrnArray;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataProcessInstanceInput
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataprocess/**Information about the inputs datasets of a Data process*/@Aspect.name=\"dataProcessInstanceInput\"record DataProcessInstanceInput{/**Input assets consumed*/@Relationship.`/*`={\"entityTypes\":[\"dataset\",\"mlModel\"],\"name\":\"Consumes\"}@Searchable.`/*`={\"addToFilters\":true,\"fieldName\":\"inputs\",\"fieldType\":\"URN\",\"numValuesFieldName\":\"numInputs\",\"queryByDefault\":false}inputs:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Input assets consumed by the data process instance, with additional metadata.\nCounts as lineage.\nWill eventually deprecate the inputs field.*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputEdges/*/created/actor\",\"createdOn\":\"inputEdges/*/created/time\",\"entityTypes\":[\"dataset\",\"mlModel\",\"dataProcessInstance\"],\"isLineage\":true,\"name\":\"DataProcessInstanceConsumes\",\"properties\":\"inputEdges/*/properties\",\"updatedActor\":\"inputEdges/*/lastModified/actor\",\"updatedOn\":\"inputEdges/*/lastModified/time\"}inputEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional Urn/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]}", SchemaFormatType.PDL);
    private UrnArray _inputsField = null;
    private EdgeArray _inputEdgesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Inputs = SCHEMA.getField("inputs");
    private static final RecordDataSchema.Field FIELD_InputEdges = SCHEMA.getField("inputEdges");

    public DataProcessInstanceInput() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public DataProcessInstanceInput(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasInputs() {
        if (this._inputsField != null) {
            return true;
        }
        return this._map.containsKey("inputs");
    }

    public void removeInputs() {
        this._map.remove("inputs");
    }

    @Nullable
    public UrnArray getInputs(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getInputs();
            }
            case DEFAULT: 
            case NULL: {
                if (this._inputsField != null) {
                    return this._inputsField;
                }
                Object __rawValue = this._map.get("inputs");
                this._inputsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._inputsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getInputs() {
        if (this._inputsField != null) {
            return this._inputsField;
        }
        Object __rawValue = this._map.get("inputs");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("inputs");
        }
        this._inputsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputsField;
    }

    public DataProcessInstanceInput setInputs(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field inputs of com.linkedin.dataprocess.DataProcessInstanceInput");
                }
                CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
                this._inputsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
                this._inputsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
                this._inputsField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceInput setInputs(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputs of com.linkedin.dataprocess.DataProcessInstanceInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
        this._inputsField = value;
        return this;
    }

    public boolean hasInputEdges() {
        if (this._inputEdgesField != null) {
            return true;
        }
        return this._map.containsKey("inputEdges");
    }

    public void removeInputEdges() {
        this._map.remove("inputEdges");
    }

    @Nullable
    public EdgeArray getInputEdges(GetMode mode) {
        return this.getInputEdges();
    }

    @Nullable
    public EdgeArray getInputEdges() {
        if (this._inputEdgesField != null) {
            return this._inputEdgesField;
        }
        Object __rawValue = this._map.get("inputEdges");
        this._inputEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputEdgesField;
    }

    public DataProcessInstanceInput setInputEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputEdges", value.data());
                this._inputEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputEdges", value.data());
                this._inputEdgesField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceInput setInputEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputEdges of com.linkedin.dataprocess.DataProcessInstanceInput to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputEdges", value.data());
        this._inputEdgesField = value;
        return this;
    }

    @Override
    public DataProcessInstanceInput clone() throws CloneNotSupportedException {
        DataProcessInstanceInput __clone = (DataProcessInstanceInput)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataProcessInstanceInput copy() throws CloneNotSupportedException {
        DataProcessInstanceInput __copy = (DataProcessInstanceInput)super.copy();
        __copy._inputsField = null;
        __copy._inputEdgesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataProcessInstanceInput __objectRef;

        private ChangeListener(DataProcessInstanceInput reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "inputs": {
                    this.__objectRef._inputsField = null;
                    break;
                }
                case "inputEdges": {
                    this.__objectRef._inputEdgesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec inputs() {
            return new PathSpec(this.getPathComponents(), "inputs");
        }

        public PathSpec inputs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields inputEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "inputEdges");
        }

        public PathSpec inputEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private EdgeArray.ProjectionMask _inputEdgesMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withInputs() {
            this.getDataMap().put("inputs", 1);
            return this;
        }

        public ProjectionMask withInputs(Integer start, Integer count) {
            this.getDataMap().put("inputs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._inputEdgesMask = nestedMask.apply(this._inputEdgesMask == null ? EdgeArray.createMask() : this._inputEdgesMask);
            this.getDataMap().put("inputEdges", this._inputEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withInputEdges() {
            this._inputEdgesMask = null;
            this.getDataMap().put("inputEdges", 1);
            return this;
        }

        public ProjectionMask withInputEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._inputEdgesMask = nestedMask.apply(this._inputEdgesMask == null ? EdgeArray.createMask() : this._inputEdgesMask);
            this.getDataMap().put("inputEdges", this._inputEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("inputEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputEdges(Integer start, Integer count) {
            this._inputEdgesMask = null;
            this.getDataMap().put("inputEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputEdges").put("$count", count);
            }
            return this;
        }
    }
}

