/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataplatform;

import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataplatform.PlatformType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataPlatformInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataplatform/**Information about a data platform*/@Aspect.name=\"dataPlatformInfo\"record DataPlatformInfo{/**Name of the data platform*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":false,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}@validate.strlen.max=15,name:string/**The name that will be used for displaying a platform type.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}displayName:optional string/**Platform type this data platform describes*/type:/**Platform types available at LinkedIn*/enum PlatformType{/**Value for a file system, e.g. hdfs*/FILE_SYSTEM/**Value for a key value store, e.g. espresso, voldemort*/KEY_VALUE_STORE/**Value for a message broker, e.g. kafka*/MESSAGE_BROKER/**Value for an object store, e.g. ambry*/OBJECT_STORE/**Value for an OLAP datastore, e.g. pinot*/OLAP_DATASTORE/**Value for other platforms, e.g salesforce, dovetail*/OTHERS/**Value for a query engine, e.g. presto*/QUERY_ENGINE/**Value for a relational database, e.g. oracle, mysql*/RELATIONAL_DB/**Value for a search engine, e.g seas*/SEARCH_ENGINE}/**The delimiter in the dataset names on the data platform, e.g. '/' for HDFS and '.' for Oracle*/datasetNameDelimiter:string/**The URL for a logo associated with the platform*/logoUrl:optional{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}", SchemaFormatType.PDL);
    private String _nameField = null;
    private String _displayNameField = null;
    private PlatformType _typeField = null;
    private String _datasetNameDelimiterField = null;
    private Url _logoUrlField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_DatasetNameDelimiter = SCHEMA.getField("datasetNameDelimiter");
    private static final RecordDataSchema.Field FIELD_LogoUrl = SCHEMA.getField("logoUrl");

    public DataPlatformInfo() {
        super(new DataMap(7, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataPlatformInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DataPlatformInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.dataplatform.DataPlatformInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DataPlatformInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.dataplatform.DataPlatformInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        return this.getDisplayName();
    }

    @Nullable
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public DataPlatformInfo setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public DataPlatformInfo setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.dataplatform.DataPlatformInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public PlatformType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PlatformType.class, PlatformType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public PlatformType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, PlatformType.class, PlatformType.$UNKNOWN);
        return this._typeField;
    }

    public DataPlatformInfo setType(@Nullable PlatformType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.dataplatform.DataPlatformInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public DataPlatformInfo setType(@Nonnull PlatformType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.dataplatform.DataPlatformInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasDatasetNameDelimiter() {
        if (this._datasetNameDelimiterField != null) {
            return true;
        }
        return this._map.containsKey("datasetNameDelimiter");
    }

    public void removeDatasetNameDelimiter() {
        this._map.remove("datasetNameDelimiter");
    }

    @Nullable
    public String getDatasetNameDelimiter(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDatasetNameDelimiter();
            }
            case DEFAULT: 
            case NULL: {
                if (this._datasetNameDelimiterField != null) {
                    return this._datasetNameDelimiterField;
                }
                Object __rawValue = this._map.get("datasetNameDelimiter");
                this._datasetNameDelimiterField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._datasetNameDelimiterField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDatasetNameDelimiter() {
        if (this._datasetNameDelimiterField != null) {
            return this._datasetNameDelimiterField;
        }
        Object __rawValue = this._map.get("datasetNameDelimiter");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("datasetNameDelimiter");
        }
        this._datasetNameDelimiterField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._datasetNameDelimiterField;
    }

    public DataPlatformInfo setDatasetNameDelimiter(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDatasetNameDelimiter(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field datasetNameDelimiter of com.linkedin.dataplatform.DataPlatformInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "datasetNameDelimiter", value);
                this._datasetNameDelimiterField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDatasetNameDelimiter();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "datasetNameDelimiter", value);
                this._datasetNameDelimiterField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "datasetNameDelimiter", value);
                this._datasetNameDelimiterField = value;
            }
        }
        return this;
    }

    public DataPlatformInfo setDatasetNameDelimiter(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field datasetNameDelimiter of com.linkedin.dataplatform.DataPlatformInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "datasetNameDelimiter", value);
        this._datasetNameDelimiterField = value;
        return this;
    }

    public boolean hasLogoUrl() {
        if (this._logoUrlField != null) {
            return true;
        }
        return this._map.containsKey("logoUrl");
    }

    public void removeLogoUrl() {
        this._map.remove("logoUrl");
    }

    @Nullable
    public Url getLogoUrl(GetMode mode) {
        return this.getLogoUrl();
    }

    @Nullable
    public Url getLogoUrl() {
        if (this._logoUrlField != null) {
            return this._logoUrlField;
        }
        Object __rawValue = this._map.get("logoUrl");
        this._logoUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._logoUrlField;
    }

    public DataPlatformInfo setLogoUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLogoUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLogoUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "logoUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._logoUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "logoUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._logoUrlField = value;
            }
        }
        return this;
    }

    public DataPlatformInfo setLogoUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field logoUrl of com.linkedin.dataplatform.DataPlatformInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "logoUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._logoUrlField = value;
        return this;
    }

    @Override
    public DataPlatformInfo clone() throws CloneNotSupportedException {
        DataPlatformInfo __clone = (DataPlatformInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataPlatformInfo copy() throws CloneNotSupportedException {
        DataPlatformInfo __copy = (DataPlatformInfo)super.copy();
        __copy._displayNameField = null;
        __copy._nameField = null;
        __copy._datasetNameDelimiterField = null;
        __copy._typeField = null;
        __copy._logoUrlField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataPlatformInfo __objectRef;

        private ChangeListener(DataPlatformInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "datasetNameDelimiter": {
                    this.__objectRef._datasetNameDelimiterField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "logoUrl": {
                    this.__objectRef._logoUrlField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec datasetNameDelimiter() {
            return new PathSpec(this.getPathComponents(), "datasetNameDelimiter");
        }

        public PathSpec logoUrl() {
            return new PathSpec(this.getPathComponents(), "logoUrl");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withDatasetNameDelimiter() {
            this.getDataMap().put("datasetNameDelimiter", 1);
            return this;
        }

        public ProjectionMask withLogoUrl() {
            this.getDataMap().put("logoUrl", 1);
            return this;
        }
    }
}

