/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Arrays;
import java.util.Collection;

public final class LongArray
extends DirectArrayTemplate<Long> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"array\", \"items\" : \"long\" }");

    public LongArray() {
        this(new DataList());
    }

    public LongArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public LongArray(Collection<Long> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public LongArray(DataList list) {
        super(list, SCHEMA, Long.class, Long.class);
    }

    public LongArray(Long first, Long ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    @Override
    public LongArray clone() throws CloneNotSupportedException {
        return (LongArray)super.clone();
    }

    @Override
    public LongArray copy() throws CloneNotSupportedException {
        return (LongArray)super.copy();
    }

    @Override
    protected Object coerceInput(Long object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return DataTemplateUtil.coerceLongInput(object);
    }

    @Override
    protected Long coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return DataTemplateUtil.coerceLongOutput(object);
    }
}

