/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectMapTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Map;

public final class IntegerMap
extends DirectMapTemplate<Integer> {
    private static final MapDataSchema SCHEMA = (MapDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"map\", \"values\" : \"int\" }");

    public IntegerMap() {
        this(new DataMap());
    }

    public IntegerMap(int initialCapacity) {
        this(new DataMap(initialCapacity));
    }

    public IntegerMap(int initialCapacity, float loadFactor) {
        this(new DataMap(initialCapacity, loadFactor));
    }

    public IntegerMap(Map<String, Integer> m4) {
        this(IntegerMap.newDataMapOfSize(m4.size()));
        this.putAll(m4);
    }

    public IntegerMap(DataMap map) {
        super(map, SCHEMA, Integer.class, Integer.class);
    }

    @Override
    public IntegerMap clone() throws CloneNotSupportedException {
        return (IntegerMap)super.clone();
    }

    @Override
    public IntegerMap copy() throws CloneNotSupportedException {
        return (IntegerMap)super.copy();
    }

    @Override
    protected Object coerceInput(Integer object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return DataTemplateUtil.coerceIntInput(object);
    }

    @Override
    protected Integer coerceOutput(Object object) throws TemplateOutputCastException {
        return DataTemplateUtil.coerceIntOutput(object);
    }
}

