/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.annotation;

import com.linkedin.data.message.Message;
import com.linkedin.data.message.MessageList;
import com.linkedin.data.message.MessageUtil;
import com.linkedin.data.schema.DataSchema;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SchemaVisitorTraversalResult {
    boolean _isTraversalSuccessful = true;
    MessageList<Message> _messages = new MessageList();
    StringBuilder _messageBuilder = new StringBuilder();
    DataSchema _constructedSchema = null;

    public DataSchema getConstructedSchema() {
        return this._constructedSchema;
    }

    public void setConstructedSchema(DataSchema constructedSchema) {
        this._constructedSchema = constructedSchema;
    }

    public boolean isTraversalSuccessful() {
        return this._isTraversalSuccessful;
    }

    private void setTraversalSuccessful(boolean traversalSuccessful) {
        this._isTraversalSuccessful = traversalSuccessful;
    }

    public Collection<Message> getMessages() {
        return this._messages;
    }

    public void setMessages(MessageList<Message> messages) {
        this._messages = messages;
        if (messages != null && messages.size() > 0) {
            this.setTraversalSuccessful(false);
        }
    }

    public void addMessage(Message message) {
        this._messages.add(message);
        MessageUtil.appendMessages(this.getMessageBuilder(), Arrays.asList(message));
        this.setTraversalSuccessful(false);
    }

    public void addMessage(List<String> path, String format, Object ... args) {
        Message msg = new Message(path.toArray(), format, args);
        this.addMessage(msg);
    }

    public void addMessages(List<String> path, Collection<? extends Message> messages) {
        List msgs = messages.stream().map(msg -> new Message(path.toArray(), msg.toString(), new Object[0])).collect(Collectors.toList());
        this._messages.addAll(msgs);
        MessageUtil.appendMessages(this.getMessageBuilder(), msgs);
        this.setTraversalSuccessful(false);
    }

    public StringBuilder getMessageBuilder() {
        return this._messageBuilder;
    }

    public String formatToErrorMessage() {
        return this.getMessageBuilder().toString();
    }
}

