/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.protobuf;

import com.linkedin.data.protobuf.TextBuffer;
import java.io.IOException;

public class Utf8Utils {
    private static final char DEFAULT_REPLACEMENT_CHAR = '?';
    private static final int[] UTF8_LOOKUP_TABLE;

    public static int lookupUtfTable(int initialByte) {
        return UTF8_LOOKUP_TABLE[initialByte];
    }

    public static int encode(CharSequence in, byte[] out, int offset, int length) {
        return Utf8Utils.encode(in, out, offset, length, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int encode(CharSequence in, byte[] out, int offset, int length, boolean tolerateInvalidSurrogatePairs) {
        char c;
        int i;
        int utf16Length = in.length();
        int j = offset;
        int limit = offset + length;
        for (i = 0; i < utf16Length && i + j < limit && (c = in.charAt(i)) < '\u0080'; ++i) {
            out[j + i] = (byte)c;
        }
        if (i == utf16Length) {
            return j + utf16Length;
        }
        j += i;
        while (i < utf16Length) {
            c = in.charAt(i);
            if (c < '\u0080' && j < limit) {
                out[j++] = (byte)c;
            } else if (c < '\u0800' && j <= limit - 2) {
                out[j++] = (byte)(0x3C0 | c >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && j <= limit - 3) {
                out[j++] = (byte)(0x1E0 | c >>> 12);
                out[j++] = (byte)(0x80 | 0x3F & c >>> 6);
                out[j++] = (byte)(0x80 | 0x3F & c);
            } else if (j <= limit - 4) {
                char low;
                if (i + 1 == in.length() || !Character.isSurrogatePair(c, low = in.charAt(i + 1))) {
                    if (!tolerateInvalidSurrogatePairs) throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1) + " of " + utf16Length);
                    out[j++] = 63;
                } else {
                    ++i;
                    int codePoint = Character.toCodePoint(c, low);
                    out[j++] = (byte)(0xF0 | codePoint >>> 18);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 12);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint >>> 6);
                    out[j++] = (byte)(0x80 | 0x3F & codePoint);
                }
            } else {
                if (!Character.isSurrogate(c) || i + 1 != in.length() && Character.isSurrogatePair(c, in.charAt(i + 1))) throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + j);
                if (!tolerateInvalidSurrogatePairs) throw new IllegalArgumentException("Unpaired surrogate at index " + i + " of " + utf16Length);
                out[j++] = 63;
            }
            ++i;
        }
        return j;
    }

    public static int encodedLength(CharSequence sequence) {
        return Utf8Utils.encodedLength(sequence, false);
    }

    public static int encodedLength(CharSequence sequence, boolean tolerateInvalidSurrogatePairs) {
        int i;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (i = 0; i < utf16Length && sequence.charAt(i) < '\u0080'; ++i) {
        }
        while (i < utf16Length) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
            } else {
                utf8Length += Utf8Utils.encodedLengthGeneral(sequence, i, tolerateInvalidSurrogatePairs);
                break;
            }
            ++i;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start, boolean tolerateInvalidSurrogatePairs) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int i = start; i < utf16Length; ++i) {
            char c = sequence.charAt(i);
            if (c < '\u0800') {
                utf8Length += 127 - c >>> 31;
                continue;
            }
            utf8Length += 2;
            if (!Character.isSurrogate(c)) continue;
            int cp = Character.codePointAt(sequence, i);
            if (cp < 65536) {
                if (tolerateInvalidSurrogatePairs) {
                    utf8Length -= 2;
                } else {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + i + " of " + utf16Length);
                }
            }
            ++i;
        }
        return utf8Length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeASCII(byte[] bytes, int index, int size, TextBuffer textBuffer) {
        int offset = index;
        int limit = offset + size;
        char[] resultArr = null;
        try {
            resultArr = textBuffer.getBuf(size);
            int resultPos = 0;
            while (offset < limit) {
                resultArr[resultPos++] = (char)bytes[offset++];
            }
            String string = new String(resultArr, 0, size);
            return string;
        }
        finally {
            textBuffer.returnBuf(resultArr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeLongASCII(LongDecoderState state, int size, TextBuffer textBuffer) throws IOException {
        char[] resultArr = null;
        try {
            resultArr = textBuffer.getBuf(size);
            int resultPos = 0;
            byte[] buffer = state._buffer;
            int position = state._position;
            int limit = state._offset + state._bufferSize;
            while (resultPos < size) {
                if (position >= limit) {
                    state.readNextChunk();
                    buffer = state._buffer;
                    position = state._position;
                    limit = state._offset + state._bufferSize;
                }
                while (position < limit && resultPos < size) {
                    resultArr[resultPos++] = (char)buffer[position++];
                }
            }
            state._position = position;
            String string = new String(resultArr, 0, resultPos);
            return string;
        }
        finally {
            textBuffer.returnBuf(resultArr);
        }
    }

    @Deprecated
    public static String decode(byte[] bytes, int index, int size) {
        return Utf8Utils.decode(bytes, index, size, new TextBuffer(1024));
    }

    public static String decode(byte[] bytes, int index, int size, TextBuffer textBuffer) {
        int offset = index;
        int limit = offset + size;
        char[] resultArr = null;
        try {
            resultArr = textBuffer.getBuf(size);
            int resultPos = 0;
            while (offset < limit) {
                int i = bytes[offset++] & 0xFF;
                switch (UTF8_LOOKUP_TABLE[i]) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        i = (i & 0x1F) << 6 | bytes[offset++] & 0x3F;
                        break;
                    }
                    case 3: {
                        i = (i & 0xF) << 12 | (bytes[offset++] & 0x3F) << 6 | bytes[offset++] & 0x3F;
                        break;
                    }
                    case 4: {
                        i = (i & 7) << 18 | (bytes[offset++] & 0x3F) << 12 | (bytes[offset++] & 0x3F) << 6 | bytes[offset++] & 0x3F;
                        resultArr[resultPos++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid UTF-8. UTF-8 character cannot be " + UTF8_LOOKUP_TABLE[i] + "bytes");
                    }
                }
                resultArr[resultPos++] = (char)i;
            }
            String string = new String(resultArr, 0, resultPos);
            return string;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid UTF-8. Unterminated multi-byte sequence", e);
        }
        finally {
            textBuffer.returnBuf(resultArr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeLong(LongDecoderState state, int size, TextBuffer textBuffer) throws IOException {
        char[] resultArr = null;
        try {
            resultArr = textBuffer.getBuf(size);
            int resultPos = 0;
            byte[] buffer = state._buffer;
            int position = state._position;
            int limit = state._offset + state._bufferSize;
            int totalBytesRead = 0;
            while (totalBytesRead < size) {
                if (position >= limit) {
                    state.readNextChunk();
                    buffer = state._buffer;
                    position = state._position;
                    limit = state._offset + state._bufferSize;
                }
                int i = buffer[position++] & 0xFF;
                switch (UTF8_LOOKUP_TABLE[i]) {
                    case 0: {
                        ++totalBytesRead;
                        break;
                    }
                    case 2: {
                        if (position >= limit) {
                            state.readNextChunk();
                            buffer = state._buffer;
                            position = state._position;
                            limit = state._offset + state._bufferSize;
                        }
                        i = (i & 0x1F) << 6 | buffer[position++] & 0x3F;
                        totalBytesRead += 2;
                        break;
                    }
                    case 3: {
                        byte byte3;
                        byte byte2;
                        if (position < limit - 1) {
                            i = (i & 0xF) << 12 | (buffer[position++] & 0x3F) << 6 | buffer[position++] & 0x3F;
                        } else {
                            if (position >= limit) {
                                state.readNextChunk();
                                buffer = state._buffer;
                                position = state._position;
                                limit = state._offset + state._bufferSize;
                            }
                            byte2 = buffer[position++];
                            if (position >= limit) {
                                state.readNextChunk();
                                buffer = state._buffer;
                                position = state._position;
                                limit = state._offset + state._bufferSize;
                            }
                            byte3 = buffer[position++];
                            i = (i & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F;
                        }
                        totalBytesRead += 3;
                        break;
                    }
                    case 4: {
                        byte byte3;
                        byte byte2;
                        if (position < limit - 2) {
                            i = (i & 7) << 18 | (buffer[position++] & 0x3F) << 12 | (buffer[position++] & 0x3F) << 6 | buffer[position++] & 0x3F;
                        } else {
                            if (position >= limit) {
                                state.readNextChunk();
                                buffer = state._buffer;
                                position = state._position;
                                limit = state._offset + state._bufferSize;
                            }
                            byte2 = buffer[position++];
                            if (position >= limit) {
                                state.readNextChunk();
                                buffer = state._buffer;
                                position = state._position;
                                limit = state._offset + state._bufferSize;
                            }
                            byte3 = buffer[position++];
                            if (position >= limit) {
                                state.readNextChunk();
                                buffer = state._buffer;
                                position = state._position;
                                limit = state._offset + state._bufferSize;
                            }
                            byte byte4 = buffer[position++];
                            i = (i & 7) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
                        }
                        resultArr[resultPos++] = (char)(0xD800 | (i -= 65536) >> 10);
                        i = 0xDC00 | i & 0x3FF;
                        totalBytesRead += 4;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid UTF-8. UTF-8 character cannot be " + UTF8_LOOKUP_TABLE[i] + "bytes");
                    }
                }
                resultArr[resultPos++] = (char)i;
            }
            state._position = position;
            String string = new String(resultArr, 0, resultPos);
            return string;
        }
        finally {
            textBuffer.returnBuf(resultArr);
        }
    }

    static {
        int[] table = new int[256];
        for (int c = 128; c < 256; ++c) {
            int code = (c & 0xE0) == 192 ? 2 : ((c & 0xF0) == 224 ? 3 : ((c & 0xF8) == 240 ? 4 : -1));
            table[c] = code;
        }
        UTF8_LOOKUP_TABLE = table;
    }

    public static abstract class LongDecoderState {
        protected byte[] _buffer;
        protected int _offset;
        protected int _position;
        protected int _bufferSize;

        public abstract void readNextChunk() throws IOException;

        public byte[] getBuffer() {
            return this._buffer;
        }

        public int getOffset() {
            return this._offset;
        }

        public int getPosition() {
            return this._position;
        }

        public int getBufferSize() {
            return this._bufferSize;
        }
    }
}

