/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.protobuf;

import com.linkedin.data.protobuf.Utf8Utils;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;

public class ProtoWriter
implements Closeable {
    public static final int FIXED32_SIZE = 4;
    public static final int FIXED64_SIZE = 8;
    private static final int MAX_VARINT32_SIZE = 5;
    private static final int MAX_VARINT64_SIZE = 10;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final OutputStream _out;
    private final byte[] _buffer;
    private final int _limit;
    private int _position;

    public ProtoWriter(OutputStream out) {
        this(out, 4096);
    }

    public ProtoWriter(OutputStream out, int bufferSize) {
        this._out = out;
        this._buffer = new byte[bufferSize];
        this._limit = bufferSize;
    }

    public void writeByte(byte value) throws IOException {
        if (this._position == this._limit) {
            this.flush();
        }
        this.buffer(value);
    }

    public void writeBytes(byte[] value) throws IOException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws IOException {
        if (this._limit - this._position >= length) {
            System.arraycopy(value, offset, this._buffer, this._position, length);
            this._position += length;
        } else {
            int bytesWritten = this._limit - this._position;
            System.arraycopy(value, offset, this._buffer, this._position, bytesWritten);
            offset += bytesWritten;
            this._position = this._limit;
            this.flush();
            if ((length -= bytesWritten) <= this._limit) {
                System.arraycopy(value, offset, this._buffer, 0, length);
                this._position = length;
            } else {
                this._out.write(value, offset, length);
            }
        }
    }

    public final void writeFixedInt32(int value) throws IOException {
        this.flushIfNotAvailable(4);
        this._buffer[this._position++] = (byte)(value & 0xFF);
        this._buffer[this._position++] = (byte)(value >> 8 & 0xFF);
        this._buffer[this._position++] = (byte)(value >> 16 & 0xFF);
        this._buffer[this._position++] = (byte)(value >> 24 & 0xFF);
    }

    public final void writeInt32(int value) throws IOException {
        if (value >= 0) {
            this.writeUInt32(value);
        } else {
            this.writeUInt64(value);
        }
    }

    public final void writeFixedInt64(long value) throws IOException {
        this.flushIfNotAvailable(8);
        this._buffer[this._position++] = (byte)((int)value & 0xFF);
        this._buffer[this._position++] = (byte)((int)(value >> 8) & 0xFF);
        this._buffer[this._position++] = (byte)((int)(value >> 16) & 0xFF);
        this._buffer[this._position++] = (byte)((int)(value >> 24) & 0xFF);
        this._buffer[this._position++] = (byte)((int)(value >> 32) & 0xFF);
        this._buffer[this._position++] = (byte)((int)(value >> 40) & 0xFF);
        this._buffer[this._position++] = (byte)((int)(value >> 48) & 0xFF);
        this._buffer[this._position++] = (byte)((int)(value >> 56) & 0xFF);
    }

    public final void writeInt64(long value) throws IOException {
        this.writeUInt64(value);
    }

    private static int computeUInt32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private void buffer(byte value) throws IOException {
        this._buffer[this._position++] = value;
    }

    public void flush() throws IOException {
        this._out.write(this._buffer, 0, this._position);
        this._position = 0;
    }

    private void flushIfNotAvailable(int requiredSize) throws IOException {
        if (this._limit - this._position < requiredSize) {
            this.flush();
        }
    }

    public void writeUInt32(int value) throws IOException {
        this.flushIfNotAvailable(5);
        this.bufferUInt32(value);
    }

    private void bufferUInt32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this._buffer[this._position++] = (byte)value;
                return;
            }
            this._buffer[this._position++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public void writeUInt64(long value) throws IOException {
        this.flushIfNotAvailable(10);
        this.bufferUInt64(value);
    }

    private void bufferUInt64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this._buffer[this._position++] = (byte)value;
                return;
            }
            this._buffer[this._position++] = (byte)((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public void writeString(String value) throws IOException {
        this.writeString(value, null);
    }

    public void writeString(String value, Function<Integer, Byte> leadingOrdinalGenerator) throws IOException {
        this.writeString(value, leadingOrdinalGenerator, false);
    }

    public void writeString(String value, Function<Integer, Byte> leadingOrdinalGenerator, boolean tolerateInvalidSurrogatePairs) throws IOException {
        int leadingOrdinalLength = leadingOrdinalGenerator == null ? 0 : 1;
        int maxLength = value.length() * 3;
        int maxLengthVarIntSize = ProtoWriter.computeUInt32Size(maxLength);
        if (maxLengthVarIntSize + maxLength + leadingOrdinalLength > this._limit) {
            byte[] encodedBytes = new byte[maxLength];
            int actualLength = Utf8Utils.encode(value, encodedBytes, 0, maxLength, tolerateInvalidSurrogatePairs);
            if (leadingOrdinalGenerator != null) {
                this.writeByte(leadingOrdinalGenerator.apply(actualLength));
            }
            this.writeUInt32(actualLength);
            this.writeBytes(encodedBytes, 0, actualLength);
            return;
        }
        if (maxLengthVarIntSize + maxLength + leadingOrdinalLength > this._limit - this._position) {
            this.flush();
        }
        int oldPosition = this._position;
        try {
            int minLengthVarIntSize = ProtoWriter.computeUInt32Size(value.length());
            if (minLengthVarIntSize == maxLengthVarIntSize) {
                this._position = oldPosition + leadingOrdinalLength + minLengthVarIntSize;
                int newPosition = Utf8Utils.encode(value, this._buffer, this._position, this._limit - this._position, tolerateInvalidSurrogatePairs);
                this._position = oldPosition;
                int length = newPosition - oldPosition - leadingOrdinalLength - minLengthVarIntSize;
                if (leadingOrdinalGenerator != null) {
                    this.buffer(leadingOrdinalGenerator.apply(length));
                }
                this.bufferUInt32(length);
                this._position = newPosition;
            } else {
                int length = Utf8Utils.encodedLength(value, tolerateInvalidSurrogatePairs);
                if (leadingOrdinalGenerator != null) {
                    this.buffer(leadingOrdinalGenerator.apply(length));
                }
                this.bufferUInt32(length);
                this._position = Utf8Utils.encode(value, this._buffer, this._position, length, tolerateInvalidSurrogatePairs);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EOFException(String.format("Pos: %d, limit: %d, len: %d", this._position, this._limit, 1));
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this._out.close();
    }
}

