/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.protobuf;

import com.linkedin.data.protobuf.ProtoReader;
import com.linkedin.data.protobuf.Utf8Utils;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;

final class ByteArrayReader
extends ProtoReader {
    private final byte[] _buffer;
    private int _limit;
    private int _pos;

    ByteArrayReader(byte[] buffer, int offset, int len) {
        this._buffer = buffer;
        this._limit = offset + len;
        this._pos = offset;
    }

    @Override
    public String readASCIIString() throws IOException {
        int size = this.readInt32();
        if (size > 0 && size <= this._limit - this._pos) {
            String result = Utf8Utils.decodeASCII(this._buffer, this._pos, size, this._textBuffer);
            this._pos += size;
            return result;
        }
        if (size == 0) {
            return "";
        }
        throw new EOFException();
    }

    @Override
    public String readString() throws IOException {
        int size = this.readInt32();
        if (size > 0 && size <= this._limit - this._pos) {
            String result = Utf8Utils.decode(this._buffer, this._pos, size, this._textBuffer);
            this._pos += size;
            return result;
        }
        if (size == 0) {
            return "";
        }
        throw new EOFException();
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int length = this.readInt32();
        if (length > 0 && length <= this._limit - this._pos) {
            int tempPos = this._pos;
            this._pos += length;
            return Arrays.copyOfRange(this._buffer, tempPos, this._pos);
        }
        if (length == 0) {
            return new byte[0];
        }
        throw new EOFException();
    }

    @Override
    public int readInt32() throws IOException {
        block4: {
            int x;
            int tempPos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            tempPos = this._pos;
                            if (this._limit == tempPos) break block4;
                            buffer = this._buffer;
                            if ((x = buffer[tempPos++]) >= 0) {
                                this._pos = tempPos;
                                return x;
                            }
                            if (this._limit - tempPos < 9) break block4;
                            if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[tempPos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block4;
            }
            this._pos = tempPos;
            return x;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    @Override
    public long readInt64() throws IOException {
        block4: {
            long x;
            int tempPos;
            block6: {
                byte[] buffer;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int y;
                                block8: {
                                    block7: {
                                        block5: {
                                            tempPos = this._pos;
                                            if (this._limit == tempPos) break block4;
                                            buffer = this._buffer;
                                            if ((y = buffer[tempPos++]) >= 0) {
                                                this._pos = tempPos;
                                                return y;
                                            }
                                            if (this._limit - tempPos < 9) break block4;
                                            if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                            x = y ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((y ^= buffer[tempPos++] << 14) < 0) break block7;
                                        x = y ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((y ^= buffer[tempPos++] << 21) >= 0) break block8;
                                    x = y ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((x = (long)y ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                x ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((x ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((x ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                        x ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((x ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                x ^= (long)buffer[tempPos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[tempPos++] < 0L) break block4;
            }
            this._pos = tempPos;
            return x;
        }
        return this.readRawVarint64SlowPath();
    }

    @Override
    public int readFixedInt32() throws IOException {
        if (this._limit - this._pos < 4) {
            throw new EOFException();
        }
        return this._buffer[this._pos++] & 0xFF | (this._buffer[this._pos++] & 0xFF) << 8 | (this._buffer[this._pos++] & 0xFF) << 16 | (this._buffer[this._pos++] & 0xFF) << 24;
    }

    @Override
    public long readFixedInt64() throws IOException {
        if (this._limit - this._pos < 8) {
            throw new EOFException();
        }
        return (long)this._buffer[this._pos++] & 0xFFL | ((long)this._buffer[this._pos++] & 0xFFL) << 8 | ((long)this._buffer[this._pos++] & 0xFFL) << 16 | ((long)this._buffer[this._pos++] & 0xFFL) << 24 | ((long)this._buffer[this._pos++] & 0xFFL) << 32 | ((long)this._buffer[this._pos++] & 0xFFL) << 40 | ((long)this._buffer[this._pos++] & 0xFFL) << 48 | ((long)this._buffer[this._pos++] & 0xFFL) << 56;
    }

    long readRawVarint64SlowPath() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed VarInt");
    }

    @Override
    public byte readRawByte() throws IOException {
        if (this._pos == this._limit) {
            throw new EOFException();
        }
        return this._buffer[this._pos++];
    }
}

