/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.collections;

import com.linkedin.data.Data;
import com.linkedin.data.collections.CommonMap;
import com.linkedin.data.collections.MapChecker;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class CheckedMap<K, V>
implements CommonMap<K, V>,
Cloneable {
    private boolean _readOnly = false;
    protected MapChecker<K, V> _checker;
    protected WeakListNode<ChangeListener<K, V>> _changeListenerHead;
    private ReferenceQueue<ChangeListener<K, V>> _changeListenerReferenceQueue;
    private HashMap<K, V> _map;

    public CheckedMap() {
        this._checker = null;
        this._map = new HashMap();
    }

    public CheckedMap(Map<? extends K, ? extends V> map) {
        this._checker = null;
        this.checkAll(map);
        this._map = new HashMap<K, V>(map);
    }

    public CheckedMap(int initialCapacity) {
        this._checker = null;
        this._map = new HashMap(initialCapacity);
    }

    public CheckedMap(int initialCapacity, float loadFactor) {
        this._checker = null;
        this._map = new HashMap(initialCapacity, loadFactor);
    }

    public CheckedMap(MapChecker<K, V> checker) {
        this._checker = checker;
        this._map = new HashMap();
    }

    public CheckedMap(Map<? extends K, ? extends V> map, MapChecker<K, V> checker) {
        this._checker = checker;
        this.checkAll(map);
        this._map = new HashMap<K, V>(map);
    }

    public CheckedMap(int initialCapacity, MapChecker<K, V> checker) {
        this._checker = checker;
        this._map = new HashMap(initialCapacity);
    }

    public CheckedMap(int initialCapacity, float loadFactor, MapChecker<K, V> checker) {
        this._checker = checker;
        this._map = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public void clear() {
        this.checkMutability();
        HashSet<K> keys = null;
        if (this._changeListenerHead != null) {
            keys = new HashSet<K>(this.keySet());
        }
        this._map.clear();
        if (keys != null) {
            this.notifyChangeListenersOnClear(keys);
        }
    }

    @Override
    public CheckedMap<K, V> clone() throws CloneNotSupportedException {
        CheckedMap o = (CheckedMap)super.clone();
        o._map = (HashMap)this._map.clone();
        o._readOnly = false;
        o._changeListenerHead = null;
        o._changeListenerReferenceQueue = null;
        return o;
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableMap(this._map).entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this._map.equals(object);
    }

    @Override
    public V get(Object key) {
        return this._map.get(key);
    }

    @Override
    public int hashCode() {
        return this._map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this._map.keySet());
    }

    @Override
    public V put(K key, V value) {
        this.checkKeyValue(key, value);
        this.checkMutability();
        V oldValue = this._map.put(key, value);
        this.notifyChangeListenersOnPut(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        this.checkAll(m4);
        this.checkMutability();
        this._map.putAll(m4);
        this.notifyChangeListenersOnPutAll(m4);
    }

    @Override
    public V remove(Object key) {
        this.checkMutability();
        V oldValue = this._map.remove(key);
        if (oldValue != null && oldValue != Data.NULL) {
            this.notifyChangeListenersOnPut(key, null);
        }
        return oldValue;
    }

    public String toString() {
        return this._map.toString();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this._map.forEach(action);
    }

    public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter) {
        this.checkMutability();
        return this._map.entrySet().removeIf(filter);
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this._map.values());
    }

    @Override
    public boolean isReadOnly() {
        return this._readOnly;
    }

    @Override
    public void setReadOnly() {
        this._readOnly = true;
    }

    @Override
    public void invalidate() {
        this._map = null;
    }

    private final void checkMutability() {
        if (this._readOnly) {
            throw new UnsupportedOperationException("Cannot mutate a read-only map");
        }
    }

    public final void addChangeListener(ChangeListener<K, V> listener) {
        if (this._readOnly) {
            return;
        }
        if (this._changeListenerReferenceQueue == null) {
            this._changeListenerReferenceQueue = new ReferenceQueue();
        } else {
            this.purgeStaleChangeListeners();
        }
        this._changeListenerHead = new WeakListNode<ChangeListener<K, V>>(new WeakReference<ChangeListener<K, V>>(listener, this._changeListenerReferenceQueue), this._changeListenerHead);
    }

    private final void checkKeyValue(K key, V value) {
        if (this._checker != null) {
            this._checker.checkKeyValue(this, key, value);
        }
    }

    private final void checkAll(Map<? extends K, ? extends V> m4) {
        if (this._checker != null) {
            for (Map.Entry<K, V> e : m4.entrySet()) {
                this._checker.checkKeyValue(this, e.getKey(), e.getValue());
            }
        }
    }

    protected V putWithoutChecking(K key, V value) {
        this.checkMutability();
        V oldValue = this._map.put(key, value);
        this.notifyChangeListenersOnPut(key, value);
        return oldValue;
    }

    V putWithAssertedChecking(K key, V value) {
        assert (this.assertCheckKeyValue(key, value)) : "Check is failed";
        return this.putWithoutChecking(key, value);
    }

    V putWithoutCheckingOrChangeNotification(K key, V value) {
        this.checkMutability();
        assert (this.assertCheckKeyValue(key, value)) : "Check is failed";
        return this._map.put(key, value);
    }

    protected void putAllWithoutChecking(Map<? extends K, ? extends V> src) {
        this.checkMutability();
        this._map.putAll(src);
        this.notifyChangeListenersOnPutAll(src);
    }

    void putAllWithAssertedChecking(Map<? extends K, ? extends V> src) {
        assert (this.assertCheckMap(src)) : "Check is failed";
        this.putAllWithoutChecking(src);
    }

    protected final Map<K, V> getObject() {
        return this._map;
    }

    private boolean assertCheckKeyValue(K key, V value) {
        try {
            this.checkKeyValue(key, value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean assertCheckMap(Map<? extends K, ? extends V> map) {
        try {
            this.checkAll(map);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private void notifyChangeListenersOnPut(K key, V value) {
        this.purgeStaleChangeListeners();
        if (this._changeListenerHead == null) {
            return;
        }
        this.forEachChangeListener(listener -> listener.onUnderlyingMapChanged(key, value));
    }

    private void notifyChangeListenersOnPutAll(Map<? extends K, ? extends V> map) {
        this.purgeStaleChangeListeners();
        if (this._changeListenerHead == null) {
            return;
        }
        this.forEachChangeListener(listener -> map.forEach(listener::onUnderlyingMapChanged));
    }

    private void notifyChangeListenersOnClear(Set<? extends K> keys) {
        this.purgeStaleChangeListeners();
        if (this._changeListenerHead == null) {
            return;
        }
        this.forEachChangeListener(listener -> keys.forEach((? super T key) -> listener.onUnderlyingMapChanged(key, null)));
    }

    private void purgeStaleChangeListeners() {
        if (this._changeListenerReferenceQueue != null && this._changeListenerReferenceQueue.poll() != null) {
            while (this._changeListenerReferenceQueue.poll() != null) {
            }
            WeakListNode<ChangeListener<K, V>> node = this._changeListenerHead;
            WeakListNode<ChangeListener<K, V>> prev = null;
            while (node != null) {
                if (node._object.get() == null) {
                    if (prev == null) {
                        this._changeListenerHead = node._next;
                    } else {
                        prev._next = node._next;
                    }
                } else {
                    prev = node;
                }
                node = node._next;
            }
        }
    }

    private void forEachChangeListener(Consumer<ChangeListener<K, V>> listenerConsumer) {
        WeakListNode<ChangeListener<K, V>> node = this._changeListenerHead;
        while (node != null) {
            WeakReference listenerRef = node._object;
            ChangeListener listener = (ChangeListener)listenerRef.get();
            if (listener != null) {
                listenerConsumer.accept(listener);
            }
            node = node._next;
        }
    }

    static class WeakListNode<T> {
        final WeakReference<T> _object;
        WeakListNode<T> _next;

        WeakListNode(WeakReference<T> object, WeakListNode<T> next) {
            this._object = object;
            this._next = next;
        }
    }

    public static interface ChangeListener<K, V> {
        public void onUnderlyingMapChanged(K var1, V var2);
    }
}

