/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.ByteString;
import com.linkedin.data.codec.DataDecodingException;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;

public class BufferChain {
    static final PrintStream out = new PrintStream(new FileOutputStream(FileDescriptor.out));
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final ByteOrder DEFAULT_ORDER = ByteOrder.nativeOrder();
    public static final int DEFAULT_STRING_LENGTH = 128;
    private static final byte ZERO_BYTE = 0;
    private static final int SIZE_BYTE = 1;
    private static final int SIZE_SHORT = 2;
    private static final int SIZE_INT = 4;
    private static final int SIZE_LONG = 8;
    private static final int SIZE_FLOAT = 4;
    private static final int SIZE_DOUBLE = 8;
    private static final int MIN_BUFFER_SIZE = 16;
    private static final Charset _charset = Charset.forName("UTF-8");
    private int _currentIndex;
    private ByteBuffer _currentBuffer;
    private ArrayList<ByteBuffer> _bufferList = new ArrayList();
    private int _bufferSize;
    private ByteOrder _order;
    private CharsetDecoder _decoder;
    private CharsetEncoder _encoder;
    private BufferChainInputStream _inputStream;
    private BufferChainOutputStream _outputStream;

    public BufferChain() {
        this(DEFAULT_ORDER, 8192);
    }

    public BufferChain(ByteOrder order) {
        this(order, 8192);
    }

    public BufferChain(ByteOrder order, int bufferSize) {
        if (bufferSize < 16) {
            throw new IllegalArgumentException("Buffer size must be at least 16");
        }
        this._bufferSize = bufferSize;
        this._order = order;
        this._currentBuffer = this.allocateByteBuffer(this._bufferSize);
        this._currentIndex = 0;
        this.initCoders();
    }

    public BufferChain(byte[] bytes) {
        this(DEFAULT_ORDER, bytes);
    }

    public BufferChain(ByteOrder order, byte[] bytes) {
        this._order = order;
        this._currentBuffer = ByteBuffer.wrap(bytes);
        this._currentBuffer.order(this._order);
        this._currentIndex = 0;
        this._bufferList.add(this._currentBuffer);
        this.initCoders();
    }

    private BufferChain(ByteOrder order, ArrayList<ByteBuffer> byteBuffers, int bufferSize) {
        this._order = order;
        this._currentBuffer = byteBuffers.get(0);
        this._currentIndex = 0;
        this._bufferList = byteBuffers;
        this.initCoders();
    }

    BufferChain(ByteOrder order, byte[] bytes, int bufferSize) {
        int length;
        this._bufferSize = bufferSize;
        this._order = order;
        int offset = 0;
        for (int more = bytes.length; more > 0; more -= length) {
            this._currentBuffer = this.allocateByteBuffer(this._bufferSize);
            this._currentIndex = this._bufferList.size() - 1;
            length = more < this._bufferSize ? more : this._bufferSize;
            this._currentBuffer.put(bytes, offset, length);
            offset += length;
        }
        this.rewind();
        this.initCoders();
    }

    public InputStream asInputStream() {
        if (this._inputStream == null) {
            this._inputStream = new BufferChainInputStream(this);
        }
        return this._inputStream;
    }

    public OutputStream asOutputStream() {
        if (this._outputStream == null) {
            this._outputStream = new BufferChainOutputStream(this);
        }
        return this._outputStream;
    }

    public Position position() {
        return new Position(this, this._currentIndex, this._currentBuffer.position());
    }

    public BufferChain position(Position pos) {
        if (pos._bufferChain != this) {
            throw new IllegalArgumentException("Position does not apply to this BufferChain");
        }
        this._currentIndex = pos._index;
        this._currentBuffer = this._bufferList.get(this._currentIndex);
        if (pos._position == this._currentBuffer.limit() && this._currentIndex < this._bufferList.size() - 1) {
            ++this._currentIndex;
            this._currentBuffer = this._bufferList.get(this._currentIndex);
            ((Buffer)this._currentBuffer).position(0);
        } else {
            ((Buffer)this._currentBuffer).position(pos._position);
        }
        return this;
    }

    public int offset(Position startPos, Position endPos) {
        int sum;
        if (startPos._bufferChain != this || endPos._bufferChain != this) {
            throw new IllegalArgumentException("Position does not apply to this BufferChain");
        }
        if (startPos._index > endPos._index || startPos._index == endPos._index && startPos._position > endPos._position) {
            throw new IllegalArgumentException("Start position is greater than end position");
        }
        if (startPos._index == endPos._index) {
            sum = endPos._position - startPos._position;
        } else {
            int index = startPos._index;
            sum = this._bufferList.get(index).limit() - startPos._position;
            ++index;
            while (index < endPos._index) {
                sum += this._bufferList.get(index).limit();
                ++index;
            }
            sum += endPos._position;
        }
        return sum;
    }

    public ByteOrder order() {
        return this._order;
    }

    public byte get() throws BufferUnderflowException {
        byte res = this.remain(1).get();
        return res;
    }

    public BufferChain get(byte[] dst, int offset, int length) {
        int read = this.read(dst, offset, length);
        if (read < length) {
            throw new BufferUnderflowException();
        }
        return this;
    }

    private int read(byte[] dst, int offset, int length) {
        int more;
        int remaining;
        for (more = length; more > 0 && this.advanceBufferIfCurrentBufferHasNoRemaining(); more -= remaining) {
            remaining = this._currentBuffer.remaining();
            if (remaining > more) {
                remaining = more;
            }
            this._currentBuffer.get(dst, offset, remaining);
            offset += remaining;
        }
        return length - more;
    }

    public ByteBuffer get(int length) {
        ByteBuffer buffer;
        if (!this.advanceBufferIfCurrentBufferHasNoRemaining()) {
            throw new BufferUnderflowException();
        }
        int remaining = this._currentBuffer.remaining();
        if (remaining < length) {
            int more;
            buffer = ByteBuffer.allocate(length);
            byte[] dst = buffer.array();
            int offset = buffer.arrayOffset();
            for (more = length; more > 0 && this.advanceBufferIfCurrentBufferHasNoRemaining(); more -= remaining) {
                this._currentBuffer = this._bufferList.get(this._currentIndex);
                remaining = this._currentBuffer.remaining();
                if (remaining > more) {
                    remaining = more;
                }
                this._currentBuffer.get(dst, offset, remaining);
                offset += remaining;
            }
            if (more > 0) {
                throw new BufferUnderflowException();
            }
        } else {
            buffer = this._currentBuffer.slice();
            ((Buffer)buffer).limit(length);
            ((Buffer)this._currentBuffer).position(this._currentBuffer.position() + length);
        }
        ((Buffer)buffer).flip();
        return buffer;
    }

    public int getVarUnsignedInt() throws BufferUnderflowException {
        byte b;
        int v = 0;
        int shift = 0;
        while (((b = this.get()) & 0xFFFFFF80) == 0) {
            v |= b << shift;
            shift += 7;
        }
        return v |= (b & 0x7F) << shift;
    }

    public int getVarInt() throws BufferUnderflowException {
        int v = this.getVarUnsignedInt();
        int result = v >> 1 ^ -(v & 1);
        return result;
    }

    public short getShort() throws BufferUnderflowException {
        return this.remain(2).getShort();
    }

    public int getInt() throws BufferUnderflowException {
        int res = this.remain(4).getInt();
        return res;
    }

    public long getLong() throws BufferUnderflowException {
        return this.remain(8).getLong();
    }

    public float getFloat() throws BufferUnderflowException {
        return this.remain(4).getFloat();
    }

    public double getDouble() throws BufferUnderflowException {
        return this.remain(8).getDouble();
    }

    public String getUtf8CString() throws IOException {
        ArrayList<ByteBuffer> bufferList = null;
        boolean foundZeroByte = false;
        int numBytes = 0;
        while (!foundZeroByte && this.advanceBufferIfCurrentBufferHasNoRemaining()) {
            int arrayStart;
            int arrayIndex;
            int position = this._currentBuffer.position();
            byte[] array = this._currentBuffer.array();
            int arrayOffset = this._currentBuffer.arrayOffset();
            int limit = this._currentBuffer.limit();
            int arrayLimit = arrayOffset + limit;
            for (arrayIndex = arrayStart = arrayOffset + position; arrayIndex < arrayLimit && array[arrayIndex] != 0; ++arrayIndex) {
            }
            foundZeroByte = arrayIndex < arrayLimit;
            int bytesInCurrentBuffer = arrayIndex - arrayStart;
            if (foundZeroByte && (numBytes += bytesInCurrentBuffer) == bytesInCurrentBuffer) continue;
            bufferList = this.accummulateByteBuffers(bufferList, bytesInCurrentBuffer);
        }
        if (!foundZeroByte) {
            throw new BufferUnderflowException();
        }
        return this.bufferToUtf8CString(numBytes, bufferList);
    }

    public String getUtf8CString(int length) throws IOException {
        if (length == 0) {
            throw new DataDecodingException("Length must be at least 1");
        }
        if (length == 1) {
            byte b = this.get();
            if (b != 0) {
                throw new DataDecodingException("C string not terminated with null");
            }
            return "";
        }
        ArrayList<ByteBuffer> bufferList = null;
        int numBytes = 0;
        int more = length - 1;
        while (more > 0 && this.advanceBufferIfCurrentBufferHasNoRemaining()) {
            int remaining = this._currentBuffer.remaining();
            int bytesInCurrentBuffer = Math.min(remaining, more);
            more -= bytesInCurrentBuffer;
            numBytes += bytesInCurrentBuffer;
            if (length == bytesInCurrentBuffer) continue;
            bufferList = this.accummulateByteBuffers(bufferList, bytesInCurrentBuffer);
        }
        if (numBytes != length - 1) {
            throw new BufferUnderflowException();
        }
        return this.bufferToUtf8CString(numBytes, bufferList);
    }

    private ArrayList<ByteBuffer> accummulateByteBuffers(ArrayList<ByteBuffer> bufferList, int bytesInCurrentBuffer) {
        byte[] array = this._currentBuffer.array();
        int position = this._currentBuffer.position();
        int arrayOffset = this._currentBuffer.arrayOffset();
        int arrayStart = arrayOffset + position;
        int newPosition = position + bytesInCurrentBuffer;
        ByteBuffer byteBuffer = ByteBuffer.wrap(array, arrayStart, bytesInCurrentBuffer);
        byteBuffer.order(this._order);
        ((Buffer)this._currentBuffer).position(newPosition);
        if (bufferList == null) {
            bufferList = new ArrayList();
        }
        bufferList.add(byteBuffer);
        return bufferList;
    }

    private String bufferToUtf8CString(int numBytes, ArrayList<ByteBuffer> bufferList) throws IOException {
        String result;
        if (numBytes == 0) {
            result = "";
        } else if (bufferList == null) {
            this._decoder.reset();
            CharBuffer charBuffer = CharBuffer.allocate(numBytes);
            int limit = this._currentBuffer.limit();
            ((Buffer)this._currentBuffer).limit(this._currentBuffer.position() + numBytes);
            this.checkCoderResult(this._decoder.decode(this._currentBuffer, charBuffer, true));
            ((Buffer)this._currentBuffer).limit(limit);
            this._decoder.flush(charBuffer);
            ((Buffer)charBuffer).flip();
            result = charBuffer.toString();
        } else {
            int charactersRead;
            char[] charBuffer = new char[numBytes];
            BufferChain chain = new BufferChain(this._order, bufferList, this._bufferSize);
            InputStream inputStream = chain.asInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream, _charset);
            int offset = 0;
            int remaining = numBytes;
            while ((charactersRead = ((Reader)reader).read(charBuffer, offset, remaining)) > 0) {
                offset += charactersRead;
                remaining -= charactersRead;
            }
            result = new String(charBuffer, 0, offset);
        }
        this.advanceBufferIfCurrentBufferHasNoRemaining();
        this._currentBuffer.get();
        return result;
    }

    private void checkCoderResult(CoderResult coderResult) throws IOException {
        if (coderResult != CoderResult.UNDERFLOW) {
            throw new IllegalStateException("Unexpected character decoder error " + coderResult);
        }
    }

    public BufferChain put(byte value) {
        this.reserve(1).put(value);
        return this;
    }

    public BufferChain put(byte[] src, int offset, int length) {
        int remaining = this._currentBuffer.remaining();
        if (remaining < length) {
            for (int more = length; more > 0; more -= remaining) {
                this._currentBuffer = this._bufferList.get(this._currentIndex);
                remaining = this._currentBuffer.remaining();
                if (remaining == 0) {
                    this.reserve(more);
                    remaining = this._currentBuffer.remaining();
                }
                if (remaining > more) {
                    remaining = more;
                }
                this._currentBuffer.put(src, offset, remaining);
                offset += remaining;
            }
        } else {
            this._currentBuffer.put(src, offset, length);
        }
        return this;
    }

    public BufferChain putVarUnsignedInt(int value) {
        int z = value;
        this.reserve(5);
        while ((z & 0xFFFFFF80) != 0) {
            this.put((byte)(z & 0x7F));
            z >>= 7;
        }
        this.put((byte)(z & 0x7F | 0x80));
        return this;
    }

    public BufferChain putVarInt(int value) {
        int v = value << 1 ^ value >> 31;
        this.putVarUnsignedInt(v);
        return this;
    }

    public BufferChain putShort(short value) {
        this.reserve(2).putShort(value);
        return this;
    }

    public BufferChain putInt(int value) {
        this.reserve(4).putInt(value);
        return this;
    }

    public BufferChain putLong(long value) {
        this.reserve(8).putLong(value);
        return this;
    }

    public BufferChain putFloat(float value) {
        this.reserve(4).putFloat(value);
        return this;
    }

    public BufferChain putDouble(double value) {
        this.reserve(8).putDouble(value);
        return this;
    }

    public BufferChain putUtf8CString(String value) throws CharacterCodingException {
        this.reserve(value.length() * 4);
        this._encoder.reset();
        CoderResult result = this._encoder.encode(CharBuffer.wrap(value), this._currentBuffer, true);
        if (result.isError()) {
            result.throwException();
        }
        this._encoder.flush(this._currentBuffer);
        this.put((byte)0);
        return this;
    }

    public BufferChain putByteString(ByteString value) {
        this.reserve(value.length());
        this._currentBuffer.put(value.asByteBuffer());
        return this;
    }

    public byte[] toBytes() {
        if (this._currentBuffer.remaining() > 0) {
            ((Buffer)this._currentBuffer).limit(this._currentBuffer.position());
        }
        this.rewind();
        int size = 0;
        for (ByteBuffer buffer : this._bufferList) {
            size += buffer.limit();
        }
        byte[] bytes = new byte[size];
        int offset = 0;
        for (ByteBuffer buffer : this._bufferList) {
            int length = buffer.limit();
            buffer.get(bytes, offset, length);
            offset += length;
        }
        return bytes;
    }

    public BufferChain rewind() {
        for (ByteBuffer buffer : this._bufferList) {
            ((Buffer)buffer).rewind();
        }
        this._currentIndex = 0;
        this._currentBuffer = this._bufferList.get(this._currentIndex);
        return this;
    }

    public BufferChain readFromInputStream(InputStream inputStream) throws IOException {
        boolean done = false;
        while (!done) {
            int bytesRead;
            this._currentBuffer = this._bufferList.get(this._currentIndex);
            int remaining = this._currentBuffer.remaining();
            if (remaining == 0) {
                int newBufferSize = Math.max(inputStream.available(), this._bufferSize);
                this.reserve(newBufferSize);
                remaining = this._currentBuffer.remaining();
            }
            if ((bytesRead = inputStream.read(this._currentBuffer.array(), this._currentBuffer.arrayOffset(), remaining)) != -1) {
                int newPosition = this._currentBuffer.position() + bytesRead;
                ((Buffer)this._currentBuffer).position(newPosition);
            }
            if (bytesRead >= remaining) continue;
            done = true;
        }
        return this;
    }

    public BufferChain writeToOutputStream(OutputStream outputStream) throws IOException {
        if (this._currentBuffer.remaining() > 0) {
            ((Buffer)this._currentBuffer).limit(this._currentBuffer.position());
        }
        this.rewind();
        for (ByteBuffer buffer : this._bufferList) {
            outputStream.write(buffer.array(), buffer.arrayOffset(), buffer.remaining());
        }
        return this;
    }

    static void dump(PrintStream os, byte[] bytes) {
        BufferChain.dump(os, bytes, 0, bytes.length);
    }

    static void dump(PrintStream os, byte[] bytes, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            byte b = bytes[i];
            if (b >= 32 && b < 127) {
                os.print("'" + (char)b + "'");
            } else {
                os.print(b);
            }
            os.print(' ');
        }
    }

    static void dump(PrintStream os, ByteBuffer buffer) {
        BufferChain.dump(os, buffer.array(), buffer.arrayOffset(), buffer.limit());
    }

    private void initCoders() {
        this._decoder = _charset.newDecoder();
        this._decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this._decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this._encoder = _charset.newEncoder();
        this._encoder.onMalformedInput(CodingErrorAction.REPLACE);
        this._encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private final boolean advanceBufferIfCurrentBufferHasNoRemaining() {
        int remaining = this._currentBuffer.remaining();
        if (remaining > 0) {
            return true;
        }
        if (remaining == 0 && this._currentIndex < this._bufferList.size() - 1) {
            ++this._currentIndex;
            this._currentBuffer = this._bufferList.get(this._currentIndex);
            return true;
        }
        return false;
    }

    private final ByteBuffer remain(int length) {
        ByteBuffer buffer;
        if (!this.advanceBufferIfCurrentBufferHasNoRemaining()) {
            throw new BufferUnderflowException();
        }
        int remaining = this._currentBuffer.remaining();
        if (remaining < length) {
            byte[] bytes = new byte[length];
            this._currentBuffer.get(bytes, 0, remaining);
            if (!this.advanceBufferIfCurrentBufferHasNoRemaining()) {
                throw new BufferUnderflowException();
            }
            this._currentBuffer.get(bytes, remaining, length - remaining);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(this._order);
        } else {
            buffer = this._currentBuffer;
        }
        return buffer;
    }

    private final ByteBuffer reserve(int size) {
        if (this._currentBuffer.remaining() < size) {
            ((Buffer)this._currentBuffer).limit(this._currentBuffer.position());
            this._currentBuffer = this.allocateByteBuffer(size);
            ++this._currentIndex;
        }
        return this._currentBuffer;
    }

    private ByteBuffer allocateByteBuffer(int size) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(size > this._bufferSize ? size : this._bufferSize);
        byteBuffer.order(this._order);
        this._bufferList.add(byteBuffer);
        return byteBuffer;
    }

    private static class BufferChainOutputStream
    extends OutputStream {
        private final BufferChain _bufferChain;

        public BufferChainOutputStream(BufferChain bufferChain) {
            this._bufferChain = bufferChain;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] src) {
            this._bufferChain.put(src, 0, src.length);
        }

        @Override
        public void write(byte[] src, int offset, int length) {
            this._bufferChain.put(src, offset, length);
        }

        @Override
        public void write(int src) {
            this._bufferChain.put((byte)src);
        }
    }

    private static class BufferChainInputStream
    extends InputStream {
        private final BufferChain _bufferChain;
        private Position _position;

        public BufferChainInputStream(BufferChain bufferChain) {
            this._bufferChain = bufferChain;
        }

        @Override
        public int read() {
            try {
                return this._bufferChain.get();
            }
            catch (BufferUnderflowException exc) {
                return -1;
            }
        }

        @Override
        public int read(byte[] dst, int offset, int length) {
            int bytes = this._bufferChain.read(dst, offset, length);
            return bytes == 0 ? -1 : bytes;
        }

        @Override
        public int read(byte[] dst) {
            return this.read(dst, 0, dst.length);
        }

        @Override
        public void mark(int readLimit) {
            this._position = this._bufferChain.position();
        }

        @Override
        public void reset() throws IOException {
            if (this._position == null) {
                throw new IOException("Mark not called before reset");
            }
            this._bufferChain.position(this._position);
        }

        @Override
        public boolean markSupported() {
            return true;
        }
    }

    public static final class Position {
        final BufferChain _bufferChain;
        final int _index;
        final int _position;

        Position(BufferChain bufferChain, int index, int position) {
            this._bufferChain = bufferChain;
            this._index = index;
            this._position = position;
        }
    }
}

