/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.BufferChain;
import com.linkedin.data.codec.DataCodec;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.collections.CheckedUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayDeque;
import java.util.Deque;

public class BsonDataCodec
implements DataCodec {
    private static final String UTF_8 = "UTF-8";
    private Integer _bufferSize;
    private boolean _testMode;
    static final byte ZERO_BYTE = 0;
    static final byte ONE_BYTE = 1;
    static final byte BSON_DOUBLE = 1;
    static final byte BSON_STRING = 2;
    static final byte BSON_EMBEDDED_DOCUMENT = 3;
    static final byte BSON_ARRAY = 4;
    static final byte BSON_BINARY = 5;
    static final byte BSON_DEPRECATED = 6;
    static final byte BSON_OBJECTID = 7;
    static final byte BSON_BOOLEAN = 8;
    static final byte BSON_UTC_DATETIME = 9;
    static final byte BSON_NULL = 10;
    static final byte BSON_REGEX = 11;
    static final byte BSON_DBPOINTER_DEPRECATED = 12;
    static final byte BSON_JAVASCRIPT_CODE = 13;
    static final byte BSON_SYMBOL = 14;
    static final byte BSON_JAVASCRIPT_CODE_WITH_SCOPE = 15;
    static final byte BSON_32BIT_INTEGER = 16;
    static final byte BSON_TIMESTAMP = 17;
    static final byte BSON_64BIT_INTEGER = 18;
    static final byte BSON_MINKEY = -1;
    static final byte BSON_MAXKEY = 127;

    public BsonDataCodec() {
        this._bufferSize = null;
    }

    public BsonDataCodec(int bufferSize) {
        this(bufferSize, false);
    }

    public BsonDataCodec(int bufferSize, boolean testMode) {
        this._bufferSize = bufferSize;
        this._testMode = testMode;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    protected byte[] complexToBytes(DataComplex complex) throws IOException {
        try {
            BsonTraverseCallback callback = this._bufferSize == null ? new BsonTraverseCallback() : new BsonTraverseCallback(this._bufferSize);
            Data.traverse(complex, callback);
            byte[] bytes = callback.toBytes();
            return bytes;
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    @Override
    public byte[] mapToBytes(DataMap map) throws IOException {
        return this.complexToBytes(map);
    }

    @Override
    public byte[] listToBytes(DataList list) throws IOException {
        return this.complexToBytes(list);
    }

    protected <T extends DataComplex> T bytesToComplex(byte[] input, Class<T> clazz) throws IOException {
        try {
            BufferChain buffer = this._testMode && this._bufferSize != null ? new BufferChain(ByteOrder.LITTLE_ENDIAN, input, (int)this._bufferSize) : new BufferChain(ByteOrder.LITTLE_ENDIAN, input);
            BsonParser bsonParser = new BsonParser(buffer);
            return bsonParser.parseComplex(clazz);
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    @Override
    public DataMap bytesToMap(byte[] input) throws IOException {
        return this.bytesToComplex(input, DataMap.class);
    }

    @Override
    public DataList bytesToList(byte[] input) throws IOException {
        return this.bytesToComplex(input, DataList.class);
    }

    protected void writeComplex(DataComplex complex, OutputStream out) throws IOException {
        try {
            BsonTraverseCallback callback = this._bufferSize == null ? new BsonTraverseCallback() : new BsonTraverseCallback(this._bufferSize);
            Data.traverse(complex, callback);
            callback.writeToOutputStream(out);
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    @Override
    public void writeMap(DataMap map, OutputStream out) throws IOException {
        this.writeComplex(map, out);
    }

    @Override
    public void writeList(DataList list, OutputStream out) throws IOException {
        this.writeComplex(list, out);
    }

    protected <T extends DataComplex> T readComplex(InputStream in, Class<T> clazz) throws IOException {
        try {
            BufferChain buffer = this._testMode && this._bufferSize != null ? new BufferChain(ByteOrder.LITTLE_ENDIAN, this._bufferSize) : new BufferChain(ByteOrder.LITTLE_ENDIAN);
            buffer.readFromInputStream(in);
            buffer.rewind();
            BsonParser bsonParser = new BsonParser(buffer);
            return bsonParser.parseComplex(clazz);
        }
        catch (RuntimeException exc) {
            throw new IOException("Unexpected RuntimeException", exc);
        }
    }

    @Override
    public DataMap readMap(InputStream in) throws IOException {
        return this.readComplex(in, DataMap.class);
    }

    @Override
    public DataList readList(InputStream in) throws IOException {
        return this.readComplex(in, DataList.class);
    }

    protected static class BsonParser {
        private final BufferChain _buffer;

        BsonParser(BufferChain buffer) {
            this._buffer = buffer;
        }

        void parseDocument(DataList list, DataMap map) throws IOException {
            this._buffer.getInt();
            byte bsonType = this._buffer.get();
            while (bsonType != 0) {
                String name = this._buffer.getUtf8CString();
                Object o = null;
                boolean valid = true;
                switch (bsonType) {
                    case 3: {
                        DataMap childMap = new DataMap();
                        this.updateParent(list, map, name, childMap);
                        this.parseDocument(null, childMap);
                        break;
                    }
                    case 4: {
                        DataList childList = new DataList();
                        this.updateParent(list, map, name, childList);
                        this.parseDocument(childList, null);
                        break;
                    }
                    case 16: {
                        o = this._buffer.getInt();
                        break;
                    }
                    case 1: {
                        o = this._buffer.getDouble();
                        break;
                    }
                    case 2: {
                        o = this.getString();
                        break;
                    }
                    case 8: {
                        byte b = this._buffer.get();
                        o = b != 0;
                        break;
                    }
                    case 18: {
                        o = this._buffer.getLong();
                        break;
                    }
                    case 5: {
                        int length = this._buffer.getInt();
                        this._buffer.get();
                        o = ByteString.read(this._buffer.asInputStream(), length);
                        break;
                    }
                    case 6: 
                    case 7: {
                        valid = false;
                        break;
                    }
                    case 9: 
                    case 17: {
                        o = this._buffer.getLong();
                        break;
                    }
                    case 10: {
                        o = Data.NULL;
                        break;
                    }
                    case 11: {
                        valid = false;
                        this._buffer.getUtf8CString();
                        this._buffer.getUtf8CString();
                        break;
                    }
                    case 12: {
                        o = this.getString();
                        byte[] dbPointer = new byte[12];
                        this._buffer.get(dbPointer, 0, dbPointer.length);
                        valid = false;
                        break;
                    }
                    case 13: 
                    case 14: {
                        o = this.getString();
                        break;
                    }
                    case 15: {
                        valid = false;
                        break;
                    }
                    default: {
                        valid = false;
                    }
                }
                if (!valid) {
                    throw new IOException("Illegal BSON element code " + bsonType);
                }
                if (o != null) {
                    this.updateParent(list, map, name, o);
                }
                bsonType = this._buffer.get();
            }
        }

        <T extends DataComplex> T parseComplex(Class<T> clazz) throws IOException {
            if (clazz == DataMap.class) {
                return (T)((DataComplex)clazz.cast(this.parseMap()));
            }
            if (clazz == DataList.class) {
                return (T)((DataComplex)clazz.cast(this.parseList()));
            }
            throw new IllegalStateException("Unknown DataComplex class " + clazz.getName());
        }

        DataMap parseMap() throws IOException {
            DataMap map = new DataMap();
            this.parseDocument(null, map);
            return map;
        }

        DataList parseList() throws IOException {
            DataList list = new DataList();
            this.parseDocument(list, null);
            return list;
        }

        private void updateParent(DataList parentList, DataMap parentMap, String name, Object value) {
            if (parentMap != null) {
                CheckedUtil.putWithoutChecking(parentMap, name, value);
            } else {
                CheckedUtil.addWithoutChecking(parentList, value);
            }
        }

        String getString() throws IOException {
            int length = this._buffer.getInt();
            if (length == 0) {
                throw new DataDecodingException("String size should not be 0");
            }
            return this._buffer.getUtf8CString(length);
        }
    }

    protected static class BsonTraverseCallback
    implements Data.TraverseCallback {
        private final BufferChain _buffer;
        private final Deque<BufferChain.Position> _positionStack = new ArrayDeque<BufferChain.Position>();
        private String _currentName = null;

        BsonTraverseCallback() {
            this._buffer = new BufferChain(ByteOrder.LITTLE_ENDIAN);
        }

        BsonTraverseCallback(int bufferSize) {
            this._buffer = new BufferChain(ByteOrder.LITTLE_ENDIAN, bufferSize);
        }

        @Override
        public void nullValue() throws CharacterCodingException {
            this._buffer.put((byte)10);
            this.putName();
        }

        @Override
        public void booleanValue(boolean value) throws CharacterCodingException {
            this._buffer.put((byte)8);
            this.putName();
            this._buffer.put(value ? (byte)1 : 0);
        }

        @Override
        public void integerValue(int value) throws CharacterCodingException {
            this._buffer.put((byte)16);
            this.putName();
            this._buffer.putInt(value);
        }

        @Override
        public void longValue(long value) throws CharacterCodingException {
            this._buffer.put((byte)18);
            this.putName();
            this._buffer.putLong(value);
        }

        @Override
        public void floatValue(float value) throws CharacterCodingException {
            this.doubleValue(value);
        }

        @Override
        public void doubleValue(double value) throws CharacterCodingException {
            this._buffer.put((byte)1);
            this.putName();
            this._buffer.putDouble(value);
        }

        @Override
        public void stringValue(String value) throws CharacterCodingException {
            this._buffer.put((byte)2);
            this.putName();
            this.putString(value);
        }

        @Override
        public void byteStringValue(ByteString value) throws CharacterCodingException {
            this._buffer.put((byte)5);
            this.putName();
            this._buffer.putInt(value.length());
            this._buffer.put((byte)0);
            this._buffer.putByteString(value);
        }

        @Override
        public void illegalValue(Object value) throws IOException {
            throw new IOException("Illegal type encountered: " + value.getClass());
        }

        @Override
        public void emptyMap() throws CharacterCodingException {
            this.emptyDocument((byte)3);
        }

        @Override
        public void startMap(DataMap map) throws CharacterCodingException {
            this.startDocument((byte)3);
        }

        @Override
        public void key(String key) {
            this._currentName = key;
        }

        @Override
        public void endMap() {
            this.endDocument();
        }

        @Override
        public void emptyList() throws CharacterCodingException {
            this.emptyDocument((byte)4);
        }

        @Override
        public void startList(DataList list) throws CharacterCodingException {
            this.startDocument((byte)4);
        }

        @Override
        public void index(int index) {
            this._currentName = String.valueOf(index);
        }

        @Override
        public void endList() {
            this.endDocument();
        }

        private final void putName() throws CharacterCodingException {
            this.putCString(this._currentName);
        }

        private final void putString(String s2) throws CharacterCodingException {
            BufferChain.Position startPos = this._buffer.position();
            this._buffer.putInt(0);
            this._buffer.putUtf8CString(s2);
            BufferChain.Position endPos = this._buffer.position();
            this._buffer.position(startPos);
            this._buffer.putInt(this._buffer.offset(startPos, endPos) - 4);
            this._buffer.position(endPos);
        }

        private final byte[] toBytes() {
            return this._buffer.toBytes();
        }

        private final void writeToOutputStream(OutputStream out) throws IOException {
            this._buffer.writeToOutputStream(out);
        }

        private final void putCString(String s2) throws CharacterCodingException {
            this._buffer.putUtf8CString(s2);
        }

        private void emptyDocument(byte bsonType) throws CharacterCodingException {
            if (this._currentName != null) {
                this._buffer.put(bsonType);
                this.putName();
            }
            this._buffer.putInt(1);
            this._buffer.put((byte)0);
        }

        private void startDocument(byte bsonType) throws CharacterCodingException {
            if (this._currentName != null) {
                this._buffer.put(bsonType);
                this.putName();
            }
            BufferChain.Position pos = this._buffer.position();
            this._positionStack.addLast(pos);
            this._buffer.putInt(0);
        }

        private void endDocument() {
            this._buffer.put((byte)0);
            BufferChain.Position startPos = this._positionStack.removeLast();
            BufferChain.Position endPos = this._buffer.position();
            int length = this._buffer.offset(startPos, endPos);
            this._buffer.position(startPos);
            this._buffer.putInt(length);
            this._buffer.position(endPos);
        }
    }
}

