/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data;

import com.linkedin.data.Data;
import com.linkedin.data.DataComplex;
import com.linkedin.data.DataComplexHashCode;
import com.linkedin.data.DataComplexTable;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedList;
import com.linkedin.data.collections.ListChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class DataList
extends CheckedList<Object>
implements DataComplex {
    private static final ListChecker<Object> _checker = (list, e) -> Data.checkAllowed((DataComplex)((Object)list), e);
    private volatile ThreadLocal<Object> _isTraversing = null;
    private boolean _madeReadOnly = false;
    private boolean _instrumented = false;
    private ArrayList<Integer> _accessList;
    private int _dataComplexHashCode = 0;

    public DataList() {
        super(_checker);
    }

    public DataList(List<? extends Object> list) {
        super(list, _checker);
    }

    public DataList(int initialCapacity) {
        super(initialCapacity, _checker);
    }

    @Override
    public Object get(int index) {
        this.instrumentAccess(index);
        return super.get(index);
    }

    @Override
    public DataList clone() throws CloneNotSupportedException {
        DataList o = (DataList)super.clone();
        o._madeReadOnly = false;
        o._instrumented = false;
        o._accessList = null;
        o._dataComplexHashCode = 0;
        o._isTraversing = null;
        return o;
    }

    @Override
    public DataList copy() throws CloneNotSupportedException {
        return Data.copy(this, new DataComplexTable());
    }

    public void copyReferencedObjects(DataComplexTable alreadyCopied) throws CloneNotSupportedException {
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            Object valueCopy;
            Object value = this.get(i);
            if (value == (valueCopy = Data.copy(value, alreadyCopied))) continue;
            this.setWithoutChecking(i, valueCopy);
        }
    }

    @Override
    public Collection<Object> values() {
        return this;
    }

    @Override
    public void makeReadOnly() {
        for (Object o : this) {
            Data.makeReadOnly(o);
        }
        this.setReadOnly();
        this._madeReadOnly = true;
    }

    @Override
    public boolean isMadeReadOnly() {
        return this._madeReadOnly;
    }

    public DataList getDataList(int index) {
        return (DataList)this.get(index);
    }

    public DataMap getDataMap(int index) {
        return (DataMap)this.get(index);
    }

    @Override
    public void startInstrumentingAccess() {
        Data.startInstrumentingAccess(this.values());
        this._instrumented = true;
        if (this._accessList == null) {
            this._accessList = new ArrayList(this.size());
        }
    }

    @Override
    public void stopInstrumentingAccess() {
        this._instrumented = false;
        Data.stopInstrumentingAccess(this.values());
    }

    @Override
    public void clearInstrumentedData() {
        if (this._accessList != null) {
            this._accessList.clear();
        }
    }

    @Override
    public void collectInstrumentedData(StringBuilder keyPrefix, Map<String, Map<String, Object>> instrumentedData, boolean collectAllData) {
        for (int i = 0; i < this.size(); ++i) {
            int preLength = keyPrefix.length();
            keyPrefix.append('[');
            keyPrefix.append(i);
            keyPrefix.append(']');
            Object object = super.get(i);
            Integer timesAccessed = this._accessList == null ? 0 : (i < this._accessList.size() ? this._accessList.get(i) : 0);
            Data.collectInstrumentedData(keyPrefix, object, timesAccessed, instrumentedData, collectAllData);
            keyPrefix.setLength(preLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dataComplexHashCode() {
        if (this._dataComplexHashCode != 0) {
            return this._dataComplexHashCode;
        }
        DataList dataList = this;
        synchronized (dataList) {
            if (this._dataComplexHashCode == 0) {
                this._dataComplexHashCode = DataComplexHashCode.nextHashCode();
            }
        }
        return this._dataComplexHashCode;
    }

    void disableChecker() {
        ((CheckedList)this)._checker = null;
    }

    List<Object> getUnderlying() {
        return this.getObject();
    }

    private void instrumentAccess(int index) {
        if (this._instrumented) {
            if (index >= this._accessList.size()) {
                this._accessList.ensureCapacity(this.size());
                for (int i = this._accessList.size(); i < index; ++i) {
                    this._accessList.add(0);
                }
                this._accessList.add(1);
            } else {
                this._accessList.set(index, this._accessList.get(index) + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadLocal<Object> isTraversing() {
        if (this._isTraversing == null) {
            DataList dataList = this;
            synchronized (dataList) {
                if (this._isTraversing == null) {
                    this._isTraversing = new ThreadLocal();
                }
            }
        }
        return this._isTraversing;
    }
}

