/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.stats;

import com.linkedin.common.stats.LongStats;
import com.linkedin.common.stats.LongTracker;
import com.linkedin.common.stats.SimpleLongTracking;
import java.util.Arrays;

public class LongTracking
implements LongTracker {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    private static final double DEFAULT_GROWTH_FACTOR = 2.0;
    private static final int DEFAULT_MAX_CAPACITY = 4000;
    private long[] _buffer;
    private int _bufferSize;
    private final int _initialCapacity;
    private final double _growthFactor;
    private final int _maxCapacity;
    private int _sortedEnd;
    private int _nextIndex;
    private int _keepRatio;
    private final SimpleLongTracking _simpleLongTracking;

    public LongTracking() {
        this(4000, 1000, 2.0);
    }

    public LongTracking(int maxCapacity, int initialCapacity, double growthFactor) {
        if (initialCapacity > maxCapacity || initialCapacity <= 0) {
            initialCapacity = maxCapacity;
        }
        if (growthFactor <= 1.0) {
            growthFactor = 2.0;
        }
        this._buffer = new long[initialCapacity];
        this._bufferSize = initialCapacity;
        this._initialCapacity = initialCapacity;
        this._growthFactor = growthFactor;
        this._maxCapacity = maxCapacity;
        this._simpleLongTracking = new SimpleLongTracking();
        this.reset();
    }

    @Override
    public void reset() {
        this._simpleLongTracking.reset();
        this._sortedEnd = 0;
        this._nextIndex = 0;
        this._keepRatio = 1;
    }

    @Override
    public void addValue(long value) {
        this._simpleLongTracking.addValue(value);
        if (this._keepRatio > 1 && this._simpleLongTracking.getCount() % this._keepRatio != 0) {
            return;
        }
        if (this._nextIndex >= this._bufferSize) {
            if (this._bufferSize < this._maxCapacity) {
                this.grow();
            } else {
                this.dropHalf();
            }
        }
        this._buffer[this._nextIndex] = value;
        ++this._nextIndex;
    }

    @Override
    public LongStats getStats() {
        return new LongStats(this._simpleLongTracking.getCount(), this._simpleLongTracking.getAverage(), this._simpleLongTracking.getStandardDeviation(), this._simpleLongTracking.getMinimum(), this._simpleLongTracking.getMaximum(), this.get50Pct(), this.get90Pct(), this.get95Pct(), this.get99Pct());
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public int getInitialCapacity() {
        return this._initialCapacity;
    }

    public double getGrowthFactor() {
        return this._growthFactor;
    }

    public int getMaxCapacity() {
        return this._maxCapacity;
    }

    private long get50Pct() {
        return this.getPercentile(0.5);
    }

    private long get90Pct() {
        return this.getPercentile(0.9);
    }

    private long get95Pct() {
        return this.getPercentile(0.95);
    }

    private long get99Pct() {
        return this.getPercentile(0.99);
    }

    public long getPercentile(double pct) {
        if (this._simpleLongTracking.getCount() == 0) {
            return 0L;
        }
        if (this._sortedEnd < this._nextIndex) {
            Arrays.sort(this._buffer, 0, this._nextIndex);
            this._sortedEnd = this._nextIndex;
        }
        if (pct < 0.0) {
            pct = 0.0;
        } else if (pct > 1.0) {
            pct = 1.0;
        }
        int index = (int)Math.round(pct * (double)(this._sortedEnd - 1));
        return this._buffer[index];
    }

    private void dropHalf() {
        this._nextIndex = (this._nextIndex + 1) / 2;
        this._sortedEnd = (this._sortedEnd + 1) / 2;
        this._keepRatio += this._keepRatio;
        int destIndex = 1;
        int lastSrcIndex = 0;
        while (destIndex < this._nextIndex) {
            this._buffer[destIndex++] = this._buffer[lastSrcIndex += 2];
        }
    }

    private void grow() {
        int newBufferSize = (int)((double)this._bufferSize * this._growthFactor);
        if (newBufferSize == this._bufferSize) {
            newBufferSize += 1000;
        }
        if (newBufferSize > this._maxCapacity) {
            newBufferSize = this._maxCapacity;
        }
        long[] newBuffer = new long[newBufferSize];
        System.arraycopy(this._buffer, 0, newBuffer, 0, this._nextIndex);
        this._buffer = newBuffer;
        this._bufferSize = newBufferSize;
    }
}

