/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PropertyValue
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common,record PropertyValue{value:union[string,double]/**Optional description of the property value*/description:optional string}", SchemaFormatType.PDL);
    private Value _valueField = null;
    private String _descriptionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Value = SCHEMA.getField("value");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");

    public PropertyValue() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public PropertyValue(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasValue() {
        if (this._valueField != null) {
            return true;
        }
        return this._map.containsKey("value");
    }

    public void removeValue() {
        this._map.remove("value");
    }

    @Nullable
    public Value getValue(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValue();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valueField != null) {
                    return this._valueField;
                }
                Object __rawValue = this._map.get("value");
                this._valueField = __rawValue == null ? null : new Value(__rawValue);
                return this._valueField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Value getValue() {
        if (this._valueField != null) {
            return this._valueField;
        }
        Object __rawValue = this._map.get("value");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("value");
        }
        this._valueField = __rawValue == null ? null : new Value(__rawValue);
        return this._valueField;
    }

    public PropertyValue setValue(@Nullable Value value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field value of com.linkedin.common.PropertyValue");
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
            }
        }
        return this;
    }

    public PropertyValue setValue(@Nonnull Value value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field value of com.linkedin.common.PropertyValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "value", value.data());
        this._valueField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public PropertyValue setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public PropertyValue setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.common.PropertyValue to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    @Override
    public PropertyValue clone() throws CloneNotSupportedException {
        PropertyValue __clone = (PropertyValue)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public PropertyValue copy() throws CloneNotSupportedException {
        PropertyValue __copy = (PropertyValue)super.copy();
        __copy._descriptionField = null;
        __copy._valueField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    public static class Value
    extends UnionTemplate {
        private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[string,double]", SchemaFormatType.PDL);
        private String _stringMember = null;
        private Double _doubleMember = null;
        private ChangeListener __changeListener = new ChangeListener(this);
        private static final DataSchema MEMBER_String = SCHEMA.getTypeByMemberKey("string");
        public static final String MEMBERKEY_String = "string";
        private static final DataSchema MEMBER_Double = SCHEMA.getTypeByMemberKey("double");
        public static final String MEMBERKEY_Double = "double";

        public Value() {
            super(new DataMap(2, 0.75f), SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public Value(Object data) {
            super(data, SCHEMA);
            this.addChangeListener(this.__changeListener);
        }

        public static UnionDataSchema dataSchema() {
            return SCHEMA;
        }

        public static Value create(String value) {
            Value newUnion = new Value();
            newUnion.setString(value);
            return newUnion;
        }

        public boolean isString() {
            return this.memberIs(MEMBERKEY_String);
        }

        public String getString() {
            this.checkNotNull();
            if (this._stringMember != null) {
                return this._stringMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_String);
            this._stringMember = DataTemplateUtil.coerceStringOutput(__rawValue);
            return this._stringMember;
        }

        public void setString(String value) {
            this.checkNotNull();
            this._map.clear();
            this._stringMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_String, value);
        }

        public static Value create(Double value) {
            Value newUnion = new Value();
            newUnion.setDouble(value);
            return newUnion;
        }

        public boolean isDouble() {
            return this.memberIs(MEMBERKEY_Double);
        }

        public Double getDouble() {
            this.checkNotNull();
            if (this._doubleMember != null) {
                return this._doubleMember;
            }
            Object __rawValue = this._map.get(MEMBERKEY_Double);
            this._doubleMember = DataTemplateUtil.coerceDoubleOutput(__rawValue);
            return this._doubleMember;
        }

        public void setDouble(Double value) {
            this.checkNotNull();
            this._map.clear();
            this._doubleMember = value;
            CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Double, DataTemplateUtil.coerceDoubleInput(value));
        }

        public static ProjectionMask createMask() {
            return new ProjectionMask();
        }

        @Override
        public Value clone() throws CloneNotSupportedException {
            Value __clone = (Value)super.clone();
            __clone.__changeListener = new ChangeListener(__clone);
            __clone.addChangeListener(__clone.__changeListener);
            return __clone;
        }

        @Override
        public Value copy() throws CloneNotSupportedException {
            Value __copy = (Value)super.copy();
            __copy._stringMember = null;
            __copy._doubleMember = null;
            __copy.__changeListener = new ChangeListener(__copy);
            __copy.addChangeListener(__copy.__changeListener);
            return __copy;
        }

        private static class ChangeListener
        implements CheckedMap.ChangeListener<String, Object> {
            private final Value __objectRef;

            private ChangeListener(Value reference) {
                this.__objectRef = reference;
            }

            @Override
            public void onUnderlyingMapChanged(String key, Object value) {
                switch (key) {
                    case "string": {
                        this.__objectRef._stringMember = null;
                        break;
                    }
                    case "double": {
                        this.__objectRef._doubleMember = null;
                    }
                }
            }
        }

        public static class ProjectionMask
        extends MaskMap {
            ProjectionMask() {
                super(3);
            }

            public ProjectionMask withString() {
                this.getDataMap().put(Value.MEMBERKEY_String, 1);
                return this;
            }

            public ProjectionMask withDouble() {
                this.getDataMap().put(Value.MEMBERKEY_Double, 1);
                return this;
            }
        }

        public static class Fields
        extends PathSpec {
            public Fields(List<String> path, String name) {
                super(path, name);
            }

            public Fields() {
            }

            public PathSpec String() {
                return new PathSpec(this.getPathComponents(), Value.MEMBERKEY_String);
            }

            public PathSpec Double() {
                return new PathSpec(this.getPathComponents(), Value.MEMBERKEY_Double);
            }
        }
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final PropertyValue __objectRef;

        private ChangeListener(PropertyValue reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "value": {
                    this.__objectRef._valueField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public Value.Fields value() {
            return new Value.Fields(this.getPathComponents(), "value");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private Value.ProjectionMask _valueMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withValue(Function<Value.ProjectionMask, Value.ProjectionMask> nestedMask) {
            this._valueMask = nestedMask.apply(this._valueMask == null ? Value.createMask() : this._valueMask);
            this.getDataMap().put("value", this._valueMask.getDataMap());
            return this;
        }

        public ProjectionMask withValue() {
            this._valueMask = null;
            this.getDataMap().put("value", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }
    }
}

