/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.Owner;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class OwnerArray
extends WrappingArrayTemplate<Owner> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.common/**Ownership information*/record Owner{/**Owner URN, e.g. urn:li:corpuser:ldap, urn:li:corpGroup:group_name, and urn:li:multiProduct:mp_name\n(Caveat: only corpuser is currently supported in the frontend.)*/@Relationship={\"entityTypes\":[\"corpuser\",\"corpGroup\"],\"name\":\"OwnedBy\"}@Searchable={\"addToFilters\":true,\"fieldName\":\"owners\",\"fieldType\":\"URN\",\"filterNameOverride\":\"Owned By\",\"hasValuesFieldName\":\"hasOwners\",\"queryByDefault\":false}owner:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The type of the ownership*/@deprecated,type:/**Asset owner types*/enum OwnershipType{/**Set when ownership type is unknown or a when new one is specified as an ownership type entity for which we have no\nenum value for. This is used for backwards compatibility*/CUSTOM/**person or group who is responsible for technical aspects of the asset.*/TECHNICAL_OWNER/**A person or group who is responsible for logical, or business related, aspects of the asset.*/BUSINESS_OWNER/**A steward, expert, or delegate responsible for the asset.*/DATA_STEWARD/**No specific type associated to the owner.*/NONE/**A person or group that is in charge of developing the code\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DEVELOPER/**A person or group that is owning the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DATAOWNER/**A person or a group that overseas the operation, e.g. a DBA or SRE.\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,DELEGATE/**A person, group, or service that produces/generates the data\nDeprecated! Use TECHNICAL_OWNER instead.*/@deprecated,PRODUCER/**A person, group, or service that consumes the data\nDeprecated! Use TECHNICAL_OWNER or BUSINESS_OWNER instead.*/@deprecated,CONSUMER/**A person or a group that has direct business interest\nDeprecated! Use TECHNICAL_OWNER, BUSINESS_OWNER, or STEWARD instead.*/@deprecated,STAKEHOLDER}/**The type of the ownership\nUrn of type O*/@Relationship={\"entityTypes\":[\"ownershipType\"],\"name\":\"ownershipType\"}typeUrn:optional Urn/**Source information for the ownership*/source:optional/**Source/provider of the ownership information*/record OwnershipSource{/**The type of the source*/type:enum OwnershipSourceType{/**Auditing system or audit logs*/AUDIT/**Database, e.g. GRANTS table*/DATABASE/**File system, e.g. file/directory owner*/FILE_SYSTEM/**Issue tracking system, e.g. Jira*/ISSUE_TRACKING_SYSTEM/**Manually provided by a user*/MANUAL/**Other ownership-like service, e.g. Nuage, ACL service etc*/SERVICE/**SCM system, e.g. GIT, SVN*/SOURCE_CONTROL/**Other sources*/OTHER}/**A reference URL for the source*/url:optional string}}}]", SchemaFormatType.PDL);

    public OwnerArray() {
        this(new DataList());
    }

    public OwnerArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public OwnerArray(Collection<Owner> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public OwnerArray(DataList data) {
        super(data, SCHEMA, Owner.class);
    }

    public OwnerArray(Owner first, Owner ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public OwnerArray clone() throws CloneNotSupportedException {
        OwnerArray __clone = (OwnerArray)super.clone();
        return __clone;
    }

    @Override
    public OwnerArray copy() throws CloneNotSupportedException {
        OwnerArray __copy = (OwnerArray)super.copy();
        return __copy;
    }

    @Override
    protected Owner coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new Owner(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private Owner.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<Owner.ProjectionMask, Owner.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? Owner.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public Owner.Fields items() {
            return new Owner.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

