/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InstitutionalMemoryMetadata
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Metadata corresponding to a record of institutional memory.*/record InstitutionalMemoryMetadata{/**Link to an engineering design document or a wiki page.*/url:@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string/**Description of the link.*/description:string/**Audit stamp associated with creation of this record*/createStamp:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}", SchemaFormatType.PDL);
    private Url _urlField = null;
    private String _descriptionField = null;
    private AuditStamp _createStampField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Url = SCHEMA.getField("url");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_CreateStamp = SCHEMA.getField("createStamp");

    public InstitutionalMemoryMetadata() {
        super(new DataMap(4, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public InstitutionalMemoryMetadata(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUrl() {
        if (this._urlField != null) {
            return true;
        }
        return this._map.containsKey("url");
    }

    public void removeUrl() {
        this._map.remove("url");
    }

    @Nullable
    public Url getUrl(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUrl();
            }
            case DEFAULT: 
            case NULL: {
                if (this._urlField != null) {
                    return this._urlField;
                }
                Object __rawValue = this._map.get("url");
                this._urlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
                return this._urlField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Url getUrl() {
        if (this._urlField != null) {
            return this._urlField;
        }
        Object __rawValue = this._map.get("url");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("url");
        }
        this._urlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._urlField;
    }

    public InstitutionalMemoryMetadata setUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field url of com.linkedin.common.InstitutionalMemoryMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "url", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._urlField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "url", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._urlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "url", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._urlField = value;
            }
        }
        return this;
    }

    public InstitutionalMemoryMetadata setUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field url of com.linkedin.common.InstitutionalMemoryMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "url", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._urlField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDescription();
            }
            case DEFAULT: 
            case NULL: {
                if (this._descriptionField != null) {
                    return this._descriptionField;
                }
                Object __rawValue = this._map.get("description");
                this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._descriptionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("description");
        }
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public InstitutionalMemoryMetadata setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field description of com.linkedin.common.InstitutionalMemoryMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public InstitutionalMemoryMetadata setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.common.InstitutionalMemoryMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasCreateStamp() {
        if (this._createStampField != null) {
            return true;
        }
        return this._map.containsKey("createStamp");
    }

    public void removeCreateStamp() {
        this._map.remove("createStamp");
    }

    @Nullable
    public AuditStamp getCreateStamp(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreateStamp();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createStampField != null) {
                    return this._createStampField;
                }
                Object __rawValue = this._map.get("createStamp");
                this._createStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createStampField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreateStamp() {
        if (this._createStampField != null) {
            return this._createStampField;
        }
        Object __rawValue = this._map.get("createStamp");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("createStamp");
        }
        this._createStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createStampField;
    }

    public InstitutionalMemoryMetadata setCreateStamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreateStamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field createStamp of com.linkedin.common.InstitutionalMemoryMetadata");
                }
                CheckedUtil.putWithoutChecking(this._map, "createStamp", value.data());
                this._createStampField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreateStamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "createStamp", value.data());
                this._createStampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "createStamp", value.data());
                this._createStampField = value;
            }
        }
        return this;
    }

    public InstitutionalMemoryMetadata setCreateStamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field createStamp of com.linkedin.common.InstitutionalMemoryMetadata to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "createStamp", value.data());
        this._createStampField = value;
        return this;
    }

    @Override
    public InstitutionalMemoryMetadata clone() throws CloneNotSupportedException {
        InstitutionalMemoryMetadata __clone = (InstitutionalMemoryMetadata)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public InstitutionalMemoryMetadata copy() throws CloneNotSupportedException {
        InstitutionalMemoryMetadata __copy = (InstitutionalMemoryMetadata)super.copy();
        __copy._descriptionField = null;
        __copy._createStampField = null;
        __copy._urlField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final InstitutionalMemoryMetadata __objectRef;

        private ChangeListener(InstitutionalMemoryMetadata reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "createStamp": {
                    this.__objectRef._createStampField = null;
                    break;
                }
                case "url": {
                    this.__objectRef._urlField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec url() {
            return new PathSpec(this.getPathComponents(), "url");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public AuditStamp.Fields createStamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "createStamp");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createStampMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withUrl() {
            this.getDataMap().put("url", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withCreateStamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createStampMask = nestedMask.apply(this._createStampMask == null ? AuditStamp.createMask() : this._createStampMask);
            this.getDataMap().put("createStamp", this._createStampMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreateStamp(MaskMap nestedMask) {
            this.getDataMap().put("createStamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreateStamp() {
            this._createStampMask = null;
            this.getDataMap().put("createStamp", 1);
            return this;
        }
    }
}

