/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.IconProperties;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DisplayProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Properties related to how the entity is displayed in the Datahub UI*/@Aspect.name=\"displayProperties\"record DisplayProperties{/**The color associated with the entity in Hex. For example #FFFFFF.*/colorHex:optional string/**The icon associated with the entity*/icon:optional/**Properties describing an icon associated with an entity*/record IconProperties{/**The source of the icon: e.g. Antd, Material, etc*/iconLibrary:/**Enum of possible icon sources*/enum IconLibrary{/**Material UI*/MATERIAL}/**The name of the icon*/name:string/**Any modifier for the icon, this will be library-specific, e.g. filled/outlined, etc*/style:string}}", SchemaFormatType.PDL);
    private String _colorHexField = null;
    private IconProperties _iconField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_ColorHex = SCHEMA.getField("colorHex");
    private static final RecordDataSchema.Field FIELD_Icon = SCHEMA.getField("icon");

    public DisplayProperties() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DisplayProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasColorHex() {
        if (this._colorHexField != null) {
            return true;
        }
        return this._map.containsKey("colorHex");
    }

    public void removeColorHex() {
        this._map.remove("colorHex");
    }

    @Nullable
    public String getColorHex(GetMode mode) {
        return this.getColorHex();
    }

    @Nullable
    public String getColorHex() {
        if (this._colorHexField != null) {
            return this._colorHexField;
        }
        Object __rawValue = this._map.get("colorHex");
        this._colorHexField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._colorHexField;
    }

    public DisplayProperties setColorHex(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setColorHex(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeColorHex();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "colorHex", value);
                this._colorHexField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "colorHex", value);
                this._colorHexField = value;
            }
        }
        return this;
    }

    public DisplayProperties setColorHex(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field colorHex of com.linkedin.common.DisplayProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "colorHex", value);
        this._colorHexField = value;
        return this;
    }

    public boolean hasIcon() {
        if (this._iconField != null) {
            return true;
        }
        return this._map.containsKey("icon");
    }

    public void removeIcon() {
        this._map.remove("icon");
    }

    @Nullable
    public IconProperties getIcon(GetMode mode) {
        return this.getIcon();
    }

    @Nullable
    public IconProperties getIcon() {
        if (this._iconField != null) {
            return this._iconField;
        }
        Object __rawValue = this._map.get("icon");
        this._iconField = __rawValue == null ? null : new IconProperties(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._iconField;
    }

    public DisplayProperties setIcon(@Nullable IconProperties value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIcon(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIcon();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "icon", value.data());
                this._iconField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "icon", value.data());
                this._iconField = value;
            }
        }
        return this;
    }

    public DisplayProperties setIcon(@Nonnull IconProperties value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field icon of com.linkedin.common.DisplayProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "icon", value.data());
        this._iconField = value;
        return this;
    }

    @Override
    public DisplayProperties clone() throws CloneNotSupportedException {
        DisplayProperties __clone = (DisplayProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DisplayProperties copy() throws CloneNotSupportedException {
        DisplayProperties __copy = (DisplayProperties)super.copy();
        __copy._iconField = null;
        __copy._colorHexField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DisplayProperties __objectRef;

        private ChangeListener(DisplayProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "icon": {
                    this.__objectRef._iconField = null;
                    break;
                }
                case "colorHex": {
                    this.__objectRef._colorHexField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec colorHex() {
            return new PathSpec(this.getPathComponents(), "colorHex");
        }

        public IconProperties.Fields icon() {
            return new IconProperties.Fields(this.getPathComponents(), "icon");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private IconProperties.ProjectionMask _iconMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withColorHex() {
            this.getDataMap().put("colorHex", 1);
            return this;
        }

        public ProjectionMask withIcon(Function<IconProperties.ProjectionMask, IconProperties.ProjectionMask> nestedMask) {
            this._iconMask = nestedMask.apply(this._iconMask == null ? IconProperties.createMask() : this._iconMask);
            this.getDataMap().put("icon", this._iconMask.getDataMap());
            return this;
        }

        public ProjectionMask withIcon() {
            this._iconMask = null;
            this.getDataMap().put("icon", 1);
            return this;
        }
    }
}

