/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.chart;

import com.linkedin.chart.ChartDataSourceTypeArray;
import com.linkedin.chart.ChartType;
import com.linkedin.common.AccessLevel;
import com.linkedin.common.ChangeAuditStamps;
import com.linkedin.common.EdgeArray;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChartInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.chart/**Information about a chart*/@Aspect.name=\"chartInfo\"record ChartInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Title of the chart*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}title:string/**Detailed description about the chart*/@Searchable={}description:string/**Captures information about who created/last modified/deleted this chart and when*/lastModified:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}/**URL for the chart. This could be used as an external link on DataHub to allow users access/view the chart*/@Searchable.fieldType=\"KEYWORD\"chartUrl:optional com.linkedin.common.Url/**Data sources for the chart\nDeprecated! Use inputEdges instead.*/@Relationship.`/*/string`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@deprecated,inputs:optional array[/**Input source type for a chart such as dataset or metric*/typeref ChartDataSourceType=union[{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}]]/**Data sources for the chart*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"inputEdges/*/created/actor\",\"createdOn\":\"inputEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"inputEdges/*/properties\",\"updatedActor\":\"inputEdges/*/lastModified/actor\",\"updatedOn\":\"inputEdges/*/lastModified/time\"}inputEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional Urn/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional AuditStamp/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]/**Type of the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Chart Type\"}type:optional/**The various types of charts*/enum ChartType{/**Chart showing a Bar chart*/BAR/**Chart showing a Pie chart*/PIE/**Chart showing a Scatter plot*/SCATTER/**Chart showing a table*/TABLE/**Chart showing Markdown formatted text*/TEXT,LINE,AREA,HISTOGRAM,BOX_PLOT,WORD_CLOUD,COHORT}/**Access level for the chart*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Access Level\"}access:optional{namespace com.linkedin.common/**The various access levels*/enum AccessLevel{/**Publicly available access level*/PUBLIC/**Private availability to certain set of users*/PRIVATE}}/**The time when this chart last refreshed*/lastRefreshed:optional com.linkedin.common.Time}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private String _titleField = null;
    private String _descriptionField = null;
    private ChangeAuditStamps _lastModifiedField = null;
    private Url _chartUrlField = null;
    private ChartDataSourceTypeArray _inputsField = null;
    private EdgeArray _inputEdgesField = null;
    private ChartType _typeField = null;
    private AccessLevel _accessField = null;
    private Long _lastRefreshedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Title;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_ChartUrl;
    private static final RecordDataSchema.Field FIELD_Inputs;
    private static final RecordDataSchema.Field FIELD_InputEdges;
    private static final RecordDataSchema.Field FIELD_Type;
    private static final RecordDataSchema.Field FIELD_Access;
    private static final RecordDataSchema.Field FIELD_LastRefreshed;

    public ChartInfo() {
        super(new DataMap(15, 0.75f), SCHEMA, 6);
        this.addChangeListener(this.__changeListener);
    }

    public ChartInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public ChartInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.chart.ChartInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public ChartInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public ChartInfo setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public ChartInfo setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTitle();
            }
            case DEFAULT: 
            case NULL: {
                if (this._titleField != null) {
                    return this._titleField;
                }
                Object __rawValue = this._map.get("title");
                this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._titleField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("title");
        }
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public ChartInfo setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field title of com.linkedin.chart.ChartInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public ChartInfo setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDescription();
            }
            case DEFAULT: 
            case NULL: {
                if (this._descriptionField != null) {
                    return this._descriptionField;
                }
                Object __rawValue = this._map.get("description");
                this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._descriptionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("description");
        }
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public ChartInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field description of com.linkedin.chart.ChartInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public ChartInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public ChangeAuditStamps getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastModified();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new ChangeAuditStamps(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ChangeAuditStamps getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastModified");
        }
        this._lastModifiedField = __rawValue == null ? null : new ChangeAuditStamps(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public ChartInfo setLastModified(@Nullable ChangeAuditStamps value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.chart.ChartInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public ChartInfo setLastModified(@Nonnull ChangeAuditStamps value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasChartUrl() {
        if (this._chartUrlField != null) {
            return true;
        }
        return this._map.containsKey("chartUrl");
    }

    public void removeChartUrl() {
        this._map.remove("chartUrl");
    }

    @Nullable
    public Url getChartUrl(GetMode mode) {
        return this.getChartUrl();
    }

    @Nullable
    public Url getChartUrl() {
        if (this._chartUrlField != null) {
            return this._chartUrlField;
        }
        Object __rawValue = this._map.get("chartUrl");
        this._chartUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._chartUrlField;
    }

    public ChartInfo setChartUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChartUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChartUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "chartUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._chartUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "chartUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._chartUrlField = value;
            }
        }
        return this;
    }

    public ChartInfo setChartUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field chartUrl of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "chartUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._chartUrlField = value;
        return this;
    }

    @Deprecated
    public boolean hasInputs() {
        if (this._inputsField != null) {
            return true;
        }
        return this._map.containsKey("inputs");
    }

    @Deprecated
    public void removeInputs() {
        this._map.remove("inputs");
    }

    @Deprecated
    @Nullable
    public ChartDataSourceTypeArray getInputs(GetMode mode) {
        return this.getInputs();
    }

    @Deprecated
    @Nullable
    public ChartDataSourceTypeArray getInputs() {
        if (this._inputsField != null) {
            return this._inputsField;
        }
        Object __rawValue = this._map.get("inputs");
        this._inputsField = __rawValue == null ? null : new ChartDataSourceTypeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputsField;
    }

    @Deprecated
    public ChartInfo setInputs(@Nullable ChartDataSourceTypeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputs(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputs();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
                this._inputsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
                this._inputsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public ChartInfo setInputs(@Nonnull ChartDataSourceTypeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputs of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputs", value.data());
        this._inputsField = value;
        return this;
    }

    public boolean hasInputEdges() {
        if (this._inputEdgesField != null) {
            return true;
        }
        return this._map.containsKey("inputEdges");
    }

    public void removeInputEdges() {
        this._map.remove("inputEdges");
    }

    @Nullable
    public EdgeArray getInputEdges(GetMode mode) {
        return this.getInputEdges();
    }

    @Nullable
    public EdgeArray getInputEdges() {
        if (this._inputEdgesField != null) {
            return this._inputEdgesField;
        }
        Object __rawValue = this._map.get("inputEdges");
        this._inputEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._inputEdgesField;
    }

    public ChartInfo setInputEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInputEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInputEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "inputEdges", value.data());
                this._inputEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "inputEdges", value.data());
                this._inputEdgesField = value;
            }
        }
        return this;
    }

    public ChartInfo setInputEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field inputEdges of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "inputEdges", value.data());
        this._inputEdgesField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public ChartType getType(GetMode mode) {
        return this.getType();
    }

    @Nullable
    public ChartType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, ChartType.class, ChartType.$UNKNOWN);
        return this._typeField;
    }

    public ChartInfo setType(@Nullable ChartType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public ChartInfo setType(@Nonnull ChartType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasAccess() {
        if (this._accessField != null) {
            return true;
        }
        return this._map.containsKey("access");
    }

    public void removeAccess() {
        this._map.remove("access");
    }

    @Nullable
    public AccessLevel getAccess(GetMode mode) {
        return this.getAccess();
    }

    @Nullable
    public AccessLevel getAccess() {
        if (this._accessField != null) {
            return this._accessField;
        }
        Object __rawValue = this._map.get("access");
        this._accessField = DataTemplateUtil.coerceEnumOutput(__rawValue, AccessLevel.class, AccessLevel.$UNKNOWN);
        return this._accessField;
    }

    public ChartInfo setAccess(@Nullable AccessLevel value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAccess(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAccess();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "access", value.name());
                this._accessField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "access", value.name());
                this._accessField = value;
            }
        }
        return this;
    }

    public ChartInfo setAccess(@Nonnull AccessLevel value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field access of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "access", value.name());
        this._accessField = value;
        return this;
    }

    public boolean hasLastRefreshed() {
        if (this._lastRefreshedField != null) {
            return true;
        }
        return this._map.containsKey("lastRefreshed");
    }

    public void removeLastRefreshed() {
        this._map.remove("lastRefreshed");
    }

    @Nullable
    public Long getLastRefreshed(GetMode mode) {
        return this.getLastRefreshed();
    }

    @Nullable
    public Long getLastRefreshed() {
        if (this._lastRefreshedField != null) {
            return this._lastRefreshedField;
        }
        Object __rawValue = this._map.get("lastRefreshed");
        this._lastRefreshedField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastRefreshedField;
    }

    public ChartInfo setLastRefreshed(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastRefreshed(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastRefreshed();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
                this._lastRefreshedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
                this._lastRefreshedField = value;
            }
        }
        return this;
    }

    public ChartInfo setLastRefreshed(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastRefreshed of com.linkedin.chart.ChartInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
        this._lastRefreshedField = value;
        return this;
    }

    public ChartInfo setLastRefreshed(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
        this._lastRefreshedField = value;
        return this;
    }

    @Override
    public ChartInfo clone() throws CloneNotSupportedException {
        ChartInfo __clone = (ChartInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ChartInfo copy() throws CloneNotSupportedException {
        ChartInfo __copy = (ChartInfo)super.copy();
        __copy._externalUrlField = null;
        __copy._lastRefreshedField = null;
        __copy._customPropertiesField = null;
        __copy._accessField = null;
        __copy._inputsField = null;
        __copy._descriptionField = null;
        __copy._lastModifiedField = null;
        __copy._titleField = null;
        __copy._typeField = null;
        __copy._inputEdgesField = null;
        __copy._chartUrlField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Title = SCHEMA.getField("title");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_ChartUrl = SCHEMA.getField("chartUrl");
        FIELD_Inputs = SCHEMA.getField("inputs");
        FIELD_InputEdges = SCHEMA.getField("inputEdges");
        FIELD_Type = SCHEMA.getField("type");
        FIELD_Access = SCHEMA.getField("access");
        FIELD_LastRefreshed = SCHEMA.getField("lastRefreshed");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ChartInfo __objectRef;

        private ChangeListener(ChartInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "lastRefreshed": {
                    this.__objectRef._lastRefreshedField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "access": {
                    this.__objectRef._accessField = null;
                    break;
                }
                case "inputs": {
                    this.__objectRef._inputsField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "inputEdges": {
                    this.__objectRef._inputEdgesField = null;
                    break;
                }
                case "chartUrl": {
                    this.__objectRef._chartUrlField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public ChangeAuditStamps.Fields lastModified() {
            return new ChangeAuditStamps.Fields(this.getPathComponents(), "lastModified");
        }

        public PathSpec chartUrl() {
            return new PathSpec(this.getPathComponents(), "chartUrl");
        }

        @Deprecated
        public ChartDataSourceTypeArray.Fields inputs() {
            return new ChartDataSourceTypeArray.Fields(this.getPathComponents(), "inputs");
        }

        @Deprecated
        public PathSpec inputs(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputs");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields inputEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "inputEdges");
        }

        public PathSpec inputEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "inputEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec access() {
            return new PathSpec(this.getPathComponents(), "access");
        }

        public PathSpec lastRefreshed() {
            return new PathSpec(this.getPathComponents(), "lastRefreshed");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private ChangeAuditStamps.ProjectionMask _lastModifiedMask;
        private ChartDataSourceTypeArray.ProjectionMask _inputsMask;
        private EdgeArray.ProjectionMask _inputEdgesMask;

        ProjectionMask() {
            super(15);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<ChangeAuditStamps.ProjectionMask, ChangeAuditStamps.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? ChangeAuditStamps.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withChartUrl() {
            this.getDataMap().put("chartUrl", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withInputs(Function<ChartDataSourceTypeArray.ProjectionMask, ChartDataSourceTypeArray.ProjectionMask> nestedMask) {
            this._inputsMask = nestedMask.apply(this._inputsMask == null ? ChartDataSourceTypeArray.createMask() : this._inputsMask);
            this.getDataMap().put("inputs", this._inputsMask.getDataMap());
            return this;
        }

        @Deprecated
        public ProjectionMask withInputs() {
            this._inputsMask = null;
            this.getDataMap().put("inputs", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withInputs(Function<ChartDataSourceTypeArray.ProjectionMask, ChartDataSourceTypeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._inputsMask = nestedMask.apply(this._inputsMask == null ? ChartDataSourceTypeArray.createMask() : this._inputsMask);
            this.getDataMap().put("inputs", this._inputsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("inputs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputs").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withInputs(Integer start, Integer count) {
            this._inputsMask = null;
            this.getDataMap().put("inputs", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputs").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputs").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._inputEdgesMask = nestedMask.apply(this._inputEdgesMask == null ? EdgeArray.createMask() : this._inputEdgesMask);
            this.getDataMap().put("inputEdges", this._inputEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withInputEdges() {
            this._inputEdgesMask = null;
            this.getDataMap().put("inputEdges", 1);
            return this;
        }

        public ProjectionMask withInputEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._inputEdgesMask = nestedMask.apply(this._inputEdgesMask == null ? EdgeArray.createMask() : this._inputEdgesMask);
            this.getDataMap().put("inputEdges", this._inputEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("inputEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withInputEdges(Integer start, Integer count) {
            this._inputEdgesMask = null;
            this.getDataMap().put("inputEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("inputEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("inputEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withAccess() {
            this.getDataMap().put("access", 1);
            return this;
        }

        public ProjectionMask withLastRefreshed() {
            this.getDataMap().put("lastRefreshed", 1);
            return this;
        }
    }
}

