/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.avro2pegasus.events;

import com.linkedin.avro2pegasus.events.UUID;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KafkaAuditHeader
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.avro2pegasus.events/**This header records information about the context of an event as it is emitted into kafka and is intended to be used by the kafka audit application.  For more information see go/kafkaauditheader*/record KafkaAuditHeader{/**The time at which the event was emitted into kafka.*/@compliance=[{\"policy\":\"EVENT_TIME\"}]time:long/**The fully qualified name of the host from which the event is being emitted.*/@compliance=\"NONE\"server:string/**The instance on the server from which the event is being emitted. e.g. i001*/@compliance=\"NONE\"instance:optional string/**The name of the application from which the event is being emitted. see go/appname*/@compliance=\"NONE\"appName:string/**A unique identifier for the message*/@compliance=\"NONE\"messageId:fixed UUID 16/**The version that is being used for auditing. In version 0, the audit trail buckets events into 10 minute audit windows based on the EventHeader timestamp. In version 1, the audit trail buckets events as follows: if the schema has an outer KafkaAuditHeader, use the outer audit header timestamp for bucketing; else if the EventHeader has an inner KafkaAuditHeader use that inner audit header's timestamp for bucketing*/@compliance=\"NONE\"auditVersion:optional int/**The fabricUrn of the host from which the event is being emitted. Fabric Urn in the format of urn:li:fabric:{fabric_name}. See go/fabric.*/@compliance=\"NONE\"fabricUrn:optional string/**This is a String that the client uses to establish some kind of connection with the Kafka cluster. The exact format of it depends on specific versions of clients and brokers. This information could potentially identify the fabric and cluster with which the client is producing to or consuming from.*/@compliance=\"NONE\"clusterConnectionString:optional string}", SchemaFormatType.PDL);
    private Long _timeField = null;
    private String _serverField = null;
    private String _instanceField = null;
    private String _appNameField = null;
    private UUID _messageIdField = null;
    private Integer _auditVersionField = null;
    private String _fabricUrnField = null;
    private String _clusterConnectionStringField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Time = SCHEMA.getField("time");
    private static final RecordDataSchema.Field FIELD_Server = SCHEMA.getField("server");
    private static final RecordDataSchema.Field FIELD_Instance = SCHEMA.getField("instance");
    private static final RecordDataSchema.Field FIELD_AppName = SCHEMA.getField("appName");
    private static final RecordDataSchema.Field FIELD_MessageId = SCHEMA.getField("messageId");
    private static final RecordDataSchema.Field FIELD_AuditVersion = SCHEMA.getField("auditVersion");
    private static final RecordDataSchema.Field FIELD_FabricUrn = SCHEMA.getField("fabricUrn");
    private static final RecordDataSchema.Field FIELD_ClusterConnectionString = SCHEMA.getField("clusterConnectionString");

    public KafkaAuditHeader() {
        super(new DataMap(11, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public KafkaAuditHeader(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTime() {
        if (this._timeField != null) {
            return true;
        }
        return this._map.containsKey("time");
    }

    public void removeTime() {
        this._map.remove("time");
    }

    @Nullable
    public Long getTime(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTime();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timeField != null) {
                    return this._timeField;
                }
                Object __rawValue = this._map.get("time");
                this._timeField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTime() {
        if (this._timeField != null) {
            return this._timeField;
        }
        Object __rawValue = this._map.get("time");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("time");
        }
        this._timeField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timeField;
    }

    public KafkaAuditHeader setTime(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTime(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field time of com.linkedin.avro2pegasus.events.KafkaAuditHeader");
                }
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTime();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
                this._timeField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setTime(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field time of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
        this._timeField = value;
        return this;
    }

    public KafkaAuditHeader setTime(long value) {
        CheckedUtil.putWithoutChecking(this._map, "time", DataTemplateUtil.coerceLongInput(value));
        this._timeField = value;
        return this;
    }

    public boolean hasServer() {
        if (this._serverField != null) {
            return true;
        }
        return this._map.containsKey("server");
    }

    public void removeServer() {
        this._map.remove("server");
    }

    @Nullable
    public String getServer(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getServer();
            }
            case DEFAULT: 
            case NULL: {
                if (this._serverField != null) {
                    return this._serverField;
                }
                Object __rawValue = this._map.get("server");
                this._serverField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._serverField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getServer() {
        if (this._serverField != null) {
            return this._serverField;
        }
        Object __rawValue = this._map.get("server");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("server");
        }
        this._serverField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._serverField;
    }

    public KafkaAuditHeader setServer(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setServer(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field server of com.linkedin.avro2pegasus.events.KafkaAuditHeader");
                }
                CheckedUtil.putWithoutChecking(this._map, "server", value);
                this._serverField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeServer();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "server", value);
                this._serverField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "server", value);
                this._serverField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setServer(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field server of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "server", value);
        this._serverField = value;
        return this;
    }

    public boolean hasInstance() {
        if (this._instanceField != null) {
            return true;
        }
        return this._map.containsKey("instance");
    }

    public void removeInstance() {
        this._map.remove("instance");
    }

    @Nullable
    public String getInstance(GetMode mode) {
        return this.getInstance();
    }

    @Nullable
    public String getInstance() {
        if (this._instanceField != null) {
            return this._instanceField;
        }
        Object __rawValue = this._map.get("instance");
        this._instanceField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._instanceField;
    }

    public KafkaAuditHeader setInstance(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInstance(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInstance();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "instance", value);
                this._instanceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "instance", value);
                this._instanceField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setInstance(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field instance of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "instance", value);
        this._instanceField = value;
        return this;
    }

    public boolean hasAppName() {
        if (this._appNameField != null) {
            return true;
        }
        return this._map.containsKey("appName");
    }

    public void removeAppName() {
        this._map.remove("appName");
    }

    @Nullable
    public String getAppName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAppName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._appNameField != null) {
                    return this._appNameField;
                }
                Object __rawValue = this._map.get("appName");
                this._appNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._appNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getAppName() {
        if (this._appNameField != null) {
            return this._appNameField;
        }
        Object __rawValue = this._map.get("appName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("appName");
        }
        this._appNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._appNameField;
    }

    public KafkaAuditHeader setAppName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAppName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field appName of com.linkedin.avro2pegasus.events.KafkaAuditHeader");
                }
                CheckedUtil.putWithoutChecking(this._map, "appName", value);
                this._appNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAppName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "appName", value);
                this._appNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "appName", value);
                this._appNameField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setAppName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field appName of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "appName", value);
        this._appNameField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public UUID getMessageId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getMessageId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._messageIdField != null) {
                    return this._messageIdField;
                }
                Object __rawValue = this._map.get("messageId");
                this._messageIdField = __rawValue == null ? null : new UUID(__rawValue);
                return this._messageIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UUID getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("messageId");
        }
        this._messageIdField = __rawValue == null ? null : new UUID(__rawValue);
        return this._messageIdField;
    }

    public KafkaAuditHeader setMessageId(@Nullable UUID value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field messageId of com.linkedin.avro2pegasus.events.KafkaAuditHeader");
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value.data());
                this._messageIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value.data());
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value.data());
                this._messageIdField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setMessageId(@Nonnull UUID value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value.data());
        this._messageIdField = value;
        return this;
    }

    public boolean hasAuditVersion() {
        if (this._auditVersionField != null) {
            return true;
        }
        return this._map.containsKey("auditVersion");
    }

    public void removeAuditVersion() {
        this._map.remove("auditVersion");
    }

    @Nullable
    public Integer getAuditVersion(GetMode mode) {
        return this.getAuditVersion();
    }

    @Nullable
    public Integer getAuditVersion() {
        if (this._auditVersionField != null) {
            return this._auditVersionField;
        }
        Object __rawValue = this._map.get("auditVersion");
        this._auditVersionField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._auditVersionField;
    }

    public KafkaAuditHeader setAuditVersion(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditVersion", DataTemplateUtil.coerceIntInput(value));
                this._auditVersionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditVersion", DataTemplateUtil.coerceIntInput(value));
                this._auditVersionField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setAuditVersion(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditVersion of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditVersion", DataTemplateUtil.coerceIntInput(value));
        this._auditVersionField = value;
        return this;
    }

    public KafkaAuditHeader setAuditVersion(int value) {
        CheckedUtil.putWithoutChecking(this._map, "auditVersion", DataTemplateUtil.coerceIntInput(value));
        this._auditVersionField = value;
        return this;
    }

    public boolean hasFabricUrn() {
        if (this._fabricUrnField != null) {
            return true;
        }
        return this._map.containsKey("fabricUrn");
    }

    public void removeFabricUrn() {
        this._map.remove("fabricUrn");
    }

    @Nullable
    public String getFabricUrn(GetMode mode) {
        return this.getFabricUrn();
    }

    @Nullable
    public String getFabricUrn() {
        if (this._fabricUrnField != null) {
            return this._fabricUrnField;
        }
        Object __rawValue = this._map.get("fabricUrn");
        this._fabricUrnField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._fabricUrnField;
    }

    public KafkaAuditHeader setFabricUrn(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFabricUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFabricUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fabricUrn", value);
                this._fabricUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fabricUrn", value);
                this._fabricUrnField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setFabricUrn(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fabricUrn of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fabricUrn", value);
        this._fabricUrnField = value;
        return this;
    }

    public boolean hasClusterConnectionString() {
        if (this._clusterConnectionStringField != null) {
            return true;
        }
        return this._map.containsKey("clusterConnectionString");
    }

    public void removeClusterConnectionString() {
        this._map.remove("clusterConnectionString");
    }

    @Nullable
    public String getClusterConnectionString(GetMode mode) {
        return this.getClusterConnectionString();
    }

    @Nullable
    public String getClusterConnectionString() {
        if (this._clusterConnectionStringField != null) {
            return this._clusterConnectionStringField;
        }
        Object __rawValue = this._map.get("clusterConnectionString");
        this._clusterConnectionStringField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._clusterConnectionStringField;
    }

    public KafkaAuditHeader setClusterConnectionString(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setClusterConnectionString(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeClusterConnectionString();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "clusterConnectionString", value);
                this._clusterConnectionStringField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "clusterConnectionString", value);
                this._clusterConnectionStringField = value;
            }
        }
        return this;
    }

    public KafkaAuditHeader setClusterConnectionString(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field clusterConnectionString of com.linkedin.avro2pegasus.events.KafkaAuditHeader to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "clusterConnectionString", value);
        this._clusterConnectionStringField = value;
        return this;
    }

    @Override
    public KafkaAuditHeader clone() throws CloneNotSupportedException {
        KafkaAuditHeader __clone = (KafkaAuditHeader)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public KafkaAuditHeader copy() throws CloneNotSupportedException {
        KafkaAuditHeader __copy = (KafkaAuditHeader)super.copy();
        __copy._auditVersionField = null;
        __copy._serverField = null;
        __copy._instanceField = null;
        __copy._appNameField = null;
        __copy._clusterConnectionStringField = null;
        __copy._messageIdField = null;
        __copy._timeField = null;
        __copy._fabricUrnField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final KafkaAuditHeader __objectRef;

        private ChangeListener(KafkaAuditHeader reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "auditVersion": {
                    this.__objectRef._auditVersionField = null;
                    break;
                }
                case "server": {
                    this.__objectRef._serverField = null;
                    break;
                }
                case "instance": {
                    this.__objectRef._instanceField = null;
                    break;
                }
                case "appName": {
                    this.__objectRef._appNameField = null;
                    break;
                }
                case "clusterConnectionString": {
                    this.__objectRef._clusterConnectionStringField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "time": {
                    this.__objectRef._timeField = null;
                    break;
                }
                case "fabricUrn": {
                    this.__objectRef._fabricUrnField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec time() {
            return new PathSpec(this.getPathComponents(), "time");
        }

        public PathSpec server() {
            return new PathSpec(this.getPathComponents(), "server");
        }

        public PathSpec instance() {
            return new PathSpec(this.getPathComponents(), "instance");
        }

        public PathSpec appName() {
            return new PathSpec(this.getPathComponents(), "appName");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec auditVersion() {
            return new PathSpec(this.getPathComponents(), "auditVersion");
        }

        public PathSpec fabricUrn() {
            return new PathSpec(this.getPathComponents(), "fabricUrn");
        }

        public PathSpec clusterConnectionString() {
            return new PathSpec(this.getPathComponents(), "clusterConnectionString");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(11);
        }

        public ProjectionMask withTime() {
            this.getDataMap().put("time", 1);
            return this;
        }

        public ProjectionMask withServer() {
            this.getDataMap().put("server", 1);
            return this;
        }

        public ProjectionMask withInstance() {
            this.getDataMap().put("instance", 1);
            return this;
        }

        public ProjectionMask withAppName() {
            this.getDataMap().put("appName", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withAuditVersion() {
            this.getDataMap().put("auditVersion", 1);
            return this;
        }

        public ProjectionMask withFabricUrn() {
            this.getDataMap().put("fabricUrn", 1);
            return this;
        }

        public ProjectionMask withClusterConnectionString() {
            this.getDataMap().put("clusterConnectionString", 1);
            return this;
        }
    }
}

